/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.matrix;

import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.ILispVector;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.math.matrix.AbstractImmutableLispMatrix;
import net.morilib.lisp.math.matrix.ILispMatrix;
import net.morilib.lisp.math.matrix.ILispNumberVector;
import net.morilib.lisp.math.matrix.LUDecomposedLMatrix;
import net.morilib.lisp.math.matrix.LUDecomposedUMatrix;
import net.morilib.lisp.math.matrix.LispMatrix;
import net.morilib.lisp.math.matrix.LispMatrixException;
import net.morilib.lisp.math.matrix.LispPermutationMatrix;
import net.morilib.lisp.matrix.ILispDatumMatrix;
import net.morilib.lisp.matrix.LispDatumMatrix;
import net.morilib.util.Strings;

public final class LispMatrices {
    private LispMatrices() {
    }

    public static void print(StringBuilder b, ILispDatumMatrix matrix) {
        String s;
        Datum d;
        int j;
        int l = -1;
        String dlm = "";
        int i = 0;
        while (i < matrix.rowSize()) {
            j = 0;
            while (j < matrix.columnSize()) {
                d = matrix.get(i, j);
                s = LispUtils.print(d);
                l = l < s.length() ? s.length() : l;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < matrix.rowSize()) {
            b.append("[");
            dlm = "";
            j = 0;
            while (j < matrix.columnSize()) {
                d = matrix.get(i, j);
                s = LispUtils.print(d);
                b.append(dlm).append(Strings.rpad(s, l));
                dlm = " ";
                ++j;
            }
            b.append("]\n");
            ++i;
        }
    }

    public static ILispMatrix toList(Datum x, LispMessage mesg) {
        ConsIterator i = new ConsIterator(x);
        int cls = -1;
        int cl0 = 0;
        int rws = 0;
        while (i.hasNext()) {
            ConsIterator j = new ConsIterator(i.next());
            while (j.hasNext()) {
                Datum jn = j.next();
                if (!(jn instanceof LispNumber)) {
                    throw mesg.getError("err.require.number", jn);
                }
                ++cl0;
            }
            if (cls < 0) {
                cls = cl0;
            } else if (cls != cl0) {
                throw mesg.getError("err.matrix.require.samecolumnsize");
            }
            cl0 = 0;
            ++rws;
        }
        if (cls <= 0 || rws <= 0) {
            throw mesg.getError("err.matrix.require.listoflist", x);
        }
        LispMatrix m = new LispMatrix(rws, cls);
        LispMatrices.setMatrix(m, x);
        return m;
    }

    private static void setMatrix(LispMatrix m, Datum x) {
        ConsIterator i = new ConsIterator(x);
        int cls = 0;
        int rws = 0;
        while (i.hasNext()) {
            ConsIterator j = new ConsIterator(i.next());
            while (j.hasNext()) {
                m.set(rws, cls, j.next());
                ++cls;
            }
            ++rws;
            cls = 0;
        }
    }

    public static LispDatumMatrix consTensorProduct(ILispVector r, ILispVector c) {
        LispDatumMatrix m = new LispDatumMatrix(r.size(), c.size());
        int i = 0;
        while (i < r.size()) {
            int j = 0;
            while (j < c.size()) {
                m.set(i, j, new Cons(r.get(i), c.get(j)));
                ++j;
            }
            ++i;
        }
        return m;
    }

    public static AbstractImmutableLispMatrix[] decomposeLU(ILispMatrix a) throws LispMatrixException {
        LispMatrix r = new LispMatrix(a);
        int parity = 0;
        if (a.rowSize() != a.columnSize()) {
            throw new LispMatrixException();
        }
        int[] order = new int[a.rowSize()];
        int i = 0;
        while (i < a.rowSize()) {
            order[i] = i;
            ++i;
        }
        i = 0;
        while (i < a.rowSize() - 1) {
            int d = i;
            LispReal mx = r.get(i, i).norm();
            int j = i + 1;
            while (j < a.columnSize()) {
                if (mx.compareTo(r.get(j, i).norm()) < 0) {
                    d = j;
                    mx = r.get(j, i).norm();
                }
                ++j;
            }
            if (d != i) {
                int swp = order[i];
                order[i] = order[d];
                order[d] = swp;
                ++parity;
                j = 0;
                while (j < a.columnSize()) {
                    LispNumber swp2 = r.get(i, j);
                    r.set(i, j, r.get(d, j));
                    r.set(d, j, swp2);
                    ++j;
                }
            }
            if (r.get(i, i).norm().signum() != 0) {
                j = i + 1;
                while (j < a.columnSize()) {
                    LispNumber x = r.get(j, i);
                    x = x.div(r.get(i, i));
                    r.set(j, i, x);
                    int k = i + 1;
                    while (k < a.rowSize()) {
                        LispNumber y = r.get(j, k);
                        y = y.sub(x.mul(r.get(i, k)));
                        r.set(j, k, y);
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        int[] order1 = new int[order.length];
        i = 0;
        while (i < order.length) {
            order1[order[i]] = i;
            ++i;
        }
        return new AbstractImmutableLispMatrix[]{new LispPermutationMatrix(order1, parity), new LUDecomposedLMatrix(r), new LUDecomposedUMatrix(r)};
    }

    public static ILispMatrix unmodifiable(ILispMatrix x) {
        return x instanceof Umd ? x : new Umd(x);
    }

    public static ILispNumberVector solve(ILispMatrix a, ILispNumberVector b) throws LispMatrixException {
        int j;
        if (a.rowSize() != a.columnSize()) {
            throw new LispMatrixException("err.matrix.require.squarematrix");
        }
        if (a.rowSize() != b.size()) {
            throw new LispMatrixException("err.matrix.require.samesize");
        }
        AbstractImmutableLispMatrix[] dec = LispMatrices.decomposeLU(a);
        ILispNumberVector x = dec[0].inv().mul(b);
        int i = 1;
        while (i < a.rowSize()) {
            j = 0;
            while (j < i) {
                x.set(i, x.get(i).sub(x.get(j).mul(dec[1].get(i, j))));
                ++j;
            }
            ++i;
        }
        i = a.rowSize() - 1;
        while (i >= 0) {
            if (dec[2].get(i, i).isZero()) {
                throw new LispMatrixException("err.matrix.require.regular");
            }
            x.set(i, x.get(i).div(dec[2].get(i, i)));
            j = i - 1;
            while (j >= 0) {
                x.set(j, x.get(j).sub(x.get(i).mul(dec[2].get(j, i))));
                --j;
            }
            --i;
        }
        return x;
    }

    private static class Umd
    extends AbstractImmutableLispMatrix {
        private ILispMatrix a;

        private Umd(ILispMatrix a) {
            this.a = a;
        }

        public LispNumber get(int row, int column) {
            return this.a.get(row, column);
        }

        public int rowSize() {
            return this.a.rowSize();
        }

        public int columnSize() {
            return this.a.columnSize();
        }

        public LispNumber determinant() throws LispMatrixException {
            return this.a.determinant();
        }

        public ILispMatrix inv() throws LispMatrixException {
            return this.a.inv();
        }
    }
}

