/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.matrix;

import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.math.matrix.AbstractImmutableLispMatrix;
import net.morilib.lisp.math.matrix.ILispMatrix;
import net.morilib.lisp.math.matrix.LispMatrix;

public class LUDecomposedLMatrix
extends AbstractImmutableLispMatrix {
    private ILispMatrix a;

    LUDecomposedLMatrix(ILispMatrix a) {
        this.a = a;
    }

    public LispNumber get(int row, int column) {
        if (row > column) {
            return this.a.get(row, column);
        }
        if (row == column) {
            return LispInteger.ONE;
        }
        return LispInteger.ZERO;
    }

    public int rowSize() {
        return this.a.rowSize();
    }

    public int columnSize() {
        return this.a.columnSize();
    }

    public LispNumber determinant() {
        return LispInteger.ONE;
    }

    public ILispMatrix inv() {
        LispMatrix r = new LispMatrix(this);
        int c = 1;
        while (c < this.columnSize()) {
            int i = c;
            while (i < this.rowSize()) {
                int j = i - c;
                LispNumber x = LispInteger.ZERO;
                int k = j + 1;
                while (k <= i) {
                    x = ((LispNumber)x).add(r.get(i, k).mul(this.get(k, j)));
                    ++k;
                }
                r.set(i, j, ((LispNumber)x).uminus());
                ++i;
            }
            ++c;
        }
        return r;
    }
}

