/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.matrix;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.math.LispPermutation;
import net.morilib.lisp.math.matrix.AbstractImmutableLispMatrix;
import net.morilib.lisp.math.matrix.ILispMatrix;
import net.morilib.lisp.math.matrix.ILispNumberVector;
import net.morilib.lisp.math.matrix.LispMatrices;
import net.morilib.lisp.math.matrix.LispMatrix;
import net.morilib.lisp.math.matrix.LispMatrixException;
import net.morilib.lisp.math.matrix.LispNumberVector;
import net.morilib.lisp.uvector.HomogeneousUnsignedArray;

public abstract class AbstractLispMatrix
extends Datum2
implements ILispMatrix {
    public ILispNumberVector getRowVector(int row) {
        LispNumber[] r = new LispNumber[this.columnSize()];
        if (row < 0 || row >= this.rowSize()) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        while (i < this.columnSize()) {
            r[i] = this.get(row, i);
            ++i;
        }
        return new LispNumberVector(r);
    }

    public ILispNumberVector getColumnVector(int column) {
        LispNumber[] ra = new LispNumber[this.columnSize()];
        if (column < 0 || column >= this.columnSize()) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        while (i < this.rowSize()) {
            ra[i] = this.get(i, column);
            ++i;
        }
        return new LispNumberVector(ra);
    }

    public ILispMatrix transpose() {
        LispMatrix r = new LispMatrix(this);
        int i = 0;
        while (i < this.rowSize()) {
            int j = 0;
            while (j < this.columnSize()) {
                r.set(j, i, this.get(i, j));
                ++j;
            }
            ++i;
        }
        return r;
    }

    public ILispMatrix adjoint() {
        LispMatrix r = new LispMatrix(this);
        int i = 0;
        while (i < this.rowSize()) {
            int j = 0;
            while (j < this.columnSize()) {
                r.set(j, i, this.get(i, j).conjugate());
                ++j;
            }
            ++i;
        }
        return r;
    }

    public ILispMatrix add(ILispMatrix a) throws LispMatrixException {
        if (this.rowSize() != a.rowSize() || this.columnSize() != a.columnSize()) {
            throw new LispMatrixException();
        }
        LispMatrix r = new LispMatrix(this);
        int i = 0;
        while (i < this.rowSize()) {
            int j = 0;
            while (j < this.columnSize()) {
                r.set(i, j, r.get(i, j).add(a.get(i, j)));
                ++j;
            }
            ++i;
        }
        return r;
    }

    public ILispMatrix sub(ILispMatrix a) throws LispMatrixException {
        if (this.rowSize() != a.rowSize() || this.columnSize() != a.columnSize()) {
            throw new LispMatrixException();
        }
        LispMatrix r = new LispMatrix(this);
        int i = 0;
        while (i < this.rowSize()) {
            int j = 0;
            while (j < this.columnSize()) {
                r.set(i, j, r.get(i, j).sub(a.get(i, j)));
                ++j;
            }
            ++i;
        }
        return r;
    }

    public ILispNumberVector mul(ILispNumberVector a) throws LispMatrixException {
        if (this.columnSize() != a.size()) {
            throw new LispMatrixException();
        }
        LispNumberVector v = new LispNumberVector(this.columnSize());
        int i = 0;
        while (i < this.rowSize()) {
            LispNumber x = LispInteger.ZERO;
            int k = 0;
            while (k < this.columnSize()) {
                x = ((LispNumber)x).add(this.get(i, k).mul(a.get(k)));
                ++k;
            }
            v.set(i, x);
            ++i;
        }
        return v;
    }

    public ILispMatrix mul(LispNumber a) {
        LispMatrix r = new LispMatrix(this);
        int i = 0;
        while (i < this.rowSize()) {
            int j = 0;
            while (j < this.columnSize()) {
                r.set(i, j, r.get(i, j).mul(a));
                ++j;
            }
            ++i;
        }
        return r;
    }

    public ILispMatrix uminus() {
        LispMatrix r = new LispMatrix(this);
        int i = 0;
        while (i < this.rowSize()) {
            int j = 0;
            while (j < this.columnSize()) {
                r.set(i, j, r.get(i, j).uminus());
                ++j;
            }
            ++i;
        }
        return r;
    }

    public ILispMatrix mul(ILispMatrix a) throws LispMatrixException {
        if (this.columnSize() != a.rowSize()) {
            throw new LispMatrixException();
        }
        LispMatrix m = new LispMatrix(this.rowSize(), a.columnSize());
        int i = 0;
        while (i < this.rowSize()) {
            int j = 0;
            while (j < a.columnSize()) {
                LispNumber x = LispInteger.ZERO;
                int k = 0;
                while (k < this.columnSize()) {
                    x = ((LispNumber)x).add(this.get(i, k).mul(a.get(k, j)));
                    ++k;
                }
                m.set(i, j, x);
                ++j;
            }
            ++i;
        }
        return m;
    }

    public boolean isHermite() {
        int i = 0;
        while (i < this.rowSize()) {
            int j = 0;
            while (j <= i) {
                if (!this.get(i, j).equals(this.get(j, i).conjugate())) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public LispNumber determinant() throws LispMatrixException {
        if (this.columnSize() != this.rowSize()) {
            throw new LispMatrixException();
        }
        AbstractImmutableLispMatrix[] decomposed = LispMatrices.decomposeLU(this);
        return decomposed[0].determinant().mul(decomposed[2].determinant());
    }

    public ILispMatrix inv() throws LispMatrixException {
        if (this.columnSize() != this.rowSize()) {
            throw new LispMatrixException();
        }
        AbstractImmutableLispMatrix[] decomposed = LispMatrices.decomposeLU(this);
        ILispMatrix x = decomposed[2].inv();
        ILispMatrix y = decomposed[1].inv();
        x = x.mul(y);
        y = decomposed[0].inv();
        x = x.mul(y);
        return x;
    }

    public ILispMatrix changeRow(final LispPermutation rowp) {
        if (rowp.size() != this.rowSize()) {
            throw new IllegalArgumentException();
        }
        return new AbstractLispMatrix(){

            public LispNumber get(int row, int column) {
                return AbstractLispMatrix.this.get(rowp.get(row), column);
            }

            public void set(int row, int column, Datum x) throws LispMatrixException {
                AbstractLispMatrix.this.set(rowp.get(row), column, x);
            }

            public int rowSize() {
                return AbstractLispMatrix.this.rowSize();
            }

            public int columnSize() {
                return AbstractLispMatrix.this.columnSize();
            }
        };
    }

    public ILispMatrix changeColumn(final LispPermutation colp) {
        if (colp.size() != this.columnSize()) {
            throw new IllegalArgumentException();
        }
        return new AbstractLispMatrix(){

            public LispNumber get(int row, int column) {
                return AbstractLispMatrix.this.get(row, colp.get(column));
            }

            public void set(int row, int column, Datum x) throws LispMatrixException {
                AbstractLispMatrix.this.set(row, colp.get(column), x);
            }

            public int rowSize() {
                return AbstractLispMatrix.this.rowSize();
            }

            public int columnSize() {
                return AbstractLispMatrix.this.columnSize();
            }
        };
    }

    public ILispMatrix submatrix(final int rowb, final int rowe, final int colb, final int cole) {
        if (rowb < 0 || rowb >= this.rowSize()) {
            throw new IndexOutOfBoundsException();
        }
        if (rowe < 0 || rowe >= this.rowSize()) {
            throw new IndexOutOfBoundsException();
        }
        if (colb < 0 || colb >= this.columnSize()) {
            throw new IndexOutOfBoundsException();
        }
        if (cole < 0 || cole >= this.columnSize()) {
            throw new IndexOutOfBoundsException();
        }
        if (rowe <= rowb) {
            throw new IllegalArgumentException();
        }
        if (cole <= colb) {
            throw new IllegalArgumentException();
        }
        return new AbstractLispMatrix(){

            public LispNumber get(int row, int column) {
                if (row < 0 || row >= rowe - rowb) {
                    throw new IndexOutOfBoundsException();
                }
                if (column < 0 || column >= cole - colb) {
                    throw new IndexOutOfBoundsException();
                }
                return AbstractLispMatrix.this.get(row + rowb, column + colb);
            }

            public void set(int row, int column, Datum x) throws LispMatrixException {
                if (row < 0 || row >= rowe - rowb) {
                    throw new IndexOutOfBoundsException();
                }
                if (column < 0 || column >= cole - colb) {
                    throw new IndexOutOfBoundsException();
                }
                AbstractLispMatrix.this.set(row + rowb, column + colb, x);
            }

            public int rowSize() {
                return rowe - rowb;
            }

            public int columnSize() {
                return cole - colb;
            }
        };
    }

    public ILispMatrix submatrix(final HomogeneousUnsignedArray rowa, final HomogeneousUnsignedArray cola) throws LispMatrixException {
        int i = 0;
        while (i < rowa.size()) {
            if (!(rowa.get(i) instanceof LispSmallInt)) {
                throw new LispMatrixException("err.require.smallint");
            }
            if (rowa.get(i).getInt() >= this.rowSize()) {
                throw new LispMatrixException("err.range.invalid");
            }
            ++i;
        }
        i = 0;
        while (i < cola.size()) {
            if (!(cola.get(i) instanceof LispSmallInt)) {
                throw new LispMatrixException("err.require.smallint");
            }
            if (cola.get(i).getInt() >= this.columnSize()) {
                throw new LispMatrixException("err.range.invalid");
            }
            ++i;
        }
        return new AbstractLispMatrix(){

            public LispNumber get(int row, int column) {
                return AbstractLispMatrix.this.get(rowa.get(row).getInt(), cola.get(column).getInt());
            }

            public void set(int row, int column, Datum x) throws LispMatrixException {
                AbstractLispMatrix.this.set(rowa.get(row).getInt(), cola.get(column).getInt(), x);
            }

            public int rowSize() {
                return rowa.size();
            }

            public int columnSize() {
                return cola.size();
            }
        };
    }

    public int hashCode() {
        int r = 17;
        int i = 0;
        while (i < this.rowSize()) {
            int j = 0;
            while (j < this.columnSize()) {
                r = 37 * (r + this.get(i, j).hashCode());
                ++j;
            }
            ++i;
        }
        return r;
    }

    public boolean equals(Object o) {
        if (o instanceof ILispMatrix) {
            ILispMatrix y = (ILispMatrix)o;
            if (this.rowSize() != y.rowSize() || this.columnSize() != y.columnSize()) {
                return false;
            }
            int i = 0;
            while (i < this.rowSize()) {
                int j = 0;
                while (j < this.columnSize()) {
                    if (!this.get(i, j).equals(y.get(i, j))) {
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isEqualTo(ILispMatrix y) {
        if (this.rowSize() != y.rowSize() || this.columnSize() != y.columnSize()) {
            return false;
        }
        int i = 0;
        while (i < this.rowSize()) {
            int j = 0;
            while (j < this.columnSize()) {
                if (!this.get(i, j).isEqualTo(y.get(i, j))) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public void toDisplayString(StringBuilder buf) {
        LispMatrices.print(buf, this);
    }
}

