/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.matrix;

import net.morilib.lisp.Datum;
import net.morilib.lisp.ILispVector;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.math.matrix.AbstractLispMatrix;
import net.morilib.lisp.math.matrix.ILispMatrix;
import net.morilib.lisp.math.matrix.ILispNumberVector;
import net.morilib.lisp.math.matrix.LispMatrices;
import net.morilib.lisp.math.matrix.LispNumberVector;
import net.morilib.lisp.matrix.ILispDatumMatrix;

public abstract class AbstractLispArrayMatrix
extends AbstractLispMatrix
implements ILispMatrix,
ILispVector,
Cloneable {
    protected int rows;
    protected int columns;

    protected abstract LispNumber array(int var1);

    protected abstract void arrayset(int var1, Datum var2);

    protected abstract AbstractLispArrayMatrix prototype();

    protected abstract AbstractLispArrayMatrix prototype(int var1, int var2);

    public abstract ILispDatumMatrix clone();

    protected abstract void arraycopy(int var1, Object var2, int var3, int var4);

    public LispNumber get(int row, int column) {
        if (row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException();
        }
        if (column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException();
        }
        return this.array(row * this.columns + column);
    }

    public ILispNumberVector getRowVector(int row) {
        LispNumber[] ra = new LispNumber[this.columns];
        if (row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException();
        }
        this.arraycopy(row * this.columns, ra, 0, this.columns);
        return new LispNumberVector(ra);
    }

    public int rowSize() {
        return this.rows;
    }

    public int columnSize() {
        return this.columns;
    }

    public Datum get(int index) {
        return this.array(index);
    }

    public int size() {
        return this.rows * this.columns;
    }

    public void set(int row, int column, Datum x) {
        if (row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException();
        }
        if (column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException();
        }
        this.arrayset(row * this.columns + column, x);
    }

    public void toDisplayString(StringBuilder buf) {
        LispMatrices.print(buf, this);
    }
}

