/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math;

import net.morilib.lisp.Datum2;
import net.morilib.lisp.math.algebra.ILispMultipliable;
import net.morilib.math.ArrayIntSymmetricGroup;
import net.morilib.math.IntPermutation;
import net.morilib.math.IntSymmetricGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LispPermutation
extends Datum2
implements ILispMultipliable<LispPermutation> {
    IntPermutation perm;

    LispPermutation(IntPermutation perm) {
        this.perm = perm;
    }

    public LispPermutation(int ... is) {
        IntSymmetricGroup group = ArrayIntSymmetricGroup.getInstance(is.length);
        this.perm = group.newElement(is);
    }

    public int get(int i) {
        return this.perm.get(i);
    }

    public LispPermutation invert() {
        return new LispPermutation((IntPermutation)this.perm.invert());
    }

    public int size() {
        return this.perm.getCardinal();
    }

    @Override
    public LispPermutation mul(LispPermutation y) {
        return new LispPermutation((IntPermutation)this.perm.map(y.perm));
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<permutation");
        int i = 0;
        while (i < this.perm.getCardinal()) {
            buf.append(" ").append(this.perm.get(i));
            ++i;
        }
        buf.append(">");
    }
}

