/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math;

import net.morilib.lang.algebra.FieldElement;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LispNumberField
implements FieldElement<LispNumberField> {
    public static LispNumberField ZERO = new LispNumberField(LispInteger.ZERO);
    public static LispNumberField ONE = new LispNumberField(LispInteger.ONE);
    private LispNumber number;

    public LispNumberField(LispNumber number) {
        if (number == null) {
            throw new NullPointerException();
        }
        this.number = number;
    }

    @Override
    public boolean isUnit() {
        return LispInteger.ONE.equals(this.number);
    }

    @Override
    public boolean isZero() {
        return LispInteger.ZERO.equals(this.number);
    }

    @Override
    public LispNumberField negate() {
        return new LispNumberField(LispInteger.ZERO.sub(this.number));
    }

    @Override
    public LispNumberField subtract(LispNumberField x) {
        return new LispNumberField(this.number.sub(x.number));
    }

    @Override
    public LispNumberField add(LispNumberField x) {
        return new LispNumberField(this.number.add(x.number));
    }

    @Override
    public LispNumberField multiply(int n) {
        return new LispNumberField(this.number.mul(LispInteger.valueOf(n)));
    }

    @Override
    public LispNumberField multiply(LispNumberField x) {
        return new LispNumberField(this.number.mul(x.number));
    }

    @Override
    public LispNumberField power(int n) {
        if (n == 0) {
            return new LispNumberField(LispInteger.ONE);
        }
        if (n == 1) {
            return this;
        }
        if (n >= 2) {
            LispNumber x = this.number;
            int i = 1;
            while (i < n) {
                x = x.mul(this.number);
                ++i;
            }
            return new LispNumberField(x);
        }
        LispNumber x = LispInteger.ONE;
        int i = 0;
        while (i < -n) {
            x = ((LispNumber)x).div(this.number);
            ++i;
        }
        return new LispNumberField(x);
    }

    @Override
    public LispNumberField invert() {
        return new LispNumberField(LispInteger.ONE.div(this.number));
    }

    @Override
    public LispNumberField divide(LispNumberField x) {
        return new LispNumberField(this.number.div(x.number));
    }

    public int hashCode() {
        return this.number.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LispNumberField) {
            return this.number.equals(((LispNumberField)obj).number);
        }
        return false;
    }

    public String toString() {
        return this.number.toString();
    }
}

