/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lib.srfi041;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Promise;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.UnaryArgs;

public class LispStream
extends Datum2 {
    public static final LispStream STREAM_NULL = new LispStream(null, null);
    private Promise kar;
    private Promise kdr;

    public LispStream(Promise kar, Promise kdr) {
        this.kar = kar;
        this.kdr = kdr;
    }

    public Promise getKar() {
        return this.kar;
    }

    public Promise getKdr() {
        return this.kdr;
    }

    public boolean isNull() {
        return this.kar == null;
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append(this.isNull() ? "#<stream-null>" : "#<stream-pair>");
    }

    public static class IsStorim
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispStream);
        }
    }

    public static class IsStreamNullpo
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a == STREAM_NULL);
        }
    }

    public static class IsStreamPare
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispStream && c1a != STREAM_NULL);
        }
    }

    public static class StreamKar
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispStream && c1a != STREAM_NULL) {
                return ((LispStream)c1a).getKar();
            }
            throw mesg.getError("err.srfi41.require.streampair", c1a);
        }
    }

    public static class StreamKdr
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispStream && c1a != STREAM_NULL) {
                return ((LispStream)c1a).getKdr();
            }
            throw mesg.getError("err.srfi41.require.streampair", c1a);
        }
    }

    public static class StreamKons
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            return new LispStream((Promise)c1a, (Promise)c2a);
        }
    }
}

