/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Nil;
import net.morilib.parser.json.JSONParseHandler;

public class JsonToListHandler
implements JSONParseHandler {
    public static final JsonToListHandler EXACT = new JsonToListHandler(true);
    public static final JsonToListHandler INEXACT = new JsonToListHandler(false);
    Stack<Object> stack = new Stack();
    private boolean exact;

    private JsonToListHandler(boolean exact) {
        this.exact = exact;
    }

    public void begin() {
    }

    public Object eof() {
        return this.stack.pop();
    }

    public void beginArray() {
        this.stack.push(new ArrayList());
    }

    public void beginObject() {
        this.stack.push(new ConsListBuilder());
    }

    public void nextArray() {
        Datum o = (Datum)this.stack.pop();
        List l = (List)this.stack.peek();
        l.add(o);
    }

    public void endArray() {
        Datum o = (Datum)this.stack.pop();
        List l = (List)this.stack.pop();
        l.add(o);
        this.stack.push(new LispVector(l));
    }

    public void nextValue() {
    }

    public void nextObject() {
        Datum v = (Datum)this.stack.pop();
        Datum k = (Datum)this.stack.pop();
        ConsListBuilder l = (ConsListBuilder)this.stack.peek();
        l.append(new Cons(k, v));
    }

    public void endObject() {
        Datum v = (Datum)this.stack.pop();
        Datum k = (Datum)this.stack.pop();
        ConsListBuilder l = (ConsListBuilder)this.stack.pop();
        l.append(new Cons(k, v));
        this.stack.push(l.get());
    }

    public void setString(String s) {
        this.stack.push(LispString.valueOf(s));
    }

    public void setTrue() {
        this.stack.push(LispBoolean.TRUE);
    }

    public void setFalse() {
        this.stack.push(LispBoolean.FALSE);
    }

    public void setNull() {
        this.stack.push(Nil.NIL);
    }

    public void setInteger(BigInteger x) {
        this.stack.push(LispInteger.valueOf(x));
    }

    public void setFraction(BigDecimal x) {
        if (this.exact) {
            this.stack.push(LispUtils.bigDecimalToRational(x));
        } else {
            this.stack.push(new LispDouble(x.floatValue()));
        }
    }

    public void emptyArray() {
        this.stack.pop();
        this.stack.push(new LispVector());
    }

    public void emptyObject() {
        this.stack.pop();
        this.stack.push(Nil.NIL);
    }
}

