/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.graph.ILispEdge;
import net.morilib.lisp.graph.ILispVertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LispGraphs {
    private LispGraphs() {
    }

    public static boolean hasCycledPath(ILispVertex v, Datum label) {
        LinkedList<ILispVertex> x = new LinkedList<ILispVertex>();
        HashSet<ILispVertex> s = new HashSet<ILispVertex>();
        x.offer(v);
        while (!x.isEmpty()) {
            for (ILispEdge iLispEdge : ((ILispVertex)x.poll()).getEdges()) {
                ILispVertex t = iLispEdge.getTerminal();
                if (label != null && !LispUtils.equals(label, iLispEdge.getLabel())) continue;
                if (t.equals(v)) {
                    return true;
                }
                if (s.contains(t)) {
                    return false;
                }
                s.add(t);
                x.offer(t);
            }
        }
        return false;
    }

    public static boolean hasCycledPath(ILispVertex v) {
        return LispGraphs.hasCycledPath(v, null);
    }

    public static List<? extends ILispVertex> getCycledPath(ILispVertex v, Datum label) {
        LinkedList x = new LinkedList();
        HashSet<ILispVertex> s = new HashSet<ILispVertex>();
        ArrayList<ILispVertex> l = new ArrayList<ILispVertex>();
        l.add(v);
        x.offer(l);
        while (!x.isEmpty()) {
            List m = (List)x.poll();
            for (ILispEdge iLispEdge : ((ILispVertex)m.get(m.size() - 1)).getEdges()) {
                ILispVertex t = iLispEdge.getTerminal();
                if (label != null && !LispUtils.equals(label, iLispEdge.getLabel())) continue;
                if (t.equals(v)) {
                    m.add(t);
                    return m;
                }
                if (s.contains(t)) {
                    return null;
                }
                l = new ArrayList(m);
                l.add(t);
                s.add(t);
                x.offer(l);
            }
        }
        return null;
    }

    public static List<? extends ILispVertex> getCycledPath(ILispVertex v) {
        return LispGraphs.getCycledPath(v, null);
    }
}

