/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.graph.ILispEdge;
import net.morilib.lisp.graph.ILispGraph;
import net.morilib.lisp.graph.ILispVertex;
import net.morilib.util.mapset.HashOneToOneSet;
import net.morilib.util.mapset.OneToOneSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LispDirectedGraph
extends Datum2
implements ILispGraph {
    Map<Vert, Map<Edge, Vert>> vertices = new HashMap<Vert, Map<Edge, Vert>>();
    OneToOneSet<Vert, Datum> vertexNames = new HashOneToOneSet<Vert, Datum>();
    Collection<Datum> vertexData = new ArrayList<Datum>();

    @Override
    public Set<? extends ILispVertex> getVertices() {
        return Collections.unmodifiableSet(this.vertexNames.keySet());
    }

    @Override
    public void addEdge(Datum init, Datum term, Datum label) {
        Vert te;
        Vert in = (Vert)this.vertexNames.getKey(init);
        if (in == null) {
            in = new Vert(this);
            this.vertexNames.put(in, init);
            this.vertexData.add(init);
        }
        if ((te = (Vert)this.vertexNames.getKey(term)) == null) {
            te = new Vert(this);
            this.vertexNames.put(te, term);
            this.vertexData.add(term);
        }
        Edge ed = new Edge(in, te, label);
        Map<Edge, Vert> mp = this.vertices.get(in);
        if (mp == null) {
            mp = new LinkedHashMap<Edge, Vert>();
            this.vertices.put(in, mp);
        }
        mp.put(ed, te);
    }

    @Override
    public Set<? extends Datum> getVertexNames() {
        return Collections.unmodifiableSet(new LinkedHashSet<Datum>(this.vertexData));
    }

    @Override
    public ILispVertex getVertex(Datum d) {
        return (ILispVertex)this.vertexNames.getKey(d);
    }

    @Override
    public Datum getDatum(ILispVertex v) {
        return (Datum)this.vertexNames.getValue(v);
    }

    @Override
    public void addVertex(Datum d) {
        this.vertexData.add(d);
        this.vertexNames.put(new Vert(this), d);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<directed graph>");
    }

    static class Edge
    extends Datum2
    implements ILispEdge {
        private Vert init;
        private Vert term;
        private Datum label;

        Edge(Vert init, Vert term, Datum label) {
            this.init = init;
            this.term = term;
            this.label = label;
        }

        public Datum getLabel() {
            return this.label;
        }

        public ILispVertex getInitial() {
            return this.init;
        }

        public ILispVertex getTerminal() {
            return this.term;
        }

        public void toDisplayString(StringBuilder buf) {
            buf.append("#<edge ").append(LispUtils.print(this.init)).append(" -- ").append(LispUtils.print(this.label)).append(" -> ").append(LispUtils.print(this.term)).append(">");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Vert
    extends Datum2
    implements ILispVertex {
        private LispDirectedGraph graph;

        Vert(LispDirectedGraph g) {
            this.graph = g;
        }

        @Override
        public Collection<? extends ILispVertex> getTerminals() {
            return Collections.unmodifiableCollection(this.graph.vertices.get(this).values());
        }

        @Override
        public Collection<? extends ILispVertex> getTerminals(Datum label) {
            Map<Edge, Vert> es = this.graph.vertices.get(this);
            ArrayList<Vert> vs = new ArrayList<Vert>();
            for (Map.Entry<Edge, Vert> e : es.entrySet()) {
                if (label != null && !LispUtils.equals(e.getKey().getLabel(), label)) continue;
                vs.add(e.getValue());
            }
            return Collections.unmodifiableList(vs);
        }

        @Override
        public Collection<? extends ILispEdge> getEdges() {
            Map<Edge, Vert> v = this.graph.vertices.get(this);
            if (v != null) {
                return Collections.unmodifiableSet(v.keySet());
            }
            return Collections.emptySet();
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<vertex ").append(LispUtils.print((Datum)this.graph.vertexNames.getValue(this))).append(">");
        }
    }
}

