/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.file.LispFiles;
import net.morilib.lisp.file.LispLineBuffer;
import net.morilib.lisp.subr.SubrUtils;

public class LispFileBuffer
extends LispLineBuffer {
    private PrintWriter wr;

    public LispFileBuffer(File fn, String enc) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        if (fn == null) {
            throw new NullPointerException();
        }
        this.wr = enc == null ? new PrintWriter(new BufferedWriter(new FileWriter(fn))) : new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fn), enc)));
    }

    public void putLine(Datum s) {
        this.wr.println(LispUtils.print(s));
    }

    public void close() throws IOException {
        this.wr.close();
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<line-buffer>");
    }

    public static class OpenFileBuffer
    extends Subr {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            String f = SubrUtils.nextString((Iterator<Datum>)itr, mesg, body);
            String e = SubrUtils.nextString((Iterator<Datum>)itr, null, mesg);
            SubrUtils.checkTerminated(itr, body, mesg);
            try {
                return new LispFileBuffer(LispFiles.getFile(env, f), e);
            }
            catch (UnsupportedEncodingException e1) {
                throw mesg.getError("err.unsupportedencoding", e);
            }
            catch (FileNotFoundException e1) {
                throw mesg.getError("err.filenotfound", f);
            }
            catch (IOException e1) {
                throw mesg.getError("err.io", e1.getMessage());
            }
        }
    }
}

