/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.condition;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.condition.LispCondition;
import net.morilib.lisp.condition.LispConditionType;
import net.morilib.lisp.r6rs.record.R6RSRecord;
import net.morilib.lisp.r6rs.record.RecordTypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LispSimpleCondition
extends Datum2
implements LispCondition,
R6RSRecord {
    private LispConditionType type;
    private Map<String, Datum> fields;

    public LispSimpleCondition(LispConditionType type) {
        this.type = type;
        this.fields = type.makeFieldMap();
    }

    public LispConditionType getConditionType() {
        return this.type;
    }

    public static LispSimpleCondition newInstance(String id) {
        LispConditionType t = LispConditionType.getInstance(id);
        return new LispSimpleCondition(t == null ? LispConditionType.CONDITION : t);
    }

    @Override
    public Datum getField(String v) {
        return this.fields.get(v);
    }

    @Override
    public boolean setField(String v, Datum val) {
        if (!this.fields.containsKey(v)) {
            return false;
        }
        this.fields.put(v, val);
        return true;
    }

    @Override
    public boolean hasType(LispConditionType type) {
        LispConditionType p = this.type;
        while (p != null) {
            if (p.equals(type)) {
                return true;
            }
            p = p.parent;
        }
        return false;
    }

    @Override
    public List<LispSimpleCondition> getConditions() {
        return Collections.singletonList(this);
    }

    @Override
    public LispSimpleCondition extractCondition(LispConditionType t) {
        return this.hasType(t) ? this : null;
    }

    @Override
    public Datum getSlot(Symbol sym) {
        return this.getField(sym.getName());
    }

    @Override
    public boolean setSlot(Symbol sym, Datum val, LispMessage mesg) {
        return this.setField(sym.getName(), val);
    }

    @Override
    public boolean isDefined(String v) {
        return this.fields.containsKey(v);
    }

    @Override
    public boolean isMutable(String v) {
        return false;
    }

    @Override
    public RecordTypeDescriptor getRtd() {
        return null;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<condition ").append(this.type.getId()).append(">");
    }

    @Override
    public String describeShort() {
        return this.type.getId();
    }
}

