/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.condition;

import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.condition.LispCondition;
import net.morilib.lisp.condition.LispConditionType;
import net.morilib.lisp.condition.LispSimpleCondition;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.UnaryArgs;

public class ConditionAccessor
extends BinaryArgs {
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        if (!(c1a instanceof LispConditionType)) {
            throw mesg.getError("err.condition.require.conditiontype", c1a);
        }
        if (!(c2a instanceof Procedure)) {
            throw mesg.getError("err.require.procedure", c2a);
        }
        return new Proc((LispConditionType)c1a, (Procedure)((Object)c2a));
    }

    private static class Proc
    extends UnaryArgs {
        private LispConditionType type;
        private Procedure p;

        private Proc(LispConditionType type, Procedure p) {
            super("condition-accessor of " + type.getId());
            this.type = type;
            this.p = p;
        }

        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispCondition) {
                List<LispSimpleCondition> l = ((LispCondition)((Object)c1a)).getConditions();
                for (LispSimpleCondition c : l) {
                    if (!c.hasType(this.type)) continue;
                    return Scheme.callva(this.p, env, mesg, c);
                }
                return LispBoolean.FALSE;
            }
            throw mesg.getError("err.condition.require.condition", c1a);
        }
    }
}

