/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.compare;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.compare.SRFI67;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.UnaryArgs;

public class DebugCompare
extends UnaryArgs {
    private static final int TR = 1;
    private static final int FA = 0;
    private static final int UN = -1;
    private static final boolean[][] ANTISYMMETRY;
    private static final int[] UNKNOWN;
    private static final int[][][] TRANSITIVITY;

    static {
        boolean[][] blArrayArray = new boolean[3][];
        boolean[] blArray = new boolean[3];
        blArray[2] = true;
        blArrayArray[0] = blArray;
        boolean[] blArray2 = new boolean[3];
        blArray2[1] = true;
        blArrayArray[1] = blArray2;
        boolean[] blArray3 = new boolean[3];
        blArray3[0] = true;
        blArrayArray[2] = blArray3;
        ANTISYMMETRY = blArrayArray;
        UNKNOWN = new int[]{-1, -1, -1};
        int[][][] nArrayArray = new int[3][][];
        int[][] nArrayArray2 = new int[3][];
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArrayArray2[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 1;
        nArrayArray2[1] = nArray2;
        nArrayArray2[2] = UNKNOWN;
        nArrayArray[0] = nArrayArray2;
        int[][] nArrayArray3 = new int[3][];
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArrayArray3[0] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[1] = 1;
        nArrayArray3[1] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[2] = 1;
        nArrayArray3[2] = nArray5;
        nArrayArray[1] = nArrayArray3;
        int[][] nArrayArray4 = new int[3][];
        nArrayArray4[0] = UNKNOWN;
        int[] nArray6 = new int[3];
        nArray6[2] = 1;
        nArrayArray4[1] = nArray6;
        int[] nArray7 = new int[3];
        nArray7[2] = 1;
        nArrayArray4[2] = nArray7;
        nArrayArray[2] = nArrayArray4;
        TRANSITIVITY = nArrayArray;
    }

    protected Datum execute(Datum cmp, Environment env, LispMessage mesg) {
        if (cmp instanceof Procedure) {
            return new Proc(cmp);
        }
        throw mesg.getError("err.require.procedure", cmp);
    }

    private static class Proc
    extends BinaryArgs {
        private Datum proc;
        private Datum z = null;

        private Proc(Datum proc) {
            this.proc = proc;
        }

        protected Datum execute(Datum x, Datum y, Environment env, LispMessage mesg) {
            int cxz = 0;
            int cyz = 0;
            int czx = 0;
            int czy = 0;
            int cxx = SRFI67.callCompare(this.proc, x, x, env, mesg).getInt();
            int cyy = SRFI67.callCompare(this.proc, y, y, env, mesg).getInt();
            int cxy = SRFI67.callCompare(this.proc, x, y, env, mesg).getInt();
            int cyx = SRFI67.callCompare(this.proc, y, x, env, mesg).getInt();
            if (this.z != null) {
                cxz = SRFI67.callCompare(this.proc, x, this.z, env, mesg).getInt();
                cyz = SRFI67.callCompare(this.proc, y, this.z, env, mesg).getInt();
                czx = SRFI67.callCompare(this.proc, this.z, x, env, mesg).getInt();
                czy = SRFI67.callCompare(this.proc, this.z, y, env, mesg).getInt();
            }
            if (cxx != 0) {
                throw mesg.getError("err.srfi67.notreflective", this.proc);
            }
            if (cyy != 0) {
                throw mesg.getError("err.srfi67.notreflective", this.proc);
            }
            if (!ANTISYMMETRY[cxy + 1][cyx + 1]) {
                throw mesg.getError("err.srfi67.notantisymmetric", this.proc);
            }
            if (!ANTISYMMETRY[cxz + 1][czx + 1]) {
                throw mesg.getError("err.srfi67.notantisymmetric", this.proc);
            }
            if (!ANTISYMMETRY[cyz + 1][czy + 1]) {
                throw mesg.getError("err.srfi67.notantisymmetric", this.proc);
            }
            if (this.z != null && TRANSITIVITY[cyz + 1][cxy + 1][cxz + 1] == 0) {
                throw mesg.getError("err.srfi67.nottransitive", this.proc);
            }
            this.z = ((int)(Math.random() * 1000.0) & 1) == 0 ? x : y;
            return LispInteger.valueOf(cxy);
        }
    }
}

