/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.collection;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.collection.LispCollection;
import net.morilib.lisp.collection.LispMutableSortedSetDatum;
import net.morilib.lisp.collection.LispSet;
import net.morilib.lisp.collection.LispSetDatum;
import net.morilib.lisp.collection.NoBoundsException;
import net.morilib.lisp.collection.hash.Hash;
import net.morilib.lisp.compare.SRFI67;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.util.Iterators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LispTreeSet
extends LispMutableSortedSetDatum {
    private SortedSet<Datum> treeSet;
    private Procedure ordering;
    private Procedure eqproc;
    private Environment activeenv;
    private LispMessage message;

    private LispTreeSet(SortedSet<Datum> set, final Procedure ordering, final Environment activeenv, final LispMessage message) {
        this.treeSet = set;
        this.ordering = ordering;
        this.eqproc = new BinaryArgs(){

            protected Datum execute(Datum a, Datum b, Environment env, LispMessage mesg) {
                boolean r = !Scheme.callva(ordering, activeenv, message, a, b).isTrue();
                r = r && !Scheme.callva(ordering, activeenv, message, b, a).isTrue();
                return LispBoolean.getInstance(r);
            }
        };
        this.activeenv = activeenv;
        this.message = message;
    }

    private static Comparator<Datum> comparator(final Procedure op, final Environment env, final LispMessage meg) {
        return new Comparator<Datum>(){

            @Override
            public int compare(Datum a, Datum b) {
                if (Scheme.callva(op, env, meg, a, b).isTrue()) {
                    return -1;
                }
                if (Scheme.callva(op, env, meg, b, a).isTrue()) {
                    return 1;
                }
                return 0;
            }
        };
    }

    @Override
    public Datum clear() {
        this.treeSet.clear();
        return this;
    }

    @Override
    public Symbol getCollectionName() {
        return Symbol.getSymbol("tree-set");
    }

    @Override
    public int size() {
        return this.treeSet.size();
    }

    @Override
    public boolean equalTo(LispCollection col) {
        return this.equalTo(col, this.eqproc, this.activeenv, this.message);
    }

    @Override
    public boolean contains(Datum d) {
        return this.treeSet.contains(d);
    }

    @Override
    public Iterator<Datum> iterator() {
        return Iterators.unmodifiable(this.treeSet.iterator());
    }

    @Override
    public Procedure ordering() {
        return this.ordering;
    }

    @Override
    public Datum first() throws NoBoundsException {
        return this.treeSet.first();
    }

    @Override
    public Datum last() throws NoBoundsException {
        return this.treeSet.last();
    }

    @Override
    public Procedure equivalence() {
        return this.eqproc;
    }

    @Override
    public boolean equivalence(Datum a, Datum b) {
        return Scheme.callva(this.eqproc, this.activeenv, this.message, a, b).isTrue();
    }

    @Override
    public LispTreeSet prototype() {
        return new LispTreeSet(new TreeSet<Datum>(), this.ordering, this.activeenv, this.message);
    }

    @Override
    public LispTreeSet duplicate() {
        return new LispTreeSet(new TreeSet<Datum>(this.treeSet), this.ordering, this.activeenv, this.message);
    }

    @Override
    public Datum add(Datum s) {
        this.treeSet.add(s);
        return this;
    }

    @Override
    public Datum delete(Datum s) {
        this.treeSet.remove(s);
        return this;
    }

    @Override
    public LispSetDatum intersection(LispSet s) {
        return this.duplicate().retainAll(s);
    }

    @Override
    public LispSetDatum retainAll(LispSet s) {
        Iterator itr = this.treeSet.iterator();
        while (itr.hasNext()) {
            if (s.contains((Datum)itr.next())) continue;
            itr.remove();
        }
        return this;
    }

    @Override
    public void getResult(StringBuilder buf) {
        String dlm = "";
        buf.append("#<tree-set ");
        for (Datum d : this) {
            buf.append(dlm);
            buf.append(LispUtils.getResult(d));
            dlm = " ";
        }
        buf.append(">");
    }

    @Override
    public void print(StringBuilder buf) {
        String dlm = "";
        buf.append("#<tree-set ");
        for (Datum d : this) {
            buf.append(dlm);
            buf.append(LispUtils.print(d));
            dlm = " ";
        }
        buf.append(">");
    }

    public int hashCode() {
        int r = 17;
        for (Datum d : this) {
            r = 37 * r + Hash.hash(d);
        }
        return r;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LispCollection) {
            return this.equalTo((LispCollection)obj);
        }
        return false;
    }

    @Override
    public Set<Datum> getJavaSet() {
        return Collections.unmodifiableSet(this.treeSet);
    }

    /* synthetic */ LispTreeSet(SortedSet sortedSet, Procedure procedure, Environment environment, LispMessage lispMessage, LispTreeSet lispTreeSet) {
        this(sortedSet, procedure, environment, lispMessage);
    }

    public static class IsTreeSet
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispTreeSet);
        }
    }

    public static class MakeTreeSet
    extends Subr {
        public Datum eval(Datum body, final Environment env, final LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum op = Iterators.nextIf(itr);
            BinaryArgs dop = new BinaryArgs(){

                protected Datum execute(Datum x1, Datum x2, Environment env2, LispMessage mesg2) {
                    LispInteger d = SRFI67.callCompareDefault(x1, x2, env, mesg);
                    return LispBoolean.getInstance(((Datum)d).getInt() < 0);
                }
            };
            if (op == null) {
                return new LispTreeSet(new TreeSet(LispTreeSet.comparator(dop, env, mesg)), dop, env, mesg, null);
            }
            if (op instanceof Procedure) {
                return new LispTreeSet(new TreeSet(LispTreeSet.comparator(dop, env, mesg)), (Procedure)((Object)op), env, mesg, null);
            }
            throw mesg.getError("err.require.procedure", op);
        }
    }

    public static class SubrTreeSet
    extends Subr {
        public Datum eval(Datum body, final Environment env, final LispMessage mesg) {
            TreeSet<Datum> st;
            Procedure op2;
            ConsIterator itr = new ConsIterator(body);
            Datum op = Iterators.nextIf(itr);
            BinaryArgs dop = new BinaryArgs(){

                protected Datum execute(Datum x1, Datum x2, Environment env2, LispMessage mesg2) {
                    LispInteger d = SRFI67.callCompareDefault(x1, x2, env, mesg);
                    return LispBoolean.getInstance(((Datum)d).getInt() < 0);
                }
            };
            if (op == null) {
                op2 = dop;
                st = new TreeSet<Datum>(LispTreeSet.comparator(op2, env, mesg));
            } else if (op instanceof Procedure) {
                op2 = (Procedure)((Object)op);
                st = new TreeSet(LispTreeSet.comparator(op2, env, mesg));
                while (itr.hasNext()) {
                    st.add(itr.next());
                }
            } else {
                op2 = dop;
                st = new TreeSet(LispTreeSet.comparator(op2, env, mesg));
                st.add(op);
                while (itr.hasNext()) {
                    st.add(itr.next());
                }
            }
            return new LispTreeSet(st, op2, env, mesg, null);
        }
    }
}

