/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.collection;

import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum3;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.collection.ImmutableException;
import net.morilib.lisp.collection.LispBag;
import net.morilib.lisp.collection.LispCollection;
import net.morilib.lisp.collection.LispCollections;
import net.morilib.lisp.collection.LispLimitedCollection;
import net.morilib.lisp.collection.LispSet;
import net.morilib.lisp.topology.ILispTopology;
import net.morilib.lisp.topology.LispCardinality;

public abstract class LispSetDatum
extends Datum3
implements LispSet,
LispLimitedCollection {
    public Datum toList() {
        ConsListBuilder b = new ConsListBuilder();
        for (Datum o : this) {
            b.append(o);
        }
        return b.get();
    }

    public int count(Datum c2a) {
        return this.contains(c2a) ? 1 : 0;
    }

    public boolean equalTo(LispCollection col, Procedure p, Environment env, LispMessage mesg) {
        return LispCollections.equalTo(this, col, p, env, mesg);
    }

    public boolean subset(LispSet set) {
        block0: for (Datum e : this) {
            for (Datum f : set) {
                if (this.equivalence(e, f)) continue block0;
            }
            return false;
        }
        return true;
    }

    public abstract LispSetDatum prototype();

    public abstract LispSetDatum duplicate();

    public LispSetDatum addAll(LispSet s) throws ImmutableException {
        for (Datum d : s) {
            this.add(d);
        }
        return this;
    }

    public LispSetDatum removeAll(LispSet s) throws ImmutableException {
        for (Datum d : s) {
            if (!this.contains(d)) continue;
            this.delete(d);
        }
        return this;
    }

    public Datum symmetricDifferenceModify(LispSet s) throws ImmutableException {
        for (Datum d : s) {
            if (this.contains(d)) {
                this.delete(d);
                continue;
            }
            this.add(d);
        }
        return this;
    }

    public Datum addFrom(LispBag s) throws ImmutableException {
        for (Datum d : s) {
            this.add(d);
        }
        return this;
    }

    public Datum deleteFrom(LispBag s) throws ImmutableException {
        for (Datum d : s) {
            if (!this.contains(d)) continue;
            this.delete(d);
        }
        return this;
    }

    public LispSet mul(LispSet y) {
        LispSet r = this.prototype();
        boolean im = false;
        for (Datum dx : this) {
            for (Datum dy : y) {
                try {
                    if (im) {
                        r = (LispSet)((Object)r.copyAdd(new Cons(dx, dy)));
                        continue;
                    }
                    r.add(new Cons(dx, dy));
                }
                catch (ImmutableException e) {
                    r = (LispSet)((Object)r.copyAdd(new Cons(dx, dy)));
                    im = true;
                }
            }
        }
        return r;
    }

    public LispSet add(LispSet y) {
        return (LispSet)((Object)this.union(y));
    }

    public LispSet uminus() {
        return this.prototype();
    }

    public LispSet sub(LispSet y) {
        return (LispSet)((Object)this.difference(y));
    }

    public boolean isNeighborhoodOf(Datum d) {
        return this.contains(d);
    }

    public boolean isContained(ILispTopology t) {
        for (Datum d : this) {
            if (t.isNeighborhoodOf(d)) continue;
            return false;
        }
        return true;
    }

    public boolean isIndependent(ILispTopology t) {
        for (Datum d : this) {
            if (!t.isNeighborhoodOf(d)) continue;
            return false;
        }
        return true;
    }

    public boolean isNotContained(ILispTopology t) {
        return !this.isContained(t);
    }

    public boolean isNotIndependent(ILispTopology t) {
        return !this.isIndependent(t);
    }

    public ILispTopology interior() {
        return this;
    }

    public ILispTopology closure() {
        return this;
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isClosed() {
        return true;
    }

    public LispCardinality cardinality() {
        return LispCardinality.finiteValueOf(this.size());
    }

    public boolean isEmpty() {
        return this.isEmpty();
    }

    public boolean isUniverse() {
        return false;
    }
}

