/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.collection;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Subr;
import net.morilib.lisp.collection.ImmutableException;
import net.morilib.lisp.collection.LispBag;
import net.morilib.lisp.collection.LispCollection;
import net.morilib.lisp.math.algebra.ILispRing;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.topology.ILispEnumerableTopology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface LispSet
extends LispCollection,
ILispRing<LispSet>,
ILispEnumerableTopology {
    public Procedure equivalence();

    public boolean equivalence(Datum var1, Datum var2);

    public boolean subset(LispSet var1);

    public Datum copyAdd(Datum var1);

    @Override
    public Datum add(Datum var1) throws ImmutableException;

    public Datum copyDelete(Datum var1);

    public Datum delete(Datum var1) throws ImmutableException;

    public Datum union(LispSet var1);

    public Datum addAll(LispSet var1) throws ImmutableException;

    public Datum intersection(LispSet var1);

    public Datum retainAll(LispSet var1) throws ImmutableException;

    public Datum difference(LispSet var1);

    public Datum removeAll(LispSet var1) throws ImmutableException;

    public Datum symmetricDifference(LispSet var1);

    public Datum symmetricDifferenceModify(LispSet var1) throws ImmutableException;

    public Datum copyAddFrom(LispBag var1);

    public Datum addFrom(LispBag var1) throws ImmutableException;

    public Datum copyDeleteFrom(LispBag var1);

    public Datum deleteFrom(LispBag var1) throws ImmutableException;

    public static class IsSet
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispSet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IsSubset
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public IsSubset(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            LispSet s = null;
            boolean r = true;
            while (itr.hasNext()) {
                Datum d = itr.next();
                if (s == null) {
                    this.checkType(d, mesg);
                    s = (LispSet)((Object)d);
                    continue;
                }
                if (!(d instanceof LispSet)) {
                    throw mesg.getError("err.srfi44.require.set", d);
                }
                if (!r) continue;
                r = s.subset((LispSet)((Object)d));
            }
            SubrUtils.checkTerminated(itr, body, mesg);
            return LispBoolean.getInstance(r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetAdd
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public SetAdd(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            return ((LispSet)((Object)c1a)).copyAdd(c2a);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetAddFrom
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public SetAddFrom(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            if (!(c2a instanceof LispBag)) {
                throw mesg.getError("err.srfi44.require.bag", c2a);
            }
            return ((LispSet)((Object)c1a)).copyAddFrom((LispBag)((Object)c2a));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetAddFromS
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public SetAddFromS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            if (!(c2a instanceof LispBag)) {
                throw mesg.getError("err.srfi44.require.bag", c2a);
            }
            try {
                return ((LispSet)((Object)c1a)).addFrom((LispBag)((Object)c2a));
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetAddS
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public SetAddS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                return ((LispSet)((Object)c1a)).add(c2a);
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetDelete
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public SetDelete(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            return ((LispSet)((Object)c1a)).copyDelete(c2a);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetDeleteFrom
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public SetDeleteFrom(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            if (!(c2a instanceof LispBag)) {
                throw mesg.getError("err.srfi44.require.bag", c2a);
            }
            return ((LispSet)((Object)c1a)).copyDeleteFrom((LispBag)((Object)c2a));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetDeleteFromS
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public SetDeleteFromS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            if (!(c2a instanceof LispBag)) {
                throw mesg.getError("err.srfi44.require.bag", c2a);
            }
            try {
                return ((LispSet)((Object)c1a)).deleteFrom((LispBag)((Object)c2a));
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetDeleteS
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public SetDeleteS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                return ((LispSet)((Object)c1a)).delete(c2a);
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetDifference
    extends SetOpBase {
        public SetDifference(Class<?> cls, String err) {
            super(cls, err);
        }

        @Override
        protected LispSet operate(LispSet d, LispSet x) {
            return (LispSet)((Object)d.difference(x));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetDifferenceS
    extends SetOpBase {
        public SetDifferenceS(Class<?> cls, String err) {
            super(cls, err);
        }

        @Override
        protected LispSet operate(LispSet d, LispSet x) throws ImmutableException {
            return (LispSet)((Object)d.removeAll(x));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetEquivalenceFunction
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public SetEquivalenceFunction(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            return (Datum)((Object)((LispSet)((Object)c1a)).equivalence());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetIntersection
    extends SetOpBase {
        public SetIntersection(Class<?> cls, String err) {
            super(cls, err);
        }

        @Override
        protected LispSet operate(LispSet d, LispSet x) {
            return (LispSet)((Object)d.intersection(x));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetIntersectionS
    extends SetOpBase {
        public SetIntersectionS(Class<?> cls, String err) {
            super(cls, err);
        }

        @Override
        protected LispSet operate(LispSet d, LispSet x) throws ImmutableException {
            return (LispSet)((Object)d.retainAll(x));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class SetOpBase
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public SetOpBase(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        protected abstract LispSet operate(LispSet var1, LispSet var2) throws ImmutableException;

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            this.checkType(d, mesg);
            LispSet r = (LispSet)((Object)d);
            while (itr.hasNext()) {
                Datum x = itr.next();
                if (x instanceof LispSet) {
                    try {
                        r = this.operate(r, (LispSet)((Object)x));
                        continue;
                    }
                    catch (ImmutableException e) {
                        throw mesg.getError("err.srfi44.immutable", d);
                    }
                }
                throw mesg.getError("err.srfi44.require.set", x);
            }
            return (Datum)((Object)r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetSymmetricDifference
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public SetSymmetricDifference(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            if (!(c2a instanceof LispSet)) {
                throw mesg.getError("err.srfi44.require.set", c2a);
            }
            return ((LispSet)((Object)c1a)).symmetricDifference((LispSet)((Object)c2a));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetSymmetricDifferenceS
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public SetSymmetricDifferenceS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            if (!(c2a instanceof LispSet)) {
                throw mesg.getError("err.srfi44.require.set", c2a);
            }
            try {
                return ((LispSet)((Object)c1a)).symmetricDifferenceModify((LispSet)((Object)c2a));
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetUnion
    extends SetOpBase {
        public SetUnion(Class<?> cls, String err) {
            super(cls, err);
        }

        @Override
        protected LispSet operate(LispSet d, LispSet x) {
            return (LispSet)((Object)d.union(x));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetUnionS
    extends SetOpBase {
        public SetUnionS(Class<?> cls, String err) {
            super(cls, err);
        }

        @Override
        protected LispSet operate(LispSet d, LispSet x) throws ImmutableException {
            return (LispSet)((Object)d.addAll(x));
        }
    }
}

