/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.charset;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.charset.LispCharSet;
import net.morilib.range.integer.IntInterval;
import net.morilib.range.integer.IntRangeAdder;

public class LispCharSetBuilder
extends Datum2 {
    LispCharSet range;
    SortedSet<Int2> set;

    LispCharSetBuilder(LispCharSet base) {
        this.range = base;
        this.set = new TreeSet<Int2>();
    }

    public void add(int c) {
        Iterator itr = this.set.iterator();
        while (itr.hasNext()) {
            Int2 x = (Int2)itr.next();
            if (x.left <= c && c <= x.right) {
                return;
            }
            if (x.right + 1 != c) continue;
            if (itr.hasNext()) {
                Int2 y = (Int2)itr.next();
                if (x.right + 1 == y.left) {
                    x.right = y.right;
                    itr.remove();
                } else {
                    ++x.right;
                }
            } else {
                ++x.right;
            }
            return;
        }
        this.set.add(new Int2(c, c));
    }

    public LispCharSet toCharSet() {
        IntRangeAdder r = new IntRangeAdder();
        for (Int2 x : this.set) {
            r.add(new IntInterval(x.left, x.right));
        }
        if (this.range != null) {
            this.range.charset = this.range.charset.join(r.toRange());
            return this.range;
        }
        return new LispCharSet(r.toRange());
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<char-set-builder>");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Int2
    implements Comparable<Int2> {
        int left;
        int right;

        Int2() {
        }

        Int2(int left, int right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public int compareTo(Int2 o) {
            if (this.left < o.left) {
                return -1;
            }
            if (this.left > o.left) {
                return 1;
            }
            if (this.right < o.right) {
                return -1;
            }
            if (this.right > o.right) {
                return 1;
            }
            return 0;
        }
    }
}

