/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.charset;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.charset.CharSetPropertyHandler;
import net.morilib.lisp.charset.CharSetPropertyParser;
import net.morilib.lisp.topology.AbstractLispTopology;
import net.morilib.lisp.topology.ILispOrderedSet;
import net.morilib.lisp.topology.ILispTopology;
import net.morilib.lisp.topology.LispCardinality;
import net.morilib.range.integer.AbstractIntRange;
import net.morilib.range.integer.IntCharSets;
import net.morilib.range.integer.IntInterval;
import net.morilib.range.integer.IntRange;
import net.morilib.util.MutableTuple2;

public class LispCharSet
extends AbstractLispTopology
implements ILispOrderedSet {
    private static final Map<String, LispCharSet> _RANGES;
    public static final LispCharSet UNIVERSAL;
    public static final LispCharSet LOWER_CASE;
    public static final LispCharSet UPPER_CASE;
    public static final LispCharSet TITLE_CASE;
    public static final LispCharSet LETTER;
    public static final LispCharSet DIGIT;
    public static final LispCharSet LETTER_PLUS_DIGIT;
    public static final LispCharSet GRAPHIC;
    public static final LispCharSet PRINTING;
    public static final LispCharSet WHITESPACE;
    public static final LispCharSet ISO_CONTROL;
    public static final LispCharSet PUNCTATION;
    public static final LispCharSet SYMBOL;
    public static final LispCharSet HEX_DIGIT;
    public static final LispCharSet BLANK;
    public static final LispCharSet ASCII;
    public static final LispCharSet EMPTY;
    public static final LispCharSet FULL;
    IntRange charset;

    static {
        UNIVERSAL = new LispCharSet(IntCharSets.ALL_CHAR);
        InputStream ins = LispCharSet.class.getResourceAsStream("/net/morilib/lisp/charset/charset2.txt");
        _RANGES = new HashMap<String, LispCharSet>();
        try {
            final MutableTuple2 mt = new MutableTuple2();
            CharSetPropertyParser.parse(ins, new CharSetPropertyHandler(){

                public void singleChar(int ch) {
                    ((SortedSet)mt.getB()).add(LispCharSet.getintv(ch, ch));
                }

                public void rangedChar(int cb, int ce) {
                    ((SortedSet)mt.getB()).add(LispCharSet.getintv(cb, ce));
                }

                public void charsetName(String name) {
                    if (mt.getA() != null) {
                        IntRange rr = AbstractIntRange.makeRange((SortedSet)mt.getB());
                        _RANGES.put((String)mt.getA(), new LispCharSet(rr));
                    }
                    mt.setA(name);
                    mt.setB(new TreeSet());
                }
            });
            LOWER_CASE = _RANGES.get("char-set:lower-case");
            UPPER_CASE = _RANGES.get("char-set:upper-case");
            TITLE_CASE = _RANGES.get("char-set:title-case");
            LETTER = _RANGES.get("char-set:letter");
            DIGIT = _RANGES.get("char-set:digit");
            LETTER_PLUS_DIGIT = _RANGES.get("char-set:letter+digit");
            GRAPHIC = _RANGES.get("char-set:graphic");
            PRINTING = _RANGES.get("char-set:printing");
            WHITESPACE = _RANGES.get("char-set:whitespace");
            ISO_CONTROL = _RANGES.get("char-set:iso-control");
            PUNCTATION = _RANGES.get("char-set:punctuation");
            SYMBOL = _RANGES.get("char-set:symbol");
            HEX_DIGIT = _RANGES.get("char-set:hex-digit");
            BLANK = _RANGES.get("char-set:blank");
            ASCII = _RANGES.get("char-set:ascii");
            EMPTY = _RANGES.get("char-set:empty");
            FULL = _RANGES.get("char-set:full");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public LispCharSet(char ... cs) {
        this.charset = IntRange.O;
        char[] cArray = cs;
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            this.charset = this.charset.join(new IntInterval(c, c));
            ++n2;
        }
    }

    public LispCharSet(int ... cs) {
        this.charset = IntRange.O;
        int[] nArray = cs;
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            int c = nArray[n2];
            this.charset = this.charset.join(new IntInterval(c, c));
            ++n2;
        }
    }

    public LispCharSet(CharSequence cs) {
        this.charset = IntRange.O;
        int i = 0;
        while (i < cs.length()) {
            char c = cs.charAt(i);
            this.charset = this.charset.join(new IntInterval(c, c));
            ++i;
        }
    }

    public LispCharSet(String s) {
        this.charset = IntRange.O;
        int i = 0;
        while (i < s.length()) {
            int c = s.codePointAt(i);
            this.charset = this.charset.join(new IntInterval(c, c));
            i += c > 57343 ? 2 : 1;
            ++i;
        }
    }

    public LispCharSet(IntRange charset) {
        this.charset = charset;
    }

    public LispCharSet(LispCharSet cs) {
        this.charset = cs.charset;
    }

    private static IntInterval getintv(int ch, int ch2) {
        return new IntInterval(ch, ch2);
    }

    public static LispCharSet getInterval(int ch, int ch2) {
        return new LispCharSet(LispCharSet.getintv(ch, ch2));
    }

    public static LispCharSet parse(CharSequence s) {
        IntRange r = IntCharSets.parse(s);
        return r != null ? new LispCharSet(r) : null;
    }

    public boolean contains(int c) {
        return this.charset.contains(c);
    }

    public LispCharSet complement() {
        return new LispCharSet(this.charset.difference(IntCharSets.ALL_CHAR));
    }

    public boolean isNeighborhoodOf(Datum d) {
        if (d instanceof LispCharacter) {
            return this.charset.contains(d.getCharacterCodePoint());
        }
        return false;
    }

    public boolean isContained(ILispTopology t) {
        if (t instanceof LispCharSet) {
            return this.charset.isContained(((LispCharSet)t).charset);
        }
        return super.isContained(t);
    }

    public boolean isIndependent(ILispTopology t) {
        if (t instanceof LispCharSet) {
            return this.charset.isIndependent(((LispCharSet)t).charset);
        }
        return super.isIndependent(t);
    }

    public ILispTopology unionTopology(ILispTopology t) {
        if (t instanceof LispCharSet) {
            return new LispCharSet(this.charset.join(((LispCharSet)t).charset));
        }
        return super.unionTopology(t);
    }

    public ILispTopology intersectionTopology(ILispTopology t) {
        if (t instanceof LispCharSet) {
            return new LispCharSet(this.charset.meet(((LispCharSet)t).charset));
        }
        return super.intersectionTopology(t);
    }

    public ILispTopology interior() {
        return this;
    }

    public ILispTopology closure() {
        return this;
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isClosed() {
        return true;
    }

    public LispCardinality cardinality() {
        return LispCardinality.finiteValueOf(this.charset.cardinality());
    }

    public boolean isEmpty() {
        return this.charset.cardinality() == 0L;
    }

    public boolean isUniverse() {
        return false;
    }

    public Datum maximum() {
        return LispCharacter.valueOf((char)this.charset.maximum());
    }

    public Datum minimum() {
        return LispCharacter.valueOf((char)this.charset.minimum());
    }

    public Datum supremum() {
        return LispCharacter.valueOf((char)this.charset.maximum());
    }

    public Datum infimum() {
        return LispCharacter.valueOf((char)this.charset.minimum());
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#[");
        for (IntInterval i : this.charset.intervals()) {
            buf.appendCodePoint(i.minimum());
            if (i.minimum() == i.maximum()) continue;
            buf.append("-");
            buf.appendCodePoint(i.maximum());
        }
        buf.append("]");
    }

    public int hashCode() {
        return this.charset.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof LispCharSet) {
            return this.charset.equals(((LispCharSet)o).charset);
        }
        return false;
    }
}

