/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.array;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Undef;
import net.morilib.lisp.array.InvalidDimensionException;
import net.morilib.lisp.array.LispArray;
import net.morilib.lisp.array.LispArrayC32;
import net.morilib.lisp.array.LispArrayC64;
import net.morilib.lisp.array.LispArrayPrototype;
import net.morilib.lisp.array.LispArrayR32;
import net.morilib.lisp.array.LispArrayR64;
import net.morilib.lisp.array.LispArrayS16;
import net.morilib.lisp.array.LispArrayS32;
import net.morilib.lisp.array.LispArrayS64;
import net.morilib.lisp.array.LispArrayS8;
import net.morilib.lisp.array.LispArrayT1;
import net.morilib.lisp.array.LispArrayU16;
import net.morilib.lisp.array.LispArrayU32;
import net.morilib.lisp.array.LispArrayU64;
import net.morilib.lisp.array.LispArrayU8;
import net.morilib.lisp.array.ListToArray;
import net.morilib.lisp.array.ValueOutOfBoundsException;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.primitive.IntegerArrayVector;

public class ParseSrfi58
extends BinaryArgs {
    private static final Map<String, LispArrayPrototype> _PROTOTYPES;
    private static final LispVector ANYVEC;

    static {
        ANYVEC = new LispVector(Undef.UNDEF);
        _PROTOTYPES = new HashMap<String, LispArrayPrototype>();
        _PROTOTYPES.put("floC128b", new LispArrayC64.Prototype(0.0, 0.0));
        _PROTOTYPES.put("floC64b", new LispArrayC64.Prototype(0.0, 0.0));
        _PROTOTYPES.put("floC32b", new LispArrayC32.Prototype(0.0f, 0.0f));
        _PROTOTYPES.put("floC16b", new LispArrayC32.Prototype(0.0f, 0.0f));
        _PROTOTYPES.put("floR128b", new LispArrayR64.Prototype(0.0));
        _PROTOTYPES.put("floR64b", new LispArrayR64.Prototype(0.0));
        _PROTOTYPES.put("floR32b", new LispArrayR32.Prototype(0.0f));
        _PROTOTYPES.put("floR16b", new LispArrayR32.Prototype(0.0f));
        _PROTOTYPES.put("floQ128d", new LispVector(Undef.UNDEF));
        _PROTOTYPES.put("floQ64d", new LispVector(Undef.UNDEF));
        _PROTOTYPES.put("floQ32d", new LispVector(Undef.UNDEF));
        _PROTOTYPES.put("fixZ64b", new LispArrayS64.Prototype(0L));
        _PROTOTYPES.put("fixZ32b", new LispArrayS32.Prototype(0));
        _PROTOTYPES.put("fixZ16b", new LispArrayS16.Prototype(0));
        _PROTOTYPES.put("fixZ8b", new LispArrayS8.Prototype(0));
        _PROTOTYPES.put("fixN64b", new LispArrayU64.Prototype(0L));
        _PROTOTYPES.put("fixN32b", new LispArrayU32.Prototype(0));
        _PROTOTYPES.put("fixN16b", new LispArrayU16.Prototype(0));
        _PROTOTYPES.put("fixN8b", new LispArrayU8.Prototype(0));
        _PROTOTYPES.put("bool", new LispArrayT1.Prototype(false));
        _PROTOTYPES.put("char", new LispString("\u0000"));
    }

    private static LispArray makearray(int[] dims, String s, int p, LispMessage mesg) {
        if (p < s.length()) {
            LispArrayPrototype t = _PROTOTYPES.get(s.substring(p));
            if (t == null) {
                throw mesg.getError("err.srfi58.notation.specifier.invalid", s);
            }
            return t.makeArray(dims);
        }
        return ANYVEC.makeArray(dims);
    }

    private static LispArray makearray(int rank, String s, Datum d, int p, LispMessage mesg) {
        int[] is = ListToArray.getDimensions(d, mesg);
        if (rank >= 0 && is.length != rank) {
            throw mesg.getError("err.srfi58.notation.mismatch.rank", s);
        }
        return ParseSrfi58.makearray(is, s, p, mesg);
    }

    static LispArray parseNotation(String s, Datum d, LispMessage mesg) {
        int p = 0;
        int stat = 0;
        StringBuilder b = new StringBuilder();
        int rank = -1;
        List dims = null;
        while (p <= s.length()) {
            char c = p < s.length() ? s.charAt(p) : (char)'\u0000';
            switch (stat) {
                case 0: {
                    if (c >= '0' && c <= '9') {
                        b.append(c);
                        stat = 1;
                        break;
                    }
                    if (c == 'A') {
                        stat = 2;
                        break;
                    }
                    throw mesg.getError("err.srfi58.notation.syntaxerror", s);
                }
                case 1: {
                    if (c >= '0' && c <= '9') {
                        b.append(c);
                        break;
                    }
                    if (c == 'A') {
                        rank = Integer.parseInt(b.toString());
                        b = new StringBuilder();
                        stat = 2;
                        break;
                    }
                    if (c == '*') {
                        if (dims == null) {
                            dims = new IntegerArrayVector();
                        }
                        dims.add(Integer.parseInt(b.toString()));
                        b = new StringBuilder();
                        stat = 2;
                        break;
                    }
                    if (c == ':' || c == '\u0000') {
                        if (dims == null) {
                            dims = new IntegerArrayVector();
                        }
                        dims.add(Integer.parseInt(b.toString()));
                        return ParseSrfi58.makearray(dims.toIntArray(), s, p + 1, mesg);
                    }
                    throw mesg.getError("err.srfi58.notation.syntaxerror", s);
                }
                case 2: {
                    if (c >= '0' && c <= '9') {
                        b.append(c);
                        stat = 3;
                        break;
                    }
                    if (c == ':' || c == '\u0000') {
                        if (dims != null && rank != dims.size()) {
                            throw mesg.getError("err.srfi58.notation.mismatch.rank", s);
                        }
                        if (dims == null) {
                            return ParseSrfi58.makearray(rank, s, d, p + 1, mesg);
                        }
                        return ParseSrfi58.makearray(dims.toIntArray(), s, p + 1, mesg);
                    }
                    throw mesg.getError("err.srfi58.notation.syntaxerror", s);
                }
                case 3: {
                    if (c >= '0' && c <= '9') {
                        b.append(c);
                        stat = 3;
                        break;
                    }
                    if (c == '*') {
                        if (dims == null) {
                            dims = new IntegerArrayVector();
                        }
                        dims.add(Integer.parseInt(b.toString()));
                        b = new StringBuilder();
                        stat = 2;
                        break;
                    }
                    if (c == ':' || c == '\u0000') {
                        if (dims == null) {
                            dims = new IntegerArrayVector();
                        }
                        dims.add(Integer.parseInt(b.toString()));
                        if (rank >= 0 && rank != dims.size()) {
                            throw mesg.getError("err.srfi58.notation.mismatch.rank", s);
                        }
                        return ParseSrfi58.makearray(dims.toIntArray(), s, p + 1, mesg);
                    }
                    throw mesg.getError("err.srfi58.notation.syntaxerror", s);
                }
                default: {
                    throw new RuntimeException();
                }
            }
            ++p;
        }
        throw new RuntimeException();
    }

    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        String s = SubrUtils.getString(c1a, mesg);
        LispArray a = ParseSrfi58.parseNotation(s, c2a, mesg);
        try {
            return (Datum)((Object)ListToArray.setListToArray(a, c2a));
        }
        catch (InvalidDimensionException e) {
            throw mesg.getError("err.srfi25.dimension.invalid", c1a);
        }
        catch (IndexOutOfBoundsException e) {
            throw mesg.getError("err.range.invalid");
        }
        catch (ClassCastException e) {
            throw mesg.getError("err.srfi25.typemismatch");
        }
        catch (ValueOutOfBoundsException e) {
            throw mesg.getError("err.srfi47.valueoutofrange", e.getMessage());
        }
    }
}

