/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.array;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.MultiValues;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.SExpressionDatum;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.array.LispArray;
import net.morilib.lisp.array.LispArrayShape;
import net.morilib.lisp.array.LispDefaultArray;
import net.morilib.lisp.subr.SubrUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LispSharedArray
extends Datum2
implements LispArray {
    private LispArray array;
    private LispArrayShape shape;
    private Procedure proc;
    private Environment env;
    private LispMessage mesg;

    LispSharedArray(LispArray a, LispArrayShape s, Procedure p, Environment env, LispMessage mesg) {
        this.array = a;
        this.shape = s;
        this.proc = p;
        this.env = env;
        this.mesg = mesg;
    }

    LispSharedArray(LispArray a, int[] ei, Procedure p, Environment env, LispMessage mesg) {
        int[] bi = new int[ei.length];
        Arrays.fill(bi, 0);
        this.array = a;
        this.shape = new LispArrayShape(bi, ei);
        this.proc = p;
        this.env = env;
        this.mesg = mesg;
    }

    @Override
    public int rank() {
        return this.shape.rank();
    }

    @Override
    public int startIndex(int dim) {
        return this.shape.getStartIndex(dim);
    }

    @Override
    public int endIndex(int dim) {
        return this.shape.getEndIndex(dim);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public LispVector toVector() {
        is = new int[this.shape.rank()];
        rl = new Datum[this.shape.length()];
        n = 0;
        i = 0;
        while (i < is.length) {
            is[i] = this.shape.getStartIndex(i);
            ++i;
        }
        block1: while (true) {
            rl[n++] = this.getFromArray(is);
            i = is.length - 1;
            while (true) {
                if (i < 0) continue block1;
                v0 = i;
                is[v0] = is[v0] + 1;
                if (is[i] >= this.shape.getEndIndex(i)) ** break;
                continue block1;
                if (i == 0) break block1;
                is[i] = this.shape.getStartIndex(i);
                --i;
            }
            break;
        }
        return new LispVector(rl);
    }

    private int[] translateIndices(int ... is) {
        int[] it;
        if (!this.shape.isValidRange(is)) {
            throw new IndexOutOfBoundsException();
        }
        Datum[] isd = new Datum[is.length];
        int i = 0;
        while (i < is.length) {
            isd[i] = LispInteger.valueOf(is[i]);
            ++i;
        }
        Datum rp = Scheme.callva(this.proc, this.env, this.mesg, isd);
        if (rp instanceof MultiValues) {
            List<Datum> l = ((MultiValues)rp).getValues();
            it = new int[l.size()];
            int i2 = 0;
            while (i2 < it.length) {
                it[i2] = SubrUtils.getSmallIntegerExact(l.get(i2), this.mesg);
                ++i2;
            }
        } else if (rp instanceof SExpressionDatum) {
            List<Datum> l = LispUtils.consToList(rp, this.mesg);
            it = new int[l.size()];
            int i3 = 0;
            while (i3 < it.length) {
                it[i3] = SubrUtils.getSmallIntegerExact(l.get(i3), this.mesg);
                ++i3;
            }
        } else {
            it = new int[]{SubrUtils.getSmallIntegerExact(rp, this.mesg)};
        }
        return it;
    }

    @Override
    public Datum getFromArray(int ... is) {
        return this.array.getFromArray(this.translateIndices(is));
    }

    @Override
    public void setToArray(Datum d, int ... is) {
        this.array.setToArray(d, this.translateIndices(is));
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<array>");
    }

    @Override
    public boolean isIndexEqualTo(LispArray a) {
        if (this.rank() != a.rank()) {
            return false;
        }
        int i = 0;
        while (i < this.rank()) {
            if (this.startIndex(i) != a.startIndex(i)) {
                return false;
            }
            if (this.endIndex(i) != a.endIndex(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String getTypeSpecifier() {
        return this.array.getTypeSpecifier();
    }

    @Override
    public boolean isEqualTo(LispArray a) {
        return LispDefaultArray.isEqualTo(this, a);
    }

    @Override
    public void fill(Iterator<Datum> itr) {
        int[] is = new int[this.rank()];
        int i = 0;
        while (itr.hasNext()) {
            int j = this.rank() - 1;
            int k = i;
            while (j >= 0) {
                is[j] = k % (this.endIndex(j) - this.startIndex(j));
                k /= this.endIndex(j) - this.startIndex(j);
                --j;
            }
            this.setToArray(itr.next(), is);
            ++i;
        }
    }

    @Override
    public LispArrayShape getShape() {
        return this.shape;
    }
}

