/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SymbolName;
import net.morilib.lisp.UserSyntax;
import net.morilib.lisp.sos.LispType;

class SymbolScope
extends Datum
implements SymbolName {
    private Symbol symbol;
    private UserSyntax scope;
    private boolean captured = false;

    SymbolScope(Symbol symbol, UserSyntax scope, boolean cap) {
        if (symbol == null || scope == null) {
            throw new NullPointerException();
        }
        this.symbol = symbol;
        this.scope = scope;
        this.captured = cap;
    }

    SymbolScope(Symbol symbol, UserSyntax scope) {
        this(symbol, scope, false);
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public UserSyntax getUserSyntax() {
        return this.scope;
    }

    public Environment getExecuteEnv(Environment eenv) {
        if (this.scope.getRootSyntax() != null) {
            Environment s2 = this.scope.getRootSyntax().getExecuteEnv();
            if (s2 != null) {
                return s2;
            }
            throw new RuntimeException("environment has not been initialized");
        }
        if (this.scope.getExecuteEnv() == null) {
            throw new RuntimeException("environment has not been initialized");
        }
        return this.scope.getExecuteEnv();
    }

    public String toString() {
        return this.symbol + ":" + this.scope;
    }

    public boolean isTypeSymbol() {
        return true;
    }

    public String getName() {
        return this.symbol.getName();
    }

    public LispType getType() {
        return LispType.SYMBOL;
    }

    public boolean isCaptured() {
        return this.captured;
    }

    boolean isSameScope(SymbolScope s2) {
        return this.scope.getCompileEnv() == s2.scope.getCompileEnv();
    }

    public int hashCode() {
        int r = 17;
        r = r * 37 + this.symbol.hashCode();
        r = r * 37 + this.scope.hashCode();
        return r;
    }

    public boolean equals(Object o) {
        if (o instanceof SymbolScope) {
            SymbolScope s = (SymbolScope)o;
            return this.symbol.equals(s.symbol) && this.scope.equals(s.scope);
        }
        return false;
    }
}

