/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.SExpression;
import net.morilib.lisp.SExpressionDatum;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.collection.LispBag;
import net.morilib.lisp.collection.LispCollection;
import net.morilib.lisp.collection.LispDictionary;
import net.morilib.lisp.collection.LispMap;
import net.morilib.lisp.collection.LispSequence;
import net.morilib.lisp.sos.LispType;
import net.morilib.lisp.subr.IsEqual;
import net.morilib.util.Iterators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Nil
extends SExpressionDatum {
    public static final Nil NIL = new Nil();

    private Nil() {
    }

    @Override
    public String toString() {
        return "()";
    }

    @Override
    public boolean isNil() {
        return true;
    }

    @Override
    public LispType getType() {
        return LispType.NULL;
    }

    public Object toObject() {
        return null;
    }

    @Override
    public Datum get(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Datum copySet(int index, Datum d) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Datum set(int index, Datum d) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Datum replace(LispSequence src, int srcPos, int destPos, int len) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Datum arraycopy(LispSequence src, int srcPos, int destPos, int len) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Datum copy(int b, int e) {
        if (b == e) {
            return NIL;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Procedure equivalence() {
        return new IsEqual();
    }

    @Override
    public Datum copyAdd(Datum d) {
        return new Cons(d, NIL);
    }

    @Override
    public Datum add(Datum d) {
        return this.copyAdd(d);
    }

    @Override
    public Datum copyDelete(Datum d) {
        return NIL;
    }

    @Override
    public Datum delete(Datum d) {
        return NIL;
    }

    @Override
    public Datum copyDeleteAll(Datum d) {
        return NIL;
    }

    @Override
    public Datum deleteAll(Datum d) {
        return NIL;
    }

    @Override
    public Datum copyAddFrom(LispBag d) {
        return LispUtils.copy(d.iterator(), NIL);
    }

    @Override
    public Datum addFrom(LispBag d) {
        return this.copyAddFrom(d);
    }

    @Override
    public Datum copyDeleteFrom(LispBag d) {
        return NIL;
    }

    @Override
    public Datum deleteFrom(LispBag d) {
        return NIL;
    }

    @Override
    public Datum copyDeleteAllFrom(LispBag d) {
        return NIL;
    }

    @Override
    public Datum deleteAllFrom(LispBag d) {
        return NIL;
    }

    @Override
    public Symbol getCollectionName() {
        return Symbol.getSymbol("list");
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean equivalence(Datum a, Datum b) {
        return a.equals(b);
    }

    @Override
    public Datum prototype() {
        return NIL;
    }

    @Override
    public Datum clear() {
        return NIL;
    }

    @Override
    public boolean equalTo(LispCollection col) {
        return ((Datum)((Object)col)).isNil();
    }

    @Override
    public boolean equalTo(LispCollection col, Procedure proc, Environment env, LispMessage mesg) {
        return ((Datum)((Object)col)).isNil();
    }

    @Override
    public Datum duplicate() {
        return NIL;
    }

    @Override
    public boolean contains(Datum d) {
        return false;
    }

    @Override
    public Iterator<Datum> iterator() {
        return Iterators.emptyIterator();
    }

    @Override
    public Datum first() {
        throw new NoSuchElementException();
    }

    @Override
    public Datum last() {
        throw new NoSuchElementException();
    }

    @Override
    public Datum insertFirst(Datum d) {
        return new Cons(d, NIL);
    }

    @Override
    public Datum insertLast(Datum d) {
        return new Cons(d, NIL);
    }

    @Override
    public Datum copyInsertFirst(Datum d) {
        return new Cons(d, NIL);
    }

    @Override
    public Datum copyInsertLast(Datum d) {
        return new Cons(d, NIL);
    }

    @Override
    public Datum[] removeFirst() {
        throw new NoSuchElementException();
    }

    @Override
    public Datum[] removeLast() {
        throw new NoSuchElementException();
    }

    @Override
    public Datum[] copyWithoutFirst() {
        throw new NoSuchElementException();
    }

    @Override
    public Datum[] copyWithoutLast() {
        throw new NoSuchElementException();
    }

    @Override
    public Datum copyInsert(int index, Datum d) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return new Cons(d, NIL);
    }

    @Override
    public Datum insert(int index, Datum d) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        return new Cons(d, NIL);
    }

    @Override
    public Datum copyDelete(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Datum delete(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Iterator<Map.Entry<Datum, Datum>> entryIterator() {
        return Iterators.emptyIterator();
    }

    @Override
    public Procedure keyEquivalence() {
        return new IsEqual();
    }

    @Override
    public Procedure valueEquivalence() {
        return new IsEqual();
    }

    @Override
    public boolean containsKey(Datum k) {
        return false;
    }

    @Override
    public SExpressionDatum keysToList() {
        return NIL;
    }

    @Override
    public Datum get(Datum k) {
        return null;
    }

    @Override
    public Datum[] copyPut(Datum k, Datum v) {
        Datum[] r = new Datum[]{new Cons(new Cons(k, v), NIL), null};
        return r;
    }

    @Override
    public Datum[] put(Datum k, Datum v) {
        return this.copyPut(k, v);
    }

    @Override
    public Datum copyAddFrom(LispMap m) {
        return LispUtils.toCons(m);
    }

    @Override
    public Datum addFrom(LispMap m) {
        return this.copyAddFrom(m);
    }

    @Override
    public Datum copyDeleteKey(Datum k) {
        return NIL;
    }

    @Override
    public Datum deleteKey(Datum k) {
        return NIL;
    }

    @Override
    public int count(Datum c2a) {
        return 0;
    }

    @Override
    public boolean equivalenceKey(Datum a, Datum b) {
        return LispUtils.equals(a, b);
    }

    @Override
    public boolean equivalenceValue(Datum a, Datum b) {
        return LispUtils.equals(a, b);
    }

    @Override
    public Datum copyDeleteFromKey(LispBag k) {
        return NIL;
    }

    @Override
    public Datum deleteFromKey(LispBag k) {
        return NIL;
    }

    @Override
    public SExpressionDatum getAllAsList(Datum k) {
        return NIL;
    }

    @Override
    public Datum copyUpdateAll(Datum k, Procedure f, Procedure th, Environment env, LispMessage mesg) {
        Cons d = th == null ? new Cons(k, LispBoolean.FALSE) : new Cons(k, Scheme.callva(th, env, mesg, new Datum[0]));
        return LispUtils.list(d);
    }

    @Override
    public Datum updateAll(Datum k, Procedure f, Procedure th, Environment env, LispMessage mesg) {
        return this.copyUpdateAll(k, f, th, env, mesg);
    }

    @Override
    public Datum copyDeleteAllKey(Datum k) {
        return NIL;
    }

    @Override
    public Datum deleteAllKey(Datum k) {
        return NIL;
    }

    @Override
    public Datum copyDeleteAllFromKey(LispBag c2a) {
        return NIL;
    }

    @Override
    public Datum deleteAllFromKey(LispBag c2a) {
        return NIL;
    }

    @Override
    public Datum copyAddFrom(LispDictionary d) {
        return LispUtils.toAlist(d.entryIterator());
    }

    @Override
    public Datum addFrom(LispDictionary d) {
        return LispUtils.toAlist(d.entryIterator());
    }

    @Override
    public Datum copyReplaceAll(Datum k, Datum[] array) {
        ConsListBuilder b = new ConsListBuilder();
        Datum[] datumArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Datum x = datumArray[n2];
            b.append(new Cons(k, x));
            ++n2;
        }
        return b.get();
    }

    @Override
    public Datum replaceAll(Datum k, Datum[] array) {
        return this.copyReplaceAll(k, array);
    }

    @Override
    public Datum toList() {
        return this;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("()");
    }

    @Override
    public int countValue(Datum d) {
        return 0;
    }

    @Override
    public int countKey(Datum d) {
        return 0;
    }

    @Override
    public boolean equalToMap(LispMap e, Procedure p, Environment env, LispMessage mesg) {
        return e.size() == 0;
    }

    @Override
    public boolean equalToDictionary(LispDictionary e, Procedure p, Environment env, LispMessage mesg) {
        return e.size() == 0;
    }

    @Override
    public SExpression add(SExpression y) {
        return y;
    }

    @Override
    public SExpression mul(SExpression y) {
        return this;
    }
}

