/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.ILispVector;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.array.LispArray;
import net.morilib.lisp.array.LispArrayPrototype;
import net.morilib.lisp.array.LispArrayShape;
import net.morilib.lisp.array.LispDefaultArray;
import net.morilib.lisp.collection.LispBag;
import net.morilib.lisp.collection.LispCollection;
import net.morilib.lisp.collection.LispPurelyMutableCollection;
import net.morilib.lisp.collection.LispSequence;
import net.morilib.lisp.math.algebra.ILispAddable;
import net.morilib.lisp.sos.LispType;
import net.morilib.lisp.subr.IsEqual;
import net.morilib.util.Iterators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LispVector
extends Datum
implements LispSequence,
LispPurelyMutableCollection,
LispArray,
LispArrayPrototype,
ILispVector,
ILispAddable<LispVector>,
Serializable {
    private static final long serialVersionUID = 3364203058083838114L;
    private List<Datum> vec;
    private static final List<Datum> _EMPTY = Collections.emptyList();
    public static final LispVector EMPTY = new LispVector(_EMPTY);

    public LispVector(List<Datum> vec) {
        if (vec == null) {
            throw new NullPointerException();
        }
        this.vec = vec;
    }

    public LispVector(Datum ... data) {
        this(Arrays.asList(data));
    }

    public LispVector() {
        this(new ArrayList<Datum>());
    }

    public LispVector(LispVector vec) {
        if (vec == null) {
            throw new NullPointerException();
        }
        this.vec = new ArrayList<Datum>(vec.vec);
    }

    public LispVector(int size) {
        this(new ArrayList<Datum>(size));
    }

    @Override
    public Datum get(int index) {
        return this.vec.get(index);
    }

    void setS(int index, Datum d) {
        this.vec.set(index, d);
    }

    @Override
    public int size() {
        return this.vec.size();
    }

    public Datum toConsList() {
        return LispUtils.listToCons(this.vec);
    }

    @Override
    public String toString() {
        return LispUtils.getResult(this);
    }

    @Override
    public boolean isTypeVector() {
        return true;
    }

    @Override
    public List<Datum> getList() {
        return Collections.unmodifiableList(this.vec);
    }

    @Override
    public LispType getType() {
        return LispType.VECTOR;
    }

    @Override
    public Datum copySet(int index, Datum d) {
        return this.duplicate().set(index, d);
    }

    @Override
    public Datum set(int index, Datum d) {
        this.setS(index, d);
        return this;
    }

    @Override
    public Datum replace(LispSequence src, int srcPos, int destPos, int len) {
        return this.duplicate().arraycopy(src, srcPos, destPos, len);
    }

    @Override
    public Datum arraycopy(LispSequence src, int srcPos, int destPos, int len) {
        int i = 0;
        while (i < len) {
            this.setS(i + destPos, src.get(i + srcPos));
            ++i;
        }
        return this;
    }

    @Override
    public Datum copy(int b, int e) {
        LispVector r = new LispVector();
        if (b < 0 || b >= this.size()) {
            throw new IndexOutOfBoundsException("" + b);
        }
        int i = b;
        while (i < e) {
            r.vec.add(this.get(i));
            ++i;
        }
        return r;
    }

    @Override
    public Procedure equivalence() {
        return new IsEqual();
    }

    @Override
    public Datum copyAdd(Datum d) {
        return this.duplicate().add(d);
    }

    @Override
    public Datum add(Datum d) {
        this.vec.add(d);
        return this;
    }

    @Override
    public Datum copyDelete(Datum d) {
        return this.duplicate().delete(d);
    }

    @Override
    public Datum delete(Datum d) {
        int i = 0;
        while (i < this.vec.size()) {
            this.vec.remove(i);
            ++i;
        }
        return this;
    }

    @Override
    public Datum copyDeleteAll(Datum d) {
        return this.duplicate().deleteAll(d);
    }

    @Override
    public Datum deleteAll(Datum d) {
        this.vec.remove(d);
        return this;
    }

    @Override
    public Datum copyAddFrom(LispBag d) {
        return this.duplicate().addFrom(d);
    }

    @Override
    public Datum addFrom(LispBag d) {
        for (Datum x : d) {
            this.vec.add(x);
        }
        return this;
    }

    @Override
    public Datum copyDeleteFrom(LispBag d) {
        return this.duplicate().deleteFrom(d);
    }

    @Override
    public Datum deleteFrom(LispBag d) {
        for (Datum x : d) {
            int i = this.vec.indexOf(x);
            if (i < 0) continue;
            this.vec.remove(i);
        }
        return this;
    }

    @Override
    public Datum copyDeleteAllFrom(LispBag d) {
        return this.duplicate().deleteAllFrom(d);
    }

    @Override
    public Datum deleteAllFrom(LispBag d) {
        for (Datum x : d) {
            this.vec.remove(x);
        }
        return this;
    }

    @Override
    public Symbol getCollectionName() {
        return Symbol.getSymbol("vector");
    }

    @Override
    public boolean equivalence(Datum a, Datum b) {
        return LispUtils.equals(a, b);
    }

    @Override
    public Datum prototype() {
        return new LispVector();
    }

    @Override
    public Datum clear() {
        this.vec.clear();
        return this;
    }

    @Override
    public boolean equalTo(LispCollection col) {
        Iterator itr = col.iterator();
        int i = 0;
        while (i < this.vec.size() && itr.hasNext()) {
            if (!LispUtils.equals((Datum)itr.next(), this.vec.get(i))) {
                return false;
            }
            ++i;
        }
        return i >= this.vec.size() && !itr.hasNext();
    }

    @Override
    public boolean equalTo(LispCollection col, Procedure proc, Environment env, LispMessage mesg) {
        Iterator itr = col.iterator();
        int i = 0;
        while (i < this.vec.size() && itr.hasNext()) {
            if (!Scheme.callva(proc, env, mesg, this.vec.get(i), (Datum)itr.next()).isTrue()) {
                return false;
            }
            ++i;
        }
        return i >= this.vec.size() && !itr.hasNext();
    }

    @Override
    public LispVector duplicate() {
        return new LispVector(this);
    }

    @Override
    public boolean contains(Datum d) {
        return this.vec.contains(d);
    }

    @Override
    public Iterator<Datum> iterator() {
        return Iterators.unmodifiable(this.vec.iterator());
    }

    @Override
    public int count(Datum c2a) {
        int r = 0;
        int i = 0;
        while (i < this.vec.size()) {
            if (LispUtils.equals(this.vec.get(i), c2a)) {
                ++r;
            }
            ++i;
        }
        return r;
    }

    @Override
    public Datum toList() {
        return LispUtils.toCons(this.vec);
    }

    @Override
    public Datum first() {
        if (this.vec.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.vec.get(0);
    }

    @Override
    public Datum last() {
        if (this.vec.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.vec.get(this.vec.size() - 1);
    }

    @Override
    public int rank() {
        return 1;
    }

    @Override
    public int startIndex(int dim) {
        if (dim != 0) {
            throw new IndexOutOfBoundsException();
        }
        return 0;
    }

    @Override
    public int endIndex(int dim) {
        if (dim != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.size();
    }

    @Override
    public LispVector toVector() {
        return this;
    }

    @Override
    public Datum getFromArray(int ... is) {
        if (is.length != 1) {
            throw new IndexOutOfBoundsException();
        }
        return this.vec.get(is[0]);
    }

    @Override
    public void setToArray(Datum d, int ... is) {
        if (is.length != 1) {
            throw new IndexOutOfBoundsException();
        }
        this.vec.set(is[0], d);
    }

    @Override
    public boolean isIndexEqualTo(LispArray a) {
        return a.rank() == 1 && a.startIndex(0) == 0 && a.endIndex(0) == this.size();
    }

    @Override
    public boolean isEqualTo(LispArray a) {
        if (!this.isIndexEqualTo(a)) {
            return false;
        }
        int i = 0;
        while (i < a.endIndex(0)) {
            if (!LispUtils.equals(this.vec.get(i), a.getFromArray(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String getTypeSpecifier() {
        return null;
    }

    @Override
    public LispArray makeArray(int ... is) {
        int[] bi = new int[is.length];
        int[] ei = new int[is.length];
        Arrays.fill(bi, 0);
        System.arraycopy(is, 0, ei, 0, is.length);
        return LispDefaultArray.malloc(bi, ei, this.vec.isEmpty() ? Undef.UNDEF : this.vec.get(0));
    }

    @Override
    public void fill(Iterator<Datum> itr) {
        int i = 0;
        while (i < this.vec.size() && itr.hasNext()) {
            this.vec.set(i, itr.next());
            ++i;
        }
    }

    @Override
    public LispArrayShape getShape() {
        return new LispArrayShape(new int[]{this.vec.size()});
    }

    @Override
    public LispVector add(LispVector y) {
        ArrayList<Datum> x = new ArrayList<Datum>(this.vec);
        x.addAll(y.vec);
        return new LispVector(x);
    }
}

