/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.morilib.lang.Decimal32;
import net.morilib.lang.Decimal64;
import net.morilib.lang.number.Integer2;
import net.morilib.lang.number.Rational;
import net.morilib.lisp.JavaObjective;
import net.morilib.lisp.LispBigInt;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispRational;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.math.InvalidOrdinalNumberException;
import net.morilib.lisp.math.LispOrdinalNumber;
import net.morilib.util.Inclementor;
import net.morilib.util.IntMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LispSmallInt
extends LispInteger
implements JavaObjective,
Serializable {
    private static final long serialVersionUID = -2512252765408329066L;
    private int value;

    LispSmallInt(int value) {
        this.value = value;
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (x instanceof LispSmallInt) {
            long vr1 = this.value;
            long vr2 = x.getExactSmallInt();
            return LispInteger.valueOf(vr1 + vr2);
        }
        if (x instanceof LispBigInt) {
            BigInteger vb = BigInteger.valueOf(this.value);
            return LispInteger.valueOf(vb.add(x.getBigInteger()));
        }
        if (x instanceof LispRational) {
            LispRational r = (LispRational)x;
            BigInteger vb = BigInteger.valueOf(this.value);
            BigInteger nd = r.getDenominator();
            BigInteger nn = vb.multiply(r.getDenominator()).add(r.getNumerator());
            return LispRational.newRational(nn, nd);
        }
        return super.add(x);
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (x instanceof LispSmallInt) {
            return LispRational.newRational(this.value, x.getExactSmallInt());
        }
        if (x instanceof LispBigInt) {
            BigInteger vb = BigInteger.valueOf(this.value);
            return LispRational.newRational(vb, x.getBigInteger());
        }
        if (x instanceof LispRational) {
            LispRational r = (LispRational)x;
            BigInteger vb = BigInteger.valueOf(this.value);
            BigInteger nd = r.getNumerator();
            BigInteger nn = vb.multiply(r.getDenominator());
            return LispRational.newRational(nn, nd);
        }
        return super.div(x);
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (x instanceof LispSmallInt) {
            long vr1 = this.value;
            long vr2 = x.getExactSmallInt();
            return LispInteger.valueOf(vr1 * vr2);
        }
        if (x instanceof LispBigInt) {
            BigInteger vb = BigInteger.valueOf(this.value);
            return LispInteger.valueOf(vb.multiply(x.getBigInteger()));
        }
        if (x instanceof LispRational) {
            LispRational r = (LispRational)x;
            BigInteger vb = BigInteger.valueOf(this.value);
            BigInteger nd = r.getDenominator();
            BigInteger nn = vb.multiply(r.getNumerator());
            return LispRational.newRational(nn, nd);
        }
        return super.mul(x);
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (x instanceof LispSmallInt) {
            long vr1 = this.value;
            long vr2 = x.getExactSmallInt();
            return LispInteger.valueOf(vr1 - vr2);
        }
        if (x instanceof LispBigInt) {
            BigInteger vb = BigInteger.valueOf(this.value);
            return LispInteger.valueOf(vb.subtract(x.getBigInteger()));
        }
        if (x instanceof LispRational) {
            LispRational r = (LispRational)x;
            BigInteger vb = BigInteger.valueOf(this.value);
            BigInteger nd = r.getDenominator();
            BigInteger nn = vb.multiply(r.getDenominator()).subtract(r.getNumerator());
            return LispRational.newRational(nn, nd);
        }
        return super.sub(x);
    }

    @Override
    public LispInteger uminus() {
        return new LispSmallInt(-this.value);
    }

    @Override
    public int signum() {
        return IntMath.signum(this.value);
    }

    @Override
    public boolean isEqualTo(LispNumber x) {
        if (x instanceof LispSmallInt) {
            return this.value == x.getExactSmallInt();
        }
        if (x instanceof LispBigInt) {
            return false;
        }
        if (x instanceof LispRational) {
            return false;
        }
        if (x instanceof LispDouble) {
            return (double)this.value == ((LispDouble)x).doubleValue();
        }
        return false;
    }

    @Override
    public boolean isLessThan(LispReal x) {
        if (x instanceof LispSmallInt) {
            return this.value < x.getExactSmallInt();
        }
        if (x instanceof LispBigInt) {
            BigInteger vb = BigInteger.valueOf(this.value);
            return vb.compareTo(x.getBigInteger()) < 0;
        }
        if (x instanceof LispRational) {
            BigInteger n2;
            LispRational r = (LispRational)x;
            BigInteger vb = BigInteger.valueOf(this.value);
            BigInteger n1 = vb.multiply(r.getDenominator());
            return n1.compareTo(n2 = r.getNumerator()) < 0;
        }
        if (x instanceof LispDouble) {
            return (double)this.value < x.getRealDouble();
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public boolean isMoreThan(LispReal x) {
        if (x instanceof LispSmallInt) {
            return this.value > x.getExactSmallInt();
        }
        if (x instanceof LispBigInt) {
            BigInteger vb = BigInteger.valueOf(this.value);
            return vb.compareTo(x.getBigInteger()) > 0;
        }
        if (x instanceof LispRational) {
            BigInteger n2;
            LispRational r = (LispRational)x;
            BigInteger vb = BigInteger.valueOf(this.value);
            BigInteger n1 = vb.multiply(r.getDenominator());
            return n1.compareTo(n2 = r.getNumerator()) > 0;
        }
        if (x instanceof LispDouble) {
            return (double)this.value > x.getRealDouble();
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispReal toInexact() {
        return new LispDouble(this.value);
    }

    @Override
    public String print() {
        return Integer.toString(this.value);
    }

    @Override
    public String getResult() {
        return Integer.toString(this.value);
    }

    @Override
    public LispString toLispString(int radix) {
        if (radix < 2 || radix > 36) {
            throw new IndexOutOfBoundsException("radix is out of range");
        }
        return new LispString(Integer.toString(this.value, radix));
    }

    @Override
    public boolean isOne() {
        return this.value == 1;
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    public int getExactSmallInt() {
        return this.value;
    }

    @Override
    public double getRealDouble() {
        return this.value;
    }

    @Override
    public long getRealDecimal64() {
        return Decimal64.toDecimal(this.value);
    }

    @Override
    public int getRealDecimal32() {
        return Decimal32.toDecimal(this.value);
    }

    @Override
    public boolean equalIncliment(Inclementor<?> i) {
        if (i instanceof LispSmallInt) {
            return this.value == ((LispSmallInt)i).value;
        }
        return i.equalInt(this.value);
    }

    @Override
    public boolean equalInt(int i) {
        return this.value == i;
    }

    @Override
    public boolean equalInt(BigInteger i) {
        return i.equals(BigInteger.valueOf(this.value));
    }

    @Override
    public Inclementor<LispInteger> suc() {
        return this.suc(1);
    }

    @Override
    public Inclementor<LispInteger> suc(int step) {
        long r = (long)this.value + (long)step;
        return LispInteger.valueOf(r);
    }

    @Override
    public int toInt() {
        return this.value;
    }

    @Override
    public Rational toRational() {
        return Rational.valueOf(this.value, 1);
    }

    @Override
    public boolean isUnit() {
        return this.value == 1;
    }

    @Override
    public LispReal invert() {
        return LispRational.newRational(1, this.value);
    }

    @Override
    public int castInt() {
        return this.value;
    }

    @Override
    public long castLong() {
        return this.value;
    }

    @Override
    public Integer2 castInteger2() {
        return Integer2.valueOf(this.value);
    }

    @Override
    public int intFloor() {
        return this.value;
    }

    @Override
    public long longFloor() {
        return this.value;
    }

    @Override
    public Integer2 getInteger2Floor() {
        return Integer2.valueOf(this.value);
    }

    @Override
    public int intCeil() {
        return this.value;
    }

    @Override
    public long longCeil() {
        return this.value;
    }

    @Override
    public Integer2 getInteger2Ceil() {
        return Integer2.valueOf(this.value);
    }

    @Override
    public Rational getRational() {
        return this.toRational();
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Object toObject() {
        return new Integer(this.value);
    }

    @Override
    public LispOrdinalNumber inclement() {
        if (this.value < 0) {
            throw new InvalidOrdinalNumberException();
        }
        if (this.value == Integer.MAX_VALUE) {
            return LispInteger.valueOf(0x80000000L);
        }
        return LispInteger.valueOf(this.value + 1);
    }

    @Override
    public boolean equals(Object x) {
        if (x instanceof LispSmallInt) {
            return this.value == ((LispSmallInt)x).value;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int l = 17;
        l = 37 * l + this.value;
        return l;
    }

    @Override
    public String toString() {
        return Integer.toString(this.value);
    }
}

