/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispComplexImpl;
import net.morilib.lisp.LispMath;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispOctonion;
import net.morilib.lisp.LispQuaternion;
import net.morilib.lisp.LispReal;

public class LispQuaternionImpl
extends LispQuaternion {
    private LispReal re;
    private LispReal ii;
    private LispReal ij;
    private LispReal ik;

    LispQuaternionImpl(LispReal r, LispReal i, LispReal j, LispReal k) {
        this.re = r;
        this.ii = i;
        this.ij = j;
        this.ik = k;
    }

    LispComplex getComplexPairA() {
        return LispComplexImpl.newComplex(this.re, this.ii);
    }

    LispComplex getComplexPairB() {
        return LispComplexImpl.newComplex(this.ij, this.ik);
    }

    public LispNumber add(LispNumber x) {
        if (x instanceof LispReal) {
            return LispQuaternion.newQuaternion(this.re.add(x.getReal()), this.ii, this.ij, this.ik);
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.add(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.add(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    public LispNumber sub(LispNumber x) {
        if (x instanceof LispReal) {
            return LispQuaternion.newQuaternion(this.re.subtract(x.getReal()), this.ii, this.ij, this.ik);
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.sub(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.sub(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    public LispNumber mul(LispNumber x) {
        if (x instanceof LispReal) {
            LispReal a = x.getReal();
            return LispQuaternion.newQuaternion(this.re.multiply(a), this.ii.multiply(a), this.ij.multiply(a), this.ik.multiply(a));
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.mul(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.mul(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    public LispNumber div(LispNumber x) {
        if (x instanceof LispReal) {
            LispReal a = x.getReal();
            return LispQuaternion.newQuaternion(this.re.divide(a), this.ii.divide(a), this.ij.divide(a), this.ik.divide(a));
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.div(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.div(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    public LispQuaternion uminus() {
        return new LispQuaternionImpl(this.re.uminus(), this.ii.uminus(), this.ij.uminus(), this.ik.uminus());
    }

    public boolean isExact() {
        return this.re.isExact();
    }

    public LispQuaternion toExact() {
        return LispQuaternionImpl.newQuaternion(this.re.toExact(), this.ii.toExact(), this.ij.toExact(), this.ik.toExact());
    }

    public LispQuaternion toInexact() {
        return LispQuaternionImpl.newQuaternion(this.re.toInexact(), this.ii.toInexact(), this.ij.toInexact(), this.ik.toInexact());
    }

    public LispReal norm() {
        return (LispReal)LispMath.sqrt(this.re.multiply(this.re).add(this.ii.multiply(this.ii)).add(this.ij.multiply(this.ij)).add(this.ik.multiply(this.ik)));
    }

    public LispQuaternion conjugate() {
        return new LispQuaternionImpl(this.re, this.ii.uminus(), this.ij.uminus(), this.ik.uminus());
    }

    public LispReal getReal() {
        return this.re;
    }

    public double getRealDouble() {
        return this.re.getRealDouble();
    }

    public LispReal[] getImags() {
        return new LispReal[]{this.ii, this.ij, this.ik};
    }

    public double[] getImagsDouble() {
        return new double[]{this.ii.getRealDouble(), this.ij.getRealDouble(), this.ik.getRealDouble()};
    }

    public int hashCode() {
        int r = 17;
        r = 37 * (r + this.re.hashCode());
        r = 37 * (r + this.ii.hashCode());
        r = 37 * (r + this.ij.hashCode());
        r = 37 * (r + this.ik.hashCode());
        return r;
    }

    public boolean equals(Object o) {
        if (o instanceof LispQuaternionImpl) {
            LispQuaternionImpl q = (LispQuaternionImpl)o;
            return this.re.equals(q.re) && this.ii.equals(q.ii) && this.ij.equals(q.ij) && this.ik.equals(q.ik);
        }
        return false;
    }
}

