/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import net.morilib.lisp.LispMath;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispOctonion;
import net.morilib.lisp.LispQuaternion;
import net.morilib.lisp.LispReal;

public class LispOctonionImpl
extends LispOctonion {
    private LispQuaternion pa;
    private LispQuaternion pb;

    LispOctonionImpl(LispQuaternion pa, LispQuaternion pb) {
        this.pa = pa;
        this.pb = pb;
    }

    LispQuaternion getQuaternionPairA() {
        return this.pa;
    }

    LispQuaternion getQuaternionPairB() {
        return this.pb;
    }

    public LispNumber add(LispNumber x) {
        if (x instanceof LispReal) {
            return LispOctonion.newOctonion((LispQuaternion)this.pa.add(x), this.pb);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.add(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    public LispNumber sub(LispNumber x) {
        if (x instanceof LispReal) {
            return LispOctonion.newOctonion((LispQuaternion)this.pa.sub(x), this.pb);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.sub(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    public LispNumber mul(LispNumber x) {
        if (x instanceof LispReal) {
            LispReal a = x.getReal();
            return LispOctonion.newOctonion((LispQuaternion)this.pa.mul(a), (LispQuaternion)this.pb.mul(a));
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.mul(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    public LispNumber div(LispNumber x) {
        if (x instanceof LispReal) {
            LispReal a = x.getReal();
            return LispOctonion.newOctonion((LispQuaternion)this.pa.div(a), (LispQuaternion)this.pb.div(a));
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.div(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    public LispOctonion uminus() {
        return new LispOctonionImpl(this.pa.uminus(), this.pb.uminus());
    }

    public boolean isExact() {
        return this.pa.isExact();
    }

    public LispOctonion toExact() {
        return LispOctonionImpl.newOctonion(this.pa.toExact(), this.pb.toExact());
    }

    public LispOctonion toInexact() {
        return LispOctonionImpl.newOctonion(this.pa.toInexact(), this.pb.toInexact());
    }

    public LispReal norm() {
        LispReal re = this.getReal();
        LispReal[] im = this.getImags();
        return (LispReal)LispMath.sqrt(re.multiply(re).add(im[0].multiply(im[0])).add(im[1].multiply(im[1])).add(im[2].multiply(im[2])).add(im[3].multiply(im[3])).add(im[4].multiply(im[4])).add(im[5].multiply(im[5])).add(im[6].multiply(im[6])));
    }

    public LispNumber conjugate() {
        return new LispOctonionImpl(this.pa.conjugate(), this.pb.uminus());
    }

    public int hashCode() {
        int r = 17;
        r = 37 * (r + this.pa.hashCode());
        r = 37 * (r + this.pb.hashCode());
        return r;
    }

    public boolean equals(Object o) {
        if (o instanceof LispOctonionImpl) {
            LispOctonionImpl q = (LispOctonionImpl)o;
            return this.pa.equals(q.pa) && this.pb.equals(q.pb);
        }
        return false;
    }
}

