/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispOctonionImpl;
import net.morilib.lisp.LispQuaternion;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;

public abstract class LispOctonion
extends LispNumber {
    public static LispOctonion newOctonion(LispQuaternion qa, LispQuaternion qb) {
        if (qa.isNaN() || qb.isNaN()) {
            return LispDouble.NaN;
        }
        if (qb.isZero()) {
            return qa;
        }
        if (qa.isExact() && qb.isExact()) {
            return new LispOctonionImpl(qa, qb);
        }
        return new LispOctonionImpl(qa.toInexact(), qb.toInexact());
    }

    public static LispOctonion newOctonion(LispReal r, LispReal i, LispReal j, LispReal k, LispReal l, LispReal il, LispReal jl, LispReal kl) {
        LispQuaternion rp = LispQuaternion.newQuaternion(r, i, j, k);
        LispQuaternion ip = LispQuaternion.newQuaternion(l, il, jl, kl);
        return LispOctonion.newOctonion(rp, ip);
    }

    public static LispOctonion add(LispOctonion o1, LispOctonion o2) {
        LispQuaternion o1a = o1.getQuaternionPairA();
        LispQuaternion o1b = o1.getQuaternionPairB();
        LispQuaternion o2a = o2.getQuaternionPairA();
        LispQuaternion o2b = o2.getQuaternionPairB();
        return LispOctonion.newOctonion(LispQuaternion.add(o1a, o2a), LispQuaternion.add(o1b, o2b));
    }

    public static LispOctonion sub(LispOctonion o1, LispOctonion o2) {
        LispQuaternion o1a = o1.getQuaternionPairA();
        LispQuaternion o1b = o1.getQuaternionPairB();
        LispQuaternion o2a = o2.getQuaternionPairA();
        LispQuaternion o2b = o2.getQuaternionPairB();
        return LispOctonion.newOctonion(LispQuaternion.sub(o1a, o2a), LispQuaternion.sub(o1b, o2b));
    }

    public static LispOctonion mul(LispOctonion o1, LispOctonion o2) {
        LispQuaternion p = o1.getQuaternionPairA();
        LispQuaternion q = o1.getQuaternionPairB();
        LispQuaternion r = o2.getQuaternionPairA();
        LispQuaternion s = o2.getQuaternionPairB();
        return LispOctonion.newOctonion((LispQuaternion)p.mul(r).sub(s.conjugate().mul(q)), (LispQuaternion)s.mul(p).add(q.mul(r.conjugate())));
    }

    public static LispOctonion div(LispOctonion o1, LispOctonion o2) {
        LispReal[] im = o2.getImagsAsOctonion();
        LispReal nr = o2.getReal().multiply(o2.getReal());
        nr = nr.add(im[0].multiply(im[0]));
        nr = nr.add(im[1].multiply(im[1]));
        nr = nr.add(im[2].multiply(im[2]));
        nr = nr.add(im[3].multiply(im[3]));
        nr = nr.add(im[4].multiply(im[4]));
        nr = nr.add(im[5].multiply(im[5]));
        nr = nr.add(im[6].multiply(im[6]));
        return (LispOctonion)o1.mul(o2.conjugate().div(nr));
    }

    public LispQuaternion[] getQuaternionPair() {
        return new LispQuaternion[]{this.getQuaternionPairA(), this.getQuaternionPairB()};
    }

    abstract LispQuaternion getQuaternionPairA();

    abstract LispQuaternion getQuaternionPairB();

    public boolean isEqualTo(LispNumber x) {
        if (x instanceof LispOctonion) {
            LispOctonion q = (LispOctonion)x;
            return this.getQuaternionPairA().isEqualTo(q.getQuaternionPairA()) && this.getQuaternionPairB().isEqualTo(q.getQuaternionPairB());
        }
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isRational() {
        return false;
    }

    public boolean isReal() {
        return false;
    }

    public boolean isNaN() {
        return false;
    }

    public boolean isOne() {
        return false;
    }

    public int getInt() {
        throw new UnsupportedOperationException();
    }

    public long getLong() {
        throw new UnsupportedOperationException();
    }

    public BigInteger getBigInteger() {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal() {
        throw new UnsupportedOperationException();
    }

    public LispReal getReal() {
        return this.getQuaternionPairA().getReal();
    }

    public double getRealDouble() {
        return this.getQuaternionPairA().getRealDouble();
    }

    public long getRealDecimal64() {
        return this.getReal().getRealDecimal64();
    }

    public BigInteger getNumerator() {
        throw new UnsupportedOperationException();
    }

    public BigInteger getDenominator() {
        throw new UnsupportedOperationException();
    }

    public LispReal[] getImags() {
        LispReal[] pa = this.getQuaternionPairA().getImagsAsQuaternion();
        LispReal[] pb = this.getQuaternionPairB().getImagsAsQuaternion();
        return new LispReal[]{pa[0], pa[1], pa[2], this.getQuaternionPairB().getReal(), pb[0], pb[1], pb[2]};
    }

    public double[] getImagsDouble() {
        double[] pa = this.getQuaternionPairA().getImagsDoubleAsQuaternion();
        double[] pb = this.getQuaternionPairB().getImagsDoubleAsQuaternion();
        return new double[]{pa[0], pa[1], pa[2], this.getQuaternionPairB().getRealDouble(), pb[0], pb[1], pb[2]};
    }

    public LispReal[] getImagsAsQuaternion() {
        throw new RuntimeException("not quaternion");
    }

    public double[] getImagsDoubleAsQuaternion() {
        throw new RuntimeException("not quaternion");
    }

    public LispReal[] getImagsAsOctonion() {
        return this.getImags();
    }

    public double[] getImagsDoubleAsOctonion() {
        return this.getImagsDouble();
    }

    public LispString toLispString(int radix) {
        StringBuilder b = new StringBuilder();
        if (radix < 2 || radix > 36) {
            throw new IndexOutOfBoundsException("radix is out of range");
        }
        if (radix != 10) {
            throw new IllegalArgumentException("radix except 10 is not supported");
        }
        LispReal re = this.getReal();
        LispReal[] ims = this.getImags();
        String si = ims[0].signum() > 0 && !ims[0].isInfinity() ? "+" : "";
        String sj = ims[1].signum() > 0 && !ims[1].isInfinity() ? "+" : "";
        String sk = ims[2].signum() > 0 && !ims[2].isInfinity() ? "+" : "";
        String sl = ims[3].signum() > 0 && !ims[3].isInfinity() ? "+" : "";
        String sil = ims[4].signum() > 0 && !ims[4].isInfinity() ? "+" : "";
        String sjl = ims[5].signum() > 0 && !ims[5].isInfinity() ? "+" : "";
        String skl = ims[6].signum() > 0 && !ims[6].isInfinity() ? "+" : "";
        b.append(LispUtils.getResult(re));
        if (!ims[0].isZero()) {
            b.append(si).append(LispUtils.getResult(ims[0])).append("i");
        }
        if (!ims[1].isZero()) {
            b.append(sj).append(LispUtils.getResult(ims[1])).append("j");
        }
        if (!ims[2].isZero()) {
            b.append(sk).append(LispUtils.getResult(ims[2])).append("k");
        }
        if (!ims[3].isZero()) {
            b.append(sl).append(LispUtils.getResult(ims[3])).append("o");
        }
        if (!ims[4].isZero()) {
            b.append(sil).append(LispUtils.getResult(ims[4])).append("io");
        }
        if (!ims[5].isZero()) {
            b.append(sjl).append(LispUtils.getResult(ims[5])).append("jo");
        }
        if (!ims[6].isZero()) {
            b.append(skl).append(LispUtils.getResult(ims[6])).append("ko");
        }
        return new LispString(b.toString());
    }

    public String print() {
        return this.getResult();
    }

    public String getResult() {
        return this.toLispString(10).getString();
    }

    public abstract LispOctonion toExact();

    public abstract LispOctonion toInexact();
}

