/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.morilib.lang.Decimal32;
import net.morilib.lang.DoubleUtils;
import net.morilib.lisp.Atom;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispExactReal;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispOctonion;
import net.morilib.lisp.LispQuaternion;
import net.morilib.lisp.LispRational;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.math.algebra.ILispField;
import net.morilib.lisp.sos.LispType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LispNumber
extends Atom
implements ILispField<LispNumber> {
    private static final int I_BIT = 1;
    private static final int L_BIT = 4;

    static String disp(double n) {
        if (n == Double.POSITIVE_INFINITY) {
            return "+inf.0";
        }
        if (n == Double.NEGATIVE_INFINITY) {
            return "-inf.0";
        }
        if (Double.isNaN(n)) {
            return "+nan.0";
        }
        return Double.toString(n);
    }

    private static boolean isAlnum(int r, int radix) {
        if (radix <= 10) {
            return r >= 48 && r <= 57;
        }
        if (radix <= 14) {
            return r >= 48 && r <= 57 || r >= 97 && r <= 100 || r >= 65 && r <= 68;
        }
        return r >= 48 && r <= 57 || r >= 97 && r <= 102 || r >= 65 && r <= 70;
    }

    private static boolean isImaginary(int r) {
        return r == 105 || r == 106 || r == 107 || r == 111;
    }

    private static int getImaginaryNo(int r) {
        switch (r) {
            case 105: {
                return 1;
            }
            case 106: {
                return 2;
            }
            case 107: {
                return 3;
            }
            case 111: {
                return 4;
            }
        }
        throw new RuntimeException();
    }

    private static int read(String s, int p) {
        return p >= s.length() ? -1 : (int)s.charAt(p);
    }

    private static double parseDouble(String str) {
        if ("+inf.0".equals(str)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-inf.0".equals(str)) {
            return Double.NEGATIVE_INFINITY;
        }
        if ("+nan.0".equals(str)) {
            return Double.NaN;
        }
        if ("-nan.0".equals(str)) {
            return Double.NaN;
        }
        return Double.parseDouble(str);
    }

    private static double getValueByDouble(String str) {
        double i;
        String[] ind = str.split("/");
        if (ind.length == 2) {
            double n = LispNumber.parseDouble(ind[0]);
            double d = LispNumber.parseDouble(ind[1]);
            i = n / d;
        } else if (ind.length == 1) {
            i = LispNumber.parseDouble(ind[0]);
        } else {
            throw new RuntimeException("internal error");
        }
        return i;
    }

    private static BigInteger getValueByBigInt(String str, int r) {
        return new BigInteger(str.replaceFirst("^\\+", ""), r);
    }

    private static LispNumber getInteger(String str, int radix, Exact exact) {
        try {
            BigInteger num = LispNumber.getValueByBigInt(str, radix);
            LispInteger li = LispInteger.valueOf(num);
            return Exact.INEXACT.equals((Object)exact) ? li.toInexact() : li;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static LispNumber getRational(String str, int radix, Exact exact) {
        String[] nd = str.split("/");
        try {
            BigInteger num = LispNumber.getValueByBigInt(nd[0], radix);
            BigInteger den = LispNumber.getValueByBigInt(nd[1], radix);
            LispExactReal li = LispRational.newRational(num, den);
            return Exact.INEXACT.equals((Object)exact) ? ((LispNumber)li).toInexact() : li;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static LispNumber getDouble(String str, int radix, Exact ex) {
        int r;
        int n = r = radix < 0 ? 10 : radix;
        if (r != 10) {
            return null;
        }
        double val = LispNumber.parseDouble(str);
        LispDouble atom = new LispDouble(val);
        if (Exact.EXACT.equals((Object)ex)) {
            return atom.toExact();
        }
        return atom;
    }

    private static LispNumber getImaginary(String gtok1, int rx, Exact ex, int imgn) {
        LispReal im;
        String iii = gtok1.replaceFirst("[ijko][ijk]?$", "");
        if (rx != 10) {
            return null;
        }
        if ("+".equals(iii)) {
            im = !Exact.INEXACT.equals((Object)ex) ? LispInteger.ONE : new LispDouble(1.0);
        } else if ("-".equals(iii)) {
            im = !Exact.INEXACT.equals((Object)ex) ? LispInteger.ONE.uminus() : new LispDouble(-1.0);
        } else if (iii.indexOf(47) >= 0) {
            String[] nd = iii.split("/");
            try {
                BigInteger num = LispNumber.getValueByBigInt(nd[0], rx);
                BigInteger den = LispNumber.getValueByBigInt(nd[1], rx);
                if (Exact.INEXACT.equals((Object)ex)) {
                    double numd = num.doubleValue();
                    double dend = den.doubleValue();
                    im = new LispDouble(numd / dend);
                }
                im = LispRational.newRational(num, den);
            }
            catch (NumberFormatException e) {
                return null;
            }
        } else if (!Exact.INEXACT.equals((Object)ex) && iii.matches("^[-+]?[0-9]+$")) {
            iii = iii.replaceFirst("^\\+", "");
            im = LispInteger.valueOf(LispNumber.getValueByBigInt(iii, rx));
        } else {
            im = new LispDouble(LispNumber.getValueByDouble(iii));
        }
        switch (imgn) {
            case 1: {
                return LispComplex.newComplex(LispInteger.ZERO, im);
            }
            case 2: {
                return LispQuaternion.newQuaternion(LispInteger.ZERO, LispInteger.ZERO, im, LispInteger.ZERO);
            }
            case 3: {
                return LispQuaternion.newQuaternion(LispInteger.ZERO, LispInteger.ZERO, LispInteger.ZERO, im);
            }
            case 4: {
                return LispOctonion.newOctonion(LispInteger.ZERO, LispInteger.ZERO, LispInteger.ZERO, LispInteger.ZERO, im, LispInteger.ZERO, LispInteger.ZERO, LispInteger.ZERO);
            }
            case 5: {
                return LispOctonion.newOctonion(LispInteger.ZERO, LispInteger.ZERO, LispInteger.ZERO, LispInteger.ZERO, LispInteger.ZERO, im, LispInteger.ZERO, LispInteger.ZERO);
            }
            case 6: {
                return LispOctonion.newOctonion(LispInteger.ZERO, LispInteger.ZERO, LispInteger.ZERO, LispInteger.ZERO, LispInteger.ZERO, LispInteger.ZERO, im, LispInteger.ZERO);
            }
            case 7: {
                return LispOctonion.newOctonion(LispInteger.ZERO, LispInteger.ZERO, LispInteger.ZERO, LispInteger.ZERO, LispInteger.ZERO, LispInteger.ZERO, LispInteger.ZERO, im);
            }
        }
        throw new RuntimeException("" + imgn);
    }

    private static LispNumber getComplex(String gtok1, String[] bufi, int rx, Exact ex) {
        LispReal re;
        LispReal[] im = new LispReal[8];
        if (rx > 0 && rx != 10) {
            return null;
        }
        if (gtok1.indexOf(47) >= 0) {
            String[] nd = gtok1.split("/");
            try {
                BigInteger num = LispNumber.getValueByBigInt(nd[0], rx);
                BigInteger den = LispNumber.getValueByBigInt(nd[1], rx);
                if (Exact.INEXACT.equals((Object)ex)) {
                    double numd = num.doubleValue();
                    double dend = den.doubleValue();
                    re = new LispDouble(numd / dend);
                }
                re = LispRational.newRational(num, den);
            }
            catch (NumberFormatException e) {
                return null;
            }
        } else {
            re = !Exact.INEXACT.equals((Object)ex) && gtok1.matches("^[-+]?[0-9]+$") ? LispInteger.valueOf(LispNumber.getValueByBigInt(gtok1, rx)) : new LispDouble(LispNumber.getValueByDouble(gtok1));
        }
        int i = 1;
        while (i < 8) {
            if (bufi[i] == null) {
                im[i] = LispInteger.ZERO;
            } else {
                String iii = bufi[i].toString().replaceFirst("[ijko][ijk]?$", "");
                if ("+".equals(iii)) {
                    im[i] = !Exact.INEXACT.equals((Object)ex) ? LispInteger.ONE : new LispDouble(1.0);
                } else if ("-".equals(iii)) {
                    im[i] = !Exact.INEXACT.equals((Object)ex) ? LispInteger.ONE.uminus() : new LispDouble(-1.0);
                } else if (iii.indexOf(47) >= 0) {
                    String[] nd = iii.split("/");
                    try {
                        BigInteger num = LispNumber.getValueByBigInt(nd[0], rx);
                        BigInteger den = LispNumber.getValueByBigInt(nd[1], rx);
                        if (Exact.INEXACT.equals((Object)ex)) {
                            double numd = num.doubleValue();
                            double dend = den.doubleValue();
                            im[i] = new LispDouble(numd / dend);
                        }
                        im[i] = LispRational.newRational(num, den);
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                } else if (!Exact.INEXACT.equals((Object)ex) && iii.matches("^[-+]?[0-9]+$")) {
                    iii = iii.replaceFirst("^\\+", "");
                    im[i] = LispInteger.valueOf(LispNumber.getValueByBigInt(iii, rx));
                } else {
                    im[i] = new LispDouble(LispNumber.getValueByDouble(iii));
                }
            }
            ++i;
        }
        return LispOctonion.newOctonion(re, im[1], im[2], im[3], im[4], im[5], im[6], im[7]);
    }

    private static LispNumber getPolar(String str, int radix, Exact exact) {
        String[] ra = str.split("@");
        if (radix != 10) {
            return null;
        }
        if (Exact.EXACT.equals((Object)exact)) {
            return null;
        }
        double r = LispNumber.getValueByDouble(ra[0]);
        if (r == 0.0) {
            return new LispDouble(0.0);
        }
        double a = LispNumber.getValueByDouble(ra[1]);
        return LispComplex.newComplex(r * Math.cos(a), r * Math.sin(a));
    }

    public static LispNumber parse(String s, int radix) {
        StringBuilder b1 = new StringBuilder();
        StringBuilder b2 = new StringBuilder();
        String[] bi = new String[8];
        State state = State.INIT;
        boolean radix2 = false;
        Exact exact = Exact.DEFAULT;
        boolean signed = false;
        int p = 0;
        int r = LispNumber.read(s, p);
        if (radix < 1 || radix > 16) {
            throw new IllegalArgumentException("wrong radix");
        }
        block49: while (true) {
            switch (state) {
                case INIT: {
                    if (r == 45 || r == 43) {
                        b1.append((char)r);
                        state = State.HEAD_SIGN;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (LispNumber.isAlnum(r, radix)) {
                        b1.append((char)r);
                        state = State.NUMBER;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 46) {
                        b1.append((char)r);
                        state = State.FLOAT_NUMBER;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 35) {
                        state = State.NUMBER_PREFIX;
                        continue block49;
                    }
                    if (r < 0) {
                        return null;
                    }
                    return null;
                }
                case NUMBER_PREFIX: {
                    if (r < 0) {
                        return null;
                    }
                    if (r == 35) {
                        if ((r = LispNumber.read(s, ++p)) == 101 || r == 69) {
                            if (!Exact.DEFAULT.equals((Object)exact)) {
                                return null;
                            }
                            exact = Exact.EXACT;
                            state = State.NUMBER_PREFIX;
                        } else if (r == 105 || r == 73) {
                            if (!Exact.DEFAULT.equals((Object)exact)) {
                                return null;
                            }
                            exact = Exact.INEXACT;
                            state = State.NUMBER_PREFIX;
                        } else if (r == 98 || r == 66) {
                            if (radix2) {
                                return null;
                            }
                            radix = 2;
                            radix2 = true;
                            state = State.NUMBER_PREFIX;
                        } else if (r == 111 || r == 79) {
                            if (radix2) {
                                return null;
                            }
                            radix = 8;
                            radix2 = true;
                            state = State.NUMBER_PREFIX;
                        } else if (r == 100 || r == 68) {
                            if (radix2) {
                                return null;
                            }
                            radix = 10;
                            radix2 = true;
                            state = State.NUMBER_PREFIX;
                        } else if (r == 120 || r == 88) {
                            if (radix2) {
                                return null;
                            }
                            radix = 16;
                            radix2 = true;
                            state = State.NUMBER_PREFIX;
                        }
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 45 || r == 43) {
                        b1.append((char)r);
                        state = State.HEAD_SIGN;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (LispNumber.isAlnum(r, radix)) {
                        b1.append((char)r);
                        state = State.NUMBER;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 46) {
                        b1.append((char)r);
                        state = State.FLOAT_NUMBER;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (LispNumber.isImaginary(r)) {
                        b1.append((char)r);
                        state = State.COMPLEX_I;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    return null;
                }
                case HEAD_SIGN: {
                    signed = true;
                    if (LispNumber.isAlnum(r, radix)) {
                        state = State.NUMBER;
                        continue block49;
                    }
                    if (r == 46) {
                        b1.append((char)r);
                        state = State.FLOAT_NUMBER;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 105) {
                        b1.append((char)r);
                        state = State.INF_I;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (LispNumber.isImaginary(r)) {
                        b1.append((char)r);
                        state = State.COMPLEX_I;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 110) {
                        b1.append((char)r);
                        state = State.NAN_N1;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 64) {
                        b1.append((char)r);
                        state = State.INIT_POLAR;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r < 0) {
                        return null;
                    }
                    return null;
                }
                case NUMBER: {
                    if (LispNumber.isAlnum(r, radix)) {
                        b1.append((char)r);
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 46) {
                        b1.append((char)r);
                        state = State.FLOAT_NUMBER;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 101 || r == 69) {
                        b1.append((char)r);
                        state = State.FLOAT_NUMBER_E;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 47) {
                        b1.append((char)r);
                        state = State.RATIONAL_NUMBER;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 43 || r == 45) {
                        b2.append((char)r);
                        state = State.HEAD_SIGN_COMPLEX;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (LispNumber.isImaginary(r)) {
                        b1.append((char)r);
                        state = State.COMPLEX_I;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 64) {
                        b1.append((char)r);
                        state = State.INIT_POLAR;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r < 0) {
                        return LispNumber.getInteger(b1.toString(), radix, exact);
                    }
                    return null;
                }
                case FLOAT_NUMBER: {
                    if (LispNumber.isAlnum(r, radix)) {
                        state = State.FLOAT_NUMBER_D;
                        continue block49;
                    }
                    if (r < 0) {
                        return null;
                    }
                    return null;
                }
                case FLOAT_NUMBER_D: {
                    if (LispNumber.isAlnum(r, radix)) {
                        b1.append((char)r);
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 101 || r == 69) {
                        b1.append((char)r);
                        state = State.FLOAT_NUMBER_E;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 43 || r == 45) {
                        b2.append((char)r);
                        state = State.HEAD_SIGN_COMPLEX;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (LispNumber.isImaginary(r)) {
                        b1.append((char)r);
                        state = State.COMPLEX_I;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 64) {
                        b1.append((char)r);
                        state = State.INIT_POLAR;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r < 0) {
                        return LispNumber.getDouble(b1.toString(), radix, exact);
                    }
                    return null;
                }
                case FLOAT_NUMBER_E: {
                    if (r == 43 || r == 45) {
                        b1.append((char)r);
                        state = State.FLOAT_NUMBER_E_SIGN;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (LispNumber.isAlnum(r, radix)) {
                        state = State.FLOAT_NUMBER_E_D;
                        continue block49;
                    }
                    if (r < 0) {
                        return null;
                    }
                    return null;
                }
                case FLOAT_NUMBER_E_SIGN: {
                    if (LispNumber.isAlnum(r, radix)) {
                        state = State.FLOAT_NUMBER_E_D;
                        continue block49;
                    }
                    if (r < 0) {
                        return null;
                    }
                    return null;
                }
                case FLOAT_NUMBER_E_D: {
                    if (LispNumber.isAlnum(r, radix)) {
                        b1.append((char)r);
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 43 || r == 45) {
                        b2.append((char)r);
                        state = State.HEAD_SIGN_COMPLEX;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (LispNumber.isImaginary(r)) {
                        b1.append((char)r);
                        state = State.COMPLEX_I;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 64) {
                        b1.append((char)r);
                        state = State.INIT_POLAR;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r < 0) {
                        return LispNumber.getDouble(b1.toString(), radix, exact);
                    }
                    return null;
                }
                case RATIONAL_NUMBER: {
                    if (LispNumber.isAlnum(r, radix)) {
                        b1.append((char)r);
                        r = LispNumber.read(s, ++p);
                        state = State.RATIONAL_NUMBER_2;
                        continue block49;
                    }
                    if (r < 0) {
                        return null;
                    }
                    return null;
                }
                case RATIONAL_NUMBER_2: {
                    if (LispNumber.isAlnum(r, radix)) {
                        b1.append((char)r);
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 43 || r == 45) {
                        b2.append((char)r);
                        state = State.HEAD_SIGN_COMPLEX;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (LispNumber.isImaginary(r)) {
                        b1.append((char)r);
                        state = State.COMPLEX_I;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 64) {
                        b1.append((char)r);
                        state = State.INIT_POLAR;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r < 0) {
                        return LispNumber.getRational(b1.toString(), radix, exact);
                    }
                    return null;
                }
                case INIT_POLAR: {
                    if (r == 45 || r == 43) {
                        b1.append((char)r);
                        state = State.HEAD_SIGN_POLAR;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (LispNumber.isAlnum(r, radix)) {
                        b1.append((char)r);
                        state = State.NUMBER_POLAR;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 46) {
                        b1.append((char)r);
                        state = State.FLOAT_NUMBER_POLAR;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r < 0) {
                        return null;
                    }
                    return null;
                }
                case HEAD_SIGN_POLAR: {
                    if (LispNumber.isAlnum(r, radix)) {
                        state = State.NUMBER_POLAR;
                        continue block49;
                    }
                    if (r == 46) {
                        b1.append((char)r);
                        state = State.FLOAT_NUMBER_POLAR;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r < 0) {
                        return null;
                    }
                    return null;
                }
                case NUMBER_POLAR: {
                    if (LispNumber.isAlnum(r, radix)) {
                        b1.append((char)r);
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 46) {
                        b1.append((char)r);
                        state = State.FLOAT_NUMBER_POLAR;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 101 || r == 69) {
                        b1.append((char)r);
                        state = State.FLOAT_NUMBER_E_POLAR;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 47) {
                        b1.append((char)r);
                        state = State.RATIONAL_NUMBER_POLAR;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r < 0) {
                        return LispNumber.getPolar(b1.toString(), radix, exact);
                    }
                    return null;
                }
                case FLOAT_NUMBER_POLAR: {
                    if (LispNumber.isAlnum(r, radix)) {
                        state = State.FLOAT_NUMBER_D_POLAR;
                        continue block49;
                    }
                    if (r < 0) {
                        return null;
                    }
                    return null;
                }
                case FLOAT_NUMBER_D_POLAR: {
                    if (LispNumber.isAlnum(r, radix)) {
                        b1.append((char)r);
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 101 || r == 69) {
                        b1.append((char)r);
                        state = State.FLOAT_NUMBER_E_POLAR;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r < 0) {
                        return LispNumber.getPolar(b1.toString(), radix, exact);
                    }
                    return null;
                }
                case FLOAT_NUMBER_E_POLAR: {
                    if (r == 43 || r == 45) {
                        b1.append((char)r);
                        state = State.FLOAT_NUMBER_E_SIGN_POLAR;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (LispNumber.isAlnum(r, radix)) {
                        state = State.FLOAT_NUMBER_E_D_POLAR;
                        continue block49;
                    }
                    if (r < 0) {
                        return null;
                    }
                    return null;
                }
                case FLOAT_NUMBER_E_SIGN_POLAR: {
                    if (LispNumber.isAlnum(r, radix)) {
                        state = State.FLOAT_NUMBER_E_D_POLAR;
                        continue block49;
                    }
                    if (r < 0) {
                        return null;
                    }
                    return null;
                }
                case FLOAT_NUMBER_E_D_POLAR: {
                    if (LispNumber.isAlnum(r, radix)) {
                        b1.append((char)r);
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r < 0) {
                        return LispNumber.getPolar(b1.toString(), radix, exact);
                    }
                    return null;
                }
                case RATIONAL_NUMBER_POLAR: {
                    if (LispNumber.isAlnum(r, radix)) {
                        b1.append((char)r);
                        r = LispNumber.read(s, ++p);
                        state = State.RATIONAL_NUMBER_2_POLAR;
                        continue block49;
                    }
                    if (r < 0) {
                        return null;
                    }
                    return null;
                }
                case RATIONAL_NUMBER_2_POLAR: {
                    if (LispNumber.isAlnum(r, radix)) {
                        b1.append((char)r);
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r < 0) {
                        return LispNumber.getPolar(b1.toString(), radix, exact);
                    }
                    return null;
                }
                case INF_I: {
                    int imgn = 1;
                    if (r == 111) {
                        imgn |= 4;
                        r = LispNumber.read(s, ++p);
                    }
                    if (r < 0) {
                        return LispNumber.getImaginary(b1.toString(), radix, exact, imgn);
                    }
                    if (r == 110) {
                        b1.append((char)r);
                        state = State.INF_N;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 43 || r == 45) {
                        bi[1] = b1.toString();
                        b1 = new StringBuilder("0");
                        b2.append((char)r);
                        state = State.HEAD_SIGN_COMPLEX;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    return null;
                }
                case INF_N: {
                    if (r == 102) {
                        b1.append((char)r);
                        state = State.INF_F;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    return null;
                }
                case INF_F: {
                    if (r == 46) {
                        b1.append((char)r);
                        state = State.INF_DOT;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    return null;
                }
                case INF_DOT: {
                    if (r == 48) {
                        b1.append((char)r);
                        state = State.INF_0;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    return null;
                }
                case INF_0: {
                    if (r < 0) {
                        String s1 = b1.toString();
                        if (s1.charAt(0) == '+') {
                            return LispDouble.POSITIVE_INFINITY;
                        }
                        return LispDouble.NEGATIVE_INFINITY;
                    }
                    if (r == 43 || r == 45) {
                        b2.append((char)r);
                        state = State.HEAD_SIGN_COMPLEX;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (LispNumber.isImaginary(r)) {
                        b1.append((char)r);
                        state = State.COMPLEX_I;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 64) {
                        b1.append((char)r);
                        state = State.INIT_POLAR;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    return null;
                }
                case NAN_N1: {
                    if (r == 97) {
                        b1.append((char)r);
                        state = State.NAN_A;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    return null;
                }
                case NAN_A: {
                    if (r == 110) {
                        b1.append((char)r);
                        state = State.NAN_N2;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    return null;
                }
                case NAN_N2: {
                    if (r == 46) {
                        b1.append((char)r);
                        state = State.NAN_DOT;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    return null;
                }
                case NAN_DOT: {
                    if (r == 48) {
                        b1.append((char)r);
                        state = State.NAN_0;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    return null;
                }
                case NAN_0: {
                    if (r < 0) {
                        return LispDouble.NaN;
                    }
                    return null;
                }
                case COMPLEX_I: {
                    char r0 = b1.charAt(b1.length() - 1);
                    int imgn = LispNumber.getImaginaryNo(r0);
                    if (r == 111) {
                        if (r0 == 'o') {
                            return null;
                        }
                        imgn |= 4;
                        r = LispNumber.read(s, ++p);
                    }
                    bi[imgn] = b1.toString();
                    if (r < 0) {
                        if (signed) {
                            return LispNumber.getImaginary(b1.toString(), radix, exact, imgn);
                        }
                        return null;
                    }
                    if (r == 43 || r == 45) {
                        bi[imgn] = b1.toString();
                        b1 = new StringBuilder("0");
                        b2.append((char)r);
                        state = State.HEAD_SIGN_COMPLEX;
                        r = LispNumber.read(s, ++p);
                    } else {
                        return null;
                    }
                }
                case HEAD_SIGN_COMPLEX: {
                    if (LispNumber.isAlnum(r, radix)) {
                        state = State.NUMBER_COMPLEX;
                        continue block49;
                    }
                    if (r == 46) {
                        b2.append((char)r);
                        state = State.FLOAT_NUMBER_COMPLEX;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 105) {
                        b2.append((char)r);
                        state = State.INF_I_COMPLEX;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (LispNumber.isImaginary(r)) {
                        b2.append((char)r);
                        state = State.COMPLEX_I2;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r < 0) {
                        return null;
                    }
                    return null;
                }
                case NUMBER_COMPLEX: {
                    if (LispNumber.isAlnum(r, radix)) {
                        b2.append((char)r);
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 46) {
                        b2.append((char)r);
                        state = State.FLOAT_NUMBER_COMPLEX;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 101 || r == 69) {
                        b2.append((char)r);
                        state = State.FLOAT_NUMBER_E_COMPLEX;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 47) {
                        b2.append((char)r);
                        state = State.RATIONAL_NUMBER_COMPLEX;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (LispNumber.isImaginary(r)) {
                        b2.append((char)r);
                        state = State.COMPLEX_I2;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r < 0) {
                        return null;
                    }
                    return null;
                }
                case FLOAT_NUMBER_COMPLEX: {
                    if (LispNumber.isAlnum(r, radix)) {
                        state = State.FLOAT_NUMBER_D_COMPLEX;
                        continue block49;
                    }
                    if (r < 0) {
                        return null;
                    }
                    return null;
                }
                case FLOAT_NUMBER_D_COMPLEX: {
                    if (LispNumber.isAlnum(r, radix)) {
                        b2.append((char)r);
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 101 || r == 69) {
                        b2.append((char)r);
                        state = State.FLOAT_NUMBER_E_COMPLEX;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (LispNumber.isImaginary(r)) {
                        b2.append((char)r);
                        state = State.COMPLEX_I2;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r < 0) {
                        return null;
                    }
                    return null;
                }
                case FLOAT_NUMBER_E_COMPLEX: {
                    if (r == 43 || r == 45) {
                        b2.append((char)r);
                        state = State.FLOAT_NUMBER_E_SIGN_COMPLEX;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (LispNumber.isAlnum(r, radix)) {
                        state = State.FLOAT_NUMBER_E_D_COMPLEX;
                        continue block49;
                    }
                    if (r < 0) {
                        return null;
                    }
                    return null;
                }
                case FLOAT_NUMBER_E_SIGN_COMPLEX: {
                    if (LispNumber.isAlnum(r, radix)) {
                        state = State.FLOAT_NUMBER_E_D_COMPLEX;
                        continue block49;
                    }
                    if (r < 0) {
                        return null;
                    }
                    return null;
                }
                case FLOAT_NUMBER_E_D_COMPLEX: {
                    if (LispNumber.isAlnum(r, radix)) {
                        b2.append((char)r);
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (LispNumber.isImaginary(r)) {
                        b2.append((char)r);
                        state = State.COMPLEX_I2;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r < 0) {
                        return null;
                    }
                    return null;
                }
                case RATIONAL_NUMBER_COMPLEX: {
                    if (LispNumber.isAlnum(r, radix)) {
                        b2.append((char)r);
                        r = LispNumber.read(s, ++p);
                        state = State.RATIONAL_NUMBER_2_COMPLEX;
                        continue block49;
                    }
                    if (r < 0) {
                        return null;
                    }
                    return null;
                }
                case RATIONAL_NUMBER_2_COMPLEX: {
                    if (LispNumber.isAlnum(r, radix)) {
                        b2.append((char)r);
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (LispNumber.isImaginary(r)) {
                        b2.append((char)r);
                        state = State.COMPLEX_I2;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r < 0) {
                        return null;
                    }
                    return null;
                }
                case INF_I_COMPLEX: {
                    int imgn = 1;
                    if (r == 111) {
                        imgn |= 4;
                        r = LispNumber.read(s, ++p);
                    }
                    if (bi[imgn] != null) {
                        return null;
                    }
                    if (r < 0) {
                        bi[imgn] = b2.toString();
                        return LispNumber.getComplex(b1.toString(), bi, radix, exact);
                    }
                    if (r == 110) {
                        b2.append((char)r);
                        state = State.INF_N_COMPLEX;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    if (r == 43 || r == 45) {
                        bi[imgn] = b2.toString();
                        b2 = new StringBuilder();
                        b2.append((char)r);
                        state = State.HEAD_SIGN_COMPLEX;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    return null;
                }
                case INF_N_COMPLEX: {
                    if (r == 102) {
                        b2.append((char)r);
                        state = State.INF_F_COMPLEX;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    return null;
                }
                case INF_F_COMPLEX: {
                    if (r == 46) {
                        b2.append((char)r);
                        state = State.INF_DOT_COMPLEX;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    return null;
                }
                case INF_DOT_COMPLEX: {
                    if (r == 48) {
                        b2.append((char)r);
                        state = State.INF_0_COMPLEX;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    return null;
                }
                case INF_0_COMPLEX: {
                    if (LispNumber.isImaginary(r)) {
                        b2.append((char)r);
                        state = State.COMPLEX_I2;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    return null;
                }
                case COMPLEX_I2: {
                    char r0 = b2.charAt(b2.length() - 1);
                    int imgn = LispNumber.getImaginaryNo(r0);
                    if (r == 111) {
                        if (r0 == 'o') {
                            return null;
                        }
                        imgn |= 4;
                        r = LispNumber.read(s, ++p);
                    }
                    if (bi[imgn] != null) {
                        return null;
                    }
                    bi[imgn] = b2.toString();
                    if (r < 0) {
                        return LispNumber.getComplex(b1.toString(), bi, radix, exact);
                    }
                    if (r == 43 || r == 45) {
                        b2 = new StringBuilder();
                        b2.append((char)r);
                        state = State.HEAD_SIGN_COMPLEX;
                        r = LispNumber.read(s, ++p);
                        continue block49;
                    }
                    return null;
                }
            }
        }
    }

    @Override
    public abstract LispNumber add(LispNumber var1);

    @Override
    public abstract LispNumber sub(LispNumber var1);

    @Override
    public abstract LispNumber mul(LispNumber var1);

    @Override
    public abstract LispNumber div(LispNumber var1);

    @Override
    public abstract LispNumber uminus();

    public abstract boolean isEqualTo(LispNumber var1);

    public abstract boolean isInteger();

    public abstract boolean isRational();

    public abstract boolean isReal();

    public abstract boolean isExact();

    public abstract LispNumber toExact();

    public abstract LispNumber toInexact();

    public abstract LispString toLispString(int var1);

    public abstract LispReal norm();

    public abstract LispNumber conjugate();

    public abstract boolean isNaN();

    public abstract boolean isOne();

    @Override
    public abstract int getInt();

    @Override
    public abstract long getLong();

    @Override
    public abstract BigInteger getBigInteger();

    @Override
    public abstract BigDecimal getBigDecimal();

    @Override
    public abstract double getRealDouble();

    @Override
    public float getRealFloat() {
        return (float)this.getRealDouble();
    }

    @Override
    public short getRealHalf() {
        return DoubleUtils.toHalf(this.getRealDouble());
    }

    @Override
    public abstract long getRealDecimal64();

    @Override
    public int getRealDecimal32() {
        return Decimal32.decimal64To32(this.getRealDecimal64());
    }

    public abstract BigInteger getNumerator();

    public abstract BigInteger getDenominator();

    public abstract LispReal[] getImags();

    public abstract double[] getImagsDouble();

    public abstract LispReal[] getImagsAsQuaternion();

    public abstract double[] getImagsDoubleAsQuaternion();

    public abstract LispReal[] getImagsAsOctonion();

    public abstract double[] getImagsDoubleAsOctonion();

    public LispNumber pow(int n) {
        LispNumber r = LispInteger.ONE;
        if (n >= 0) {
            int i = 0;
            while (i < n) {
                r = ((LispNumber)r).mul(this);
                ++i;
            }
        } else {
            int i = 0;
            while (i < -n) {
                r = ((LispNumber)r).div(this);
                ++i;
            }
        }
        return r;
    }

    @Override
    public LispNumber inv() {
        return LispInteger.ONE.div(this);
    }

    public int getExactSmallInt() {
        throw new NumberFormatException();
    }

    @Override
    public LispString toLispString() {
        return this.toLispString(10);
    }

    public boolean isZero() {
        return this.isEqualTo(LispInteger.ZERO);
    }

    @Override
    public LispType getType() {
        return LispType.NUMBER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Exact {
        DEFAULT,
        EXACT,
        INEXACT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INIT,
        NUMBER_PREFIX,
        HEAD_SIGN,
        NUMBER,
        FLOAT_NUMBER,
        FLOAT_NUMBER_D,
        FLOAT_NUMBER_E,
        FLOAT_NUMBER_E_SIGN,
        FLOAT_NUMBER_E_D,
        RATIONAL_NUMBER,
        RATIONAL_NUMBER_2,
        INF_I,
        INF_N,
        INF_F,
        INF_DOT,
        INF_0,
        NAN_N1,
        NAN_A,
        NAN_N2,
        NAN_DOT,
        NAN_0,
        COMPLEX_I,
        INIT_POLAR,
        HEAD_SIGN_POLAR,
        NUMBER_POLAR,
        FLOAT_NUMBER_POLAR,
        FLOAT_NUMBER_D_POLAR,
        FLOAT_NUMBER_E_POLAR,
        FLOAT_NUMBER_E_SIGN_POLAR,
        FLOAT_NUMBER_E_D_POLAR,
        RATIONAL_NUMBER_POLAR,
        RATIONAL_NUMBER_2_POLAR,
        HEAD_SIGN_COMPLEX,
        NUMBER_COMPLEX,
        FLOAT_NUMBER_COMPLEX,
        FLOAT_NUMBER_D_COMPLEX,
        FLOAT_NUMBER_E_COMPLEX,
        FLOAT_NUMBER_E_SIGN_COMPLEX,
        FLOAT_NUMBER_E_D_COMPLEX,
        RATIONAL_NUMBER_COMPLEX,
        RATIONAL_NUMBER_2_COMPLEX,
        INF_I_COMPLEX,
        INF_N_COMPLEX,
        INF_F_COMPLEX,
        INF_DOT_COMPLEX,
        INF_0_COMPLEX,
        COMPLEX_I2;

    }
}

