/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispMath;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispOctonion;
import net.morilib.lisp.LispQuaternion;
import net.morilib.lisp.LispReal;

public class LispComplexImpl
extends LispComplex {
    private LispReal real;
    private LispReal imag;

    LispComplexImpl(LispReal r, LispReal i) {
        this.real = r;
        this.imag = i;
    }

    public double getRealDouble() {
        return this.real.getRealDouble();
    }

    public LispReal getReal() {
        return this.real;
    }

    public double getImagDouble() {
        return this.imag.getRealDouble();
    }

    public LispReal getImag() {
        return this.imag;
    }

    public boolean isEqualTo(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return this.real.isEqualTo(c.getReal()) && this.imag.isEqualTo(c.getImag());
        }
        if (x instanceof LispReal) {
            return false;
        }
        return super.isEqualTo(x);
    }

    public LispComplex toExact() {
        return LispComplexImpl.newComplex(this.real.toExact(), this.imag.toExact());
    }

    public LispComplex toInexact() {
        return LispComplexImpl.newComplex(this.real.toInexact(), this.imag.toInexact());
    }

    public LispComplex conjugate() {
        return new LispComplexImpl(this.real, this.imag.uminus());
    }

    public LispNumber add(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex(this.real.add(c.getReal()), this.imag.add(c.getImag()));
        }
        if (x instanceof LispReal) {
            return LispComplexImpl.newComplex(this.real.add(x.getReal()), this.imag);
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.add(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.add(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    public LispNumber sub(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex(this.real.subtract(c.getReal()), this.imag.subtract(c.getImag()));
        }
        if (x instanceof LispReal) {
            return LispComplexImpl.newComplex(this.real.subtract(x.getReal()), this.imag);
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.sub(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.sub(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    public LispNumber mul(LispNumber x) {
        if (x instanceof LispComplex) {
            LispReal xr = ((LispComplex)x).getReal();
            LispReal xi = ((LispComplex)x).getImag();
            if (xr.signum() == 0) {
                return LispComplexImpl.newComplex(this.imag.uminus().multiply(xi), this.real.multiply(xi));
            }
            return LispComplexImpl.newComplex(this.real.multiply(xr).subtract(this.imag.multiply(xi)), this.imag.multiply(xr).add(this.real.multiply(xi)));
        }
        if (x instanceof LispReal) {
            LispReal r = x.getReal();
            return LispComplexImpl.newComplex(this.real.multiply(r), this.imag.multiply(r));
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.mul(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.mul(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    public LispNumber div(LispNumber x) {
        if (x instanceof LispComplex) {
            LispReal xr = ((LispComplex)x).getReal();
            LispReal xi = ((LispComplex)x).getImag();
            if (xr.signum() == 0) {
                return LispComplexImpl.newComplex(this.imag.divide(xi), this.real.uminus().divide(xi));
            }
            LispReal nr = xr.multiply(xr).add(xi.multiply(xi));
            LispReal x1 = this.real.multiply(xr).add(this.imag.multiply(xi));
            LispReal x2 = this.imag.multiply(xr).subtract(this.real.multiply(xi));
            return LispComplexImpl.newComplex(x1.divide(nr), x2.divide(nr));
        }
        if (x instanceof LispReal) {
            LispReal r = x.getReal();
            return LispComplexImpl.newComplex(this.real.divide(r), this.imag.divide(r));
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.div(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.div(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    public LispComplexImpl uminus() {
        return new LispComplexImpl(this.real.uminus(), this.imag.uminus());
    }

    public boolean isExact() {
        return this.real.isExact();
    }

    public LispReal norm() {
        return (LispReal)LispMath.sqrt((LispReal)this.real.mul(this.real).add(this.imag.mul(this.imag)));
    }

    public boolean equals(Object x) {
        if (x instanceof LispComplexImpl) {
            LispComplexImpl c = (LispComplexImpl)x;
            return this.real.equals(c.real) && this.imag.equals(c.imag);
        }
        return false;
    }

    public int hashCode() {
        int l = 17;
        l = 37 * (l + this.real.hashCode());
        l = 37 * (l + this.imag.hashCode());
        return l;
    }
}

