/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.beans.IntrospectionException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.JavaNull;
import net.morilib.lisp.JavaObjective;
import net.morilib.lisp.JavaUtils;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.ParameterNotFoundException;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.sos.ISlotDatum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaInstance
extends Datum
implements JavaObjective,
ISlotDatum {
    private Object instance;
    private static final String[] JAVAPATH = new String[]{"net.morilib.lisp.swing"};

    private static Class<?> applyRule1(Class<?> cl) {
        String n = cl.getName();
        String[] stringArray = JAVAPATH;
        int n2 = JAVAPATH.length;
        int n3 = 0;
        while (n3 < n2) {
            String p = stringArray[n3];
            try {
                return Class.forName(String.valueOf(p) + n.replaceFirst("^(.*)\\.J", ".Lisp"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                ++n3;
            }
        }
        return null;
    }

    public static Datum newInstance(Object o) {
        Class<?> cl;
        Class<?> clazz = cl = o == null ? null : o.getClass();
        if (o == null || o == JavaNull.JAVA_NULL) {
            return Nil.NIL;
        }
        if (o instanceof Datum) {
            return (Datum)o;
        }
        if (o instanceof Integer) {
            return LispInteger.valueOf((Integer)o);
        }
        if (o instanceof Long) {
            return LispInteger.valueOf((Long)o);
        }
        if (o instanceof BigInteger) {
            return LispInteger.valueOf((BigInteger)o);
        }
        if (o instanceof BigDecimal) {
            return LispUtils.bigDecimalToRational((BigDecimal)o);
        }
        if (o instanceof Float) {
            return new LispDouble(((Float)o).doubleValue());
        }
        if (o instanceof Double) {
            return new LispDouble((Double)o);
        }
        if (o instanceof String) {
            return new LispString((String)o);
        }
        if (o instanceof Character) {
            return new LispCharacter(((Character)o).charValue());
        }
        if (o instanceof Boolean) {
            return LispBoolean.getInstance((Boolean)o);
        }
        if (cl.isArray()) {
            ConsListBuilder bld = new ConsListBuilder();
            int len = Array.getLength(o);
            int i = 0;
            while (i < len) {
                bld.append(JavaInstance.newInstance(Array.get(o, i)));
                ++i;
            }
            return bld.get();
        }
        Class<?> iv = JavaInstance.applyRule1(cl);
        if (iv != null) {
            try {
                return (Datum)iv.getConstructor(cl).newInstance(o);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return new JavaInstance(o);
    }

    JavaInstance(Object instance) {
        this.instance = instance;
    }

    Object getJavaInstance() {
        return this.instance;
    }

    Datum invokeMethod(String name, List<Datum> lst) throws ParameterNotFoundException {
        Object res = JavaUtils.invokeMethod(this.instance.getClass(), this.instance, name, lst);
        return LispUtils.toDatum(res);
    }

    Datum invokeGetter(String name) throws IntrospectionException, ParameterNotFoundException {
        Object res = JavaUtils.invokeGetter(this.instance, name);
        return LispUtils.toDatum(res);
    }

    void invokeSetter(String name, Datum d) throws IntrospectionException, ParameterNotFoundException {
        JavaUtils.invokeSetter(this.instance, name, d);
    }

    Datum invokeGetter(String name, int index) throws IntrospectionException, ParameterNotFoundException {
        Object res = JavaUtils.invokeGetter(this.instance, name, index);
        return LispUtils.toDatum(res);
    }

    void invokeSetter(String name, int index, Datum d) throws IntrospectionException, ParameterNotFoundException {
        JavaUtils.invokeSetter(this.instance, name, index, d);
    }

    @Override
    public Object toObject() {
        return this.instance;
    }

    @Override
    public Datum getSlot(Symbol sym) {
        try {
            return JavaInstance.newInstance(JavaUtils.invokeGetter(this.instance, sym.getName()));
        }
        catch (IntrospectionException e) {
            return null;
        }
        catch (ParameterNotFoundException e) {
            return null;
        }
    }

    @Override
    public boolean setSlot(Symbol sym, Datum val, LispMessage mesg) {
        try {
            JavaUtils.invokeSetter(this.instance, sym.getName(), val);
            return true;
        }
        catch (IntrospectionException e) {
            return false;
        }
        catch (ParameterNotFoundException e) {
            return false;
        }
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        Object o = this.getJavaInstance();
        buf.append("#<java-instance ");
        buf.append(o.getClass().getName());
        buf.append(">");
    }
}

