/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.Map;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.ReadOnlyException;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.r6rs.LibraryID;
import net.morilib.lisp.r6rs.LibraryIDException;
import net.morilib.lisp.r6rs.SymbolEnv;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.TernaryArgs;

public class EnvironmentObject
extends Datum {
    private Environment environment;
    private boolean inherit = false;

    private EnvironmentObject(Environment environment, boolean inherit) {
        if (environment == null) {
            throw new NullPointerException();
        }
        this.environment = environment;
        this.inherit = inherit;
    }

    static EnvironmentObject newNullEnv(int ver) {
        return new EnvironmentObject(Scheme.newNullEnv(ver), false);
    }

    static EnvironmentObject newRnRSEnv(int ver) {
        return new EnvironmentObject(Scheme.newRnRSEnv(ver), false);
    }

    static EnvironmentObject newInteractionEnv(Environment e) {
        return new EnvironmentObject(e, true);
    }

    Environment getEnvironment() {
        return this.environment;
    }

    boolean isInherit() {
        return this.inherit;
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<environment>");
    }

    /* synthetic */ EnvironmentObject(Environment environment, boolean bl, EnvironmentObject environmentObject) {
        this(environment, bl);
    }

    public static class BindEnvironmentS
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            Map<Datum, Datum> maps = LispUtils.assocToMap(c2a);
            if (maps == null) {
                throw mesg.getError("err.require.assoc", c2a);
            }
            if (!(c1a instanceof EnvironmentObject)) {
                throw mesg.getError("err.environment", c1a);
            }
            Environment eo = ((EnvironmentObject)c1a).getEnvironment();
            for (Map.Entry<Datum, Datum> e : maps.entrySet()) {
                if (!(e.getKey() instanceof Symbol)) {
                    throw mesg.getError("err.require.symbol", e.getKey());
                }
                Symbol s = (Symbol)e.getKey();
                eo.bindDatumReadOnly(s, e.getValue());
            }
            return c1a;
        }
    }

    public static class FindEnvironment
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof EnvironmentObject)) {
                throw mesg.getError("err.environment", c1a);
            }
            if (!(c2a instanceof Symbol)) {
                throw mesg.getError("err.require.symbol", c2a);
            }
            Datum d = ((EnvironmentObject)c1a).environment.findDatum((Symbol)c2a);
            return d == null ? Undef.UNDEF : d;
        }
    }

    public static class R6RSEnvironment
    extends Subr {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            Map<Symbol, SymbolEnv> mp;
            Environment env2 = new Environment();
            try {
                mp = LibraryID.compileImport(body);
            }
            catch (LibraryIDException e) {
                throw e.toLispException(mesg);
            }
            for (Map.Entry<Symbol, SymbolEnv> e : mp.entrySet()) {
                Environment env3 = e.getValue().getEnvironment();
                env2.bindDatumReadOnly(e.getValue().getSymbol(), env3.getDatum(e.getKey()));
            }
            return new EnvironmentObject(env2, false, null);
        }
    }

    public static class SetEnvironmentS
    extends TernaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof EnvironmentObject)) {
                throw mesg.getError("err.environment", c1a);
            }
            if (!(c2a instanceof Symbol)) {
                throw mesg.getError("err.require.symbol", c2a);
            }
            Environment e2 = ((EnvironmentObject)c1a).environment;
            try {
                if (!e2.setDatum((Symbol)c2a, c3a)) {
                    e2.bindDatum((Symbol)c2a, c3a);
                }
            }
            catch (ReadOnlyException e) {
                return LispBoolean.FALSE;
            }
            return LispBoolean.TRUE;
        }
    }
}

