/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.DatumPredicate;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.SExpression;
import net.morilib.lisp.SExpressionDatum;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.collection.ImmutableException;
import net.morilib.lisp.collection.LispBag;
import net.morilib.lisp.collection.LispCollection;
import net.morilib.lisp.collection.LispCollections;
import net.morilib.lisp.collection.LispDictionary;
import net.morilib.lisp.collection.LispMap;
import net.morilib.lisp.collection.LispSequence;
import net.morilib.lisp.sos.LispType;
import net.morilib.lisp.subr.IsEqual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Cons
extends SExpressionDatum {
    private Datum car;
    private Datum cdr;

    public Cons() {
        this.car = Nil.NIL;
        this.cdr = Nil.NIL;
    }

    public Cons(Datum car, Datum cdr) {
        if (car == null) {
            throw new NullPointerException("car is null");
        }
        if (cdr == null) {
            throw new NullPointerException("cdr is null");
        }
        this.car = car;
        this.cdr = cdr;
    }

    public Datum getCar() {
        return this.car;
    }

    void setCar(Datum car) {
        this.car = car;
    }

    public Datum getCdr() {
        return this.cdr;
    }

    void setCdr(Datum cdr) {
        this.cdr = cdr;
    }

    @Override
    public boolean isTypeList() {
        return true;
    }

    @Override
    public boolean isDottedList() {
        return !this.getDottedDatum().isNil();
    }

    @Override
    public List<Datum> getList() {
        ArrayList<Datum> res = new ArrayList<Datum>();
        Datum p = this.cdr;
        res.add(this.car);
        while (p instanceof Cons) {
            Cons p2 = (Cons)p;
            res.add(p2.car);
            p = p2.cdr;
        }
        return Collections.unmodifiableList(res);
    }

    @Override
    public Datum getDottedDatum() {
        Datum p = this.cdr;
        while (p instanceof Cons) {
            p = ((Cons)p).cdr;
        }
        return p;
    }

    @Override
    public String toString() {
        return LispUtils.getResult(this);
    }

    @Override
    public LispType getType() {
        return LispType.PAIR;
    }

    public Datum copy(DatumPredicate p) {
        Datum q = this;
        Cons r = null;
        Cons r0 = null;
        HashMap<Cons, Datum> h = new HashMap<Cons, Datum>();
        while (q instanceof Cons) {
            Cons c = q;
            if (p.test(c.car)) {
                if (r == null) {
                    r0 = r = new Cons();
                } else {
                    r.cdr = new Cons();
                    r = (Cons)r.cdr;
                }
                r.car = c.car;
            }
            h.put(c, c.cdr);
            if (h.containsKey(c.cdr)) {
                if (r == null) {
                    return Nil.NIL;
                }
                r.cdr = (Datum)h.get(c.cdr);
                return r0;
            }
            q = c.cdr;
        }
        r.cdr = q;
        return r0 == null ? Nil.NIL : r0;
    }

    public Cons copy() {
        Cons r;
        Datum d = this;
        Cons r0 = r = new Cons();
        HashMap<Cons, Datum> h = new HashMap<Cons, Datum>();
        HashMap<Cons, Datum> g = new HashMap<Cons, Datum>();
        while (d instanceof Cons) {
            Cons c = d;
            r.car = c.car;
            if (h.containsKey(c.cdr)) {
                r.cdr = (Datum)g.get(c.cdr);
                return r0;
            }
            h.put(c, c.cdr);
            if (c.cdr instanceof Cons) {
                r.cdr = new Cons();
                g.put(c, r.cdr);
                r = (Cons)r.cdr;
            } else {
                r.cdr = c.cdr;
            }
            d = c.cdr;
        }
        return r0;
    }

    public Datum delete(DatumPredicate p) {
        Datum d = this;
        Cons r = null;
        Cons r0 = null;
        HashMap<Cons, Datum> h = new HashMap<Cons, Datum>();
        while (d instanceof Cons) {
            Cons c = d;
            if (p.test(c.car)) {
                if (r == null) {
                    r0 = c;
                }
                r = c;
                r.car = c.car;
            } else if (r != null) {
                r.cdr = c.cdr;
            }
            h.put(c, c.cdr);
            if (h.containsKey(c.cdr)) {
                if (r == null) {
                    return Nil.NIL;
                }
                r.cdr = (Datum)h.get(c.cdr);
                return r0;
            }
            d = c.cdr;
        }
        return r0 == null ? Nil.NIL : r0;
    }

    private Cons _get(int index) {
        Cons r = this;
        if (index < 0) {
            throw new IndexOutOfBoundsException("" + index);
        }
        int i = 0;
        while (i < index) {
            if (!(r.cdr instanceof Cons)) {
                throw new IndexOutOfBoundsException("" + i);
            }
            r = (Cons)r.cdr;
            ++i;
        }
        return r;
    }

    @Override
    public Datum get(int index) {
        return this._get((int)index).car;
    }

    @Override
    public Datum copySet(int index, Datum d) {
        return this.copy().set(index, d);
    }

    @Override
    public Datum set(int index, Datum d) {
        this._get((int)index).car = d;
        return this;
    }

    @Override
    public Datum replace(LispSequence src, int srcPos, int destPos, int len) {
        return this.copy().arraycopy(src, srcPos, destPos, len);
    }

    @Override
    public Datum arraycopy(LispSequence src, int srcPos, int destPos, int len) {
        Datum d1 = this._get(destPos);
        int i = srcPos;
        while (i < srcPos + len) {
            if (!(d1 instanceof Cons)) {
                throw new IndexOutOfBoundsException("" + i);
            }
            d1.car = src.get(i);
            d1 = d1.cdr;
            ++i;
        }
        return this;
    }

    @Override
    public Datum copy(int b, int e) {
        Cons r = new Cons();
        Datum c = this._get(b);
        if (b == e) {
            return Nil.NIL;
        }
        Cons r0 = r;
        int i = b;
        while (i < e) {
            if (c instanceof Cons) {
                r.car = c.car;
                if (i < e - 1 && c.cdr instanceof Cons) {
                    r.cdr = new Cons();
                    r = (Cons)r.cdr;
                }
            } else {
                throw new IndexOutOfBoundsException("" + i);
            }
            c = c.cdr;
            ++i;
        }
        return r0;
    }

    @Override
    public Procedure equivalence() {
        return new IsEqual();
    }

    @Override
    public Datum copyAdd(Datum d) {
        Cons r = new Cons();
        r.car = d;
        r.cdr = this.copy();
        return r;
    }

    @Override
    public Datum add(Datum d) {
        return this.copyAdd(d);
    }

    @Override
    public Datum copyDelete(Datum d) {
        final Datum x = d;
        final boolean[] b = new boolean[]{false};
        return this.copy(new DatumPredicate(){

            public boolean test(Datum d) {
                return b[0] || !(b[0] = LispUtils.equals(x, d));
            }
        });
    }

    @Override
    public Datum delete(Datum d) {
        final Datum x = d;
        final boolean[] b = new boolean[]{false};
        return this.delete(new DatumPredicate(){

            public boolean test(Datum d) {
                return b[0] || !(b[0] = LispUtils.equals(x, d));
            }
        });
    }

    @Override
    public Datum copyDeleteAll(Datum d) {
        final Datum x = d;
        return this.copy(new DatumPredicate(){

            public boolean test(Datum d) {
                return !LispUtils.equals(x, d);
            }
        });
    }

    @Override
    public Datum deleteAll(Datum d) {
        final Datum x = d;
        return this.delete(new DatumPredicate(){

            public boolean test(Datum d) {
                return !LispUtils.equals(x, d);
            }
        });
    }

    @Override
    public Datum copyAddFrom(LispBag d) {
        if (d.size() == 0) {
            return this.copy();
        }
        return LispUtils.copy(d.iterator(), this.copy());
    }

    @Override
    public Datum addFrom(LispBag d) throws ImmutableException {
        if (d.size() == 0) {
            return this;
        }
        return LispUtils.nconc(this, LispUtils.toCons(d));
    }

    @Override
    public Datum copyDeleteFrom(LispBag d) {
        return this.copy().deleteFrom(d);
    }

    @Override
    public Datum deleteFrom(LispBag d) {
        SExpressionDatum r = this;
        for (Datum x : d) {
            r = (SExpressionDatum)r.delete(x);
        }
        return r;
    }

    @Override
    public Datum copyDeleteAllFrom(LispBag d) {
        final LispBag e = d;
        return this.copy(new DatumPredicate(){

            public boolean test(Datum x) {
                return !e.contains(x);
            }
        });
    }

    @Override
    public Datum deleteAllFrom(LispBag d) {
        final LispBag e = d;
        return this.delete(new DatumPredicate(){

            public boolean test(Datum x) {
                return !e.contains(x);
            }
        });
    }

    @Override
    public Symbol getCollectionName() {
        return Symbol.getSymbol("list");
    }

    @Override
    public int size() {
        Datum p = this;
        HashSet<Cons> s = new HashSet<Cons>();
        int r = 0;
        while (p instanceof Cons) {
            if (s.contains(p)) {
                return -1;
            }
            ++r;
            s.add((Cons)p);
            p = p.cdr;
        }
        return r;
    }

    @Override
    public boolean equivalence(Datum a, Datum b) {
        return LispUtils.equals(a, b);
    }

    @Override
    public Datum prototype() {
        return Nil.NIL;
    }

    @Override
    public Datum clear() {
        return Nil.NIL;
    }

    @Override
    public boolean equalTo(LispCollection col) {
        Cons p = this;
        for (Datum x : col) {
            if (!(p instanceof Cons)) {
                return p.getCdr().isNil();
            }
            if (!LispUtils.equals(x, p.car)) {
                return false;
            }
            p = (Cons)p.cdr;
        }
        return p.isNil();
    }

    @Override
    public boolean equalTo(LispCollection col, Procedure proc, Environment env, LispMessage mesg) {
        Datum p = this;
        for (Datum x : col) {
            if (!(p instanceof Cons)) {
                return p.getCdr().isNil();
            }
            if (!Scheme.callva(proc, env, mesg, p.car, x).isTrue()) {
                return false;
            }
            p = p.cdr;
        }
        return p.isNil();
    }

    @Override
    public Datum duplicate() {
        return this.copy();
    }

    @Override
    public boolean contains(Datum d) {
        Datum p = this;
        while (p instanceof Cons) {
            if (LispUtils.equals(d, p.car)) {
                return true;
            }
            p = p.cdr;
        }
        return false;
    }

    @Override
    public Iterator<Datum> iterator() {
        return new ConsIterator(this);
    }

    @Override
    public Datum first() {
        return this.car;
    }

    @Override
    public Datum last() {
        Cons p = this;
        while (p.cdr instanceof Cons) {
            p = (Cons)p.cdr;
        }
        return p.car;
    }

    @Override
    public Datum insertFirst(Datum d) throws ImmutableException {
        return new Cons(d, this);
    }

    @Override
    public Datum insertLast(Datum d) throws ImmutableException {
        Cons p = this;
        while (p.cdr instanceof Cons) {
            p = (Cons)p.cdr;
        }
        p.cdr = new Cons(d, p.cdr);
        return this;
    }

    @Override
    public Datum copyInsertFirst(Datum d) {
        return new Cons(d, this.copy());
    }

    @Override
    public Datum copyInsertLast(Datum d) {
        Cons p;
        Cons q = p = this.copy();
        while (p.cdr instanceof Cons) {
            p = (Cons)p.cdr;
        }
        p.cdr = new Cons(d, p.cdr);
        return q;
    }

    @Override
    public Datum[] removeFirst() {
        return new Datum[]{this.cdr, this.car};
    }

    @Override
    public Datum[] removeLast() {
        Cons p = this;
        Cons p0 = null;
        while (p.cdr instanceof Cons) {
            p0 = p0 == null ? this : p;
            p = (Cons)p.cdr;
        }
        if (p0 == null) {
            return new Datum[]{Nil.NIL, p.car};
        }
        p0.cdr = Nil.NIL;
        return new Datum[]{this, p.car};
    }

    @Override
    public Datum[] copyWithoutFirst() {
        if (this.cdr instanceof Cons) {
            return new Datum[]{((Cons)this.cdr).copy(), this.car};
        }
        return new Datum[]{Nil.NIL, this.car};
    }

    @Override
    public Datum[] copyWithoutLast() {
        return this.copy().removeLast();
    }

    @Override
    public Datum copyInsert(int index, Datum d) {
        return this.copy().insert(index, d);
    }

    @Override
    public Datum insert(int index, Datum d) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("" + index);
        }
        if (index == 0) {
            return new Cons(d, this);
        }
        Datum p = this;
        Cons q = this;
        int i = 0;
        while (i < index) {
            if (!(p instanceof Cons)) {
                throw new IndexOutOfBoundsException("" + i);
            }
            q = p;
            p = p.cdr;
            ++i;
        }
        q.cdr = new Cons(d, p);
        return this;
    }

    @Override
    public Datum copyDelete(int index) {
        return this.copy().delete(index);
    }

    @Override
    public Datum delete(int index) {
        Cons p = this;
        Cons q = null;
        if (index < 0) {
            throw new IndexOutOfBoundsException("" + index);
        }
        int i = 0;
        while (i < index) {
            if (!(p.cdr instanceof Cons)) {
                throw new IndexOutOfBoundsException();
            }
            q = p;
            p = (Cons)p.cdr;
            ++i;
        }
        if (q == null) {
            return p.cdr;
        }
        q.cdr = p.cdr;
        return this;
    }

    @Override
    public Iterator<Map.Entry<Datum, Datum>> entryIterator() {
        final Iterator<Datum> itr = this.iterator();
        return new Iterator<Map.Entry<Datum, Datum>>(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public Map.Entry<Datum, Datum> next() {
                final Datum d = (Datum)itr.next();
                if (d instanceof Cons) {
                    final Cons c = (Cons)d;
                    return new Map.Entry<Datum, Datum>(){

                        @Override
                        public Datum getKey() {
                            return c.getCar();
                        }

                        @Override
                        public Datum getValue() {
                            return c.getCdr();
                        }

                        @Override
                        public Datum setValue(Datum value) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
                return new Map.Entry<Datum, Datum>(){

                    @Override
                    public Datum getKey() {
                        return d;
                    }

                    @Override
                    public Datum getValue() {
                        return Undef.UNDEF;
                    }

                    @Override
                    public Datum setValue(Datum value) {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public void remove() {
                itr.remove();
            }
        };
    }

    @Override
    public Procedure keyEquivalence() {
        return new IsEqual();
    }

    @Override
    public Procedure valueEquivalence() {
        return new IsEqual();
    }

    @Override
    public boolean containsKey(Datum k) {
        Datum x = this;
        while (x instanceof Cons) {
            Cons c = x;
            if (c.car instanceof Cons ? LispUtils.equals(k, ((Cons)c.car).car) : LispUtils.equals(k, c.car)) {
                return true;
            }
            x = x.cdr;
        }
        return false;
    }

    @Override
    public SExpressionDatum keysToList() {
        ConsListBuilder b = new ConsListBuilder();
        Datum x = this;
        while (x instanceof Cons) {
            Cons c = x;
            if (c.car instanceof Cons) {
                b.append(((Cons)c.car).car);
            } else {
                b.append(c.car);
            }
            x = x.cdr;
        }
        return b.get();
    }

    @Override
    public Datum get(Datum k) {
        Datum x = this;
        while (x instanceof Cons) {
            Cons c = x;
            if (c.car instanceof Cons) {
                if (LispUtils.equals(k, ((Cons)c.car).car)) {
                    return ((Cons)c.car).cdr;
                }
            } else if (LispUtils.equals(k, c.car)) {
                return Undef.UNDEF;
            }
            x = x.cdr;
        }
        return null;
    }

    @Override
    public Datum[] copyPut(Datum k, Datum v) {
        return this.copy().put(k, v);
    }

    @Override
    public Datum[] put(Datum k, Datum v) {
        Datum[] r = new Datum[2];
        Datum x = this;
        while (x instanceof Cons) {
            Cons c = x;
            if (c.car instanceof Cons) {
                if (LispUtils.equals(k, ((Cons)c.car).car)) {
                    r[0] = this;
                    r[1] = ((Cons)c.car).cdr;
                    ((Cons)c.car).cdr = v;
                    return r;
                }
            } else if (LispUtils.equals(k, c.car)) {
                r[0] = this;
                r[1] = Undef.UNDEF;
                c.car = new Cons(k, v);
                return r;
            }
            x = x.cdr;
        }
        r[0] = new Cons(new Cons(k, v), this);
        r[1] = null;
        return r;
    }

    @Override
    public Datum copyAddFrom(LispMap m) {
        return this.copy().addFrom(m);
    }

    @Override
    public Datum addFrom(LispMap m) {
        Iterator<Map.Entry<Datum, Datum>> itr = m.entryIterator();
        Datum r = this;
        while (itr.hasNext()) {
            Map.Entry<Datum, Datum> e = itr.next();
            r = this.put(e.getKey(), e.getValue())[0];
        }
        return r;
    }

    @Override
    public Datum copyDeleteKey(Datum k) {
        return this.copy().deleteKey(k);
    }

    @Override
    public Datum deleteKey(Datum k) {
        Datum x = this;
        Datum s = null;
        Cons r = null;
        while (x instanceof Cons) {
            Cons c = x;
            if (c.car instanceof Cons && LispUtils.equals(k, ((Cons)c.car).car)) {
                if (s != null) {
                    r.cdr = c.cdr;
                    break;
                }
                s = c.cdr;
                break;
            }
            if (LispUtils.equals(k, c.car)) {
                if (s != null) {
                    r.cdr = c.cdr;
                    break;
                }
                s = c.cdr;
                break;
            }
            if (s == null) {
                s = c;
            }
            r = c;
            x = c.cdr;
        }
        return s == null ? Nil.NIL : s;
    }

    @Override
    public int count(Datum c2a) {
        int r = 0;
        for (Datum x : this) {
            if (!this.equivalence(x, c2a)) continue;
            ++r;
        }
        return r;
    }

    @Override
    public boolean equivalenceKey(Datum a, Datum b) {
        return LispUtils.equals(a, b);
    }

    @Override
    public boolean equivalenceValue(Datum a, Datum b) {
        return LispUtils.equals(a, b);
    }

    @Override
    public SExpressionDatum getAllAsList(Datum k) {
        ConsListBuilder b = new ConsListBuilder();
        for (Datum d : this) {
            if (d instanceof Cons) {
                Cons c = (Cons)d;
                if (!this.equivalenceKey(c.getCar(), k)) continue;
                b.append(c.getCdr());
                continue;
            }
            if (!this.equivalenceKey(d, k)) continue;
            b.append(Undef.UNDEF);
        }
        return b.get();
    }

    @Override
    public Datum copyUpdateAll(Datum k, Procedure f, Procedure th, Environment env, LispMessage mesg) {
        return this.copy().updateAll(k, f, th, env, mesg);
    }

    @Override
    public Datum updateAll(Datum k, Procedure f, Procedure th, Environment env, LispMessage mesg) {
        boolean chg = false;
        Datum p = this;
        while (p instanceof Cons) {
            Cons q = p;
            if (q.getCar() instanceof Cons) {
                Cons c = (Cons)q.getCar();
                if (this.equivalenceKey(c.car, k)) {
                    c.cdr = Scheme.callva(f, env, mesg, c.cdr);
                    chg = true;
                }
            } else if (this.equivalenceKey(q, k)) {
                q.car = new Cons(k, Scheme.callva(f, env, mesg, q));
                chg = true;
            }
            p = q.cdr;
        }
        if (chg) {
            return this;
        }
        if (th != null) {
            return new Cons(new Cons(k, Scheme.callva(th, env, mesg, new Datum[0])), this);
        }
        return new Cons(new Cons(k, LispBoolean.FALSE), this);
    }

    @Override
    public Datum copyDeleteAllKey(Datum k) {
        return this.copy().deleteAllKey(k);
    }

    @Override
    public Datum deleteAllKey(Datum k) {
        Datum x = this;
        Cons r = null;
        Cons s = null;
        while (x instanceof Cons) {
            Cons c = x;
            if (c.car instanceof Cons && LispUtils.equals(k, ((Cons)c.car).car)) {
                if (s != null) {
                    r.cdr = c.cdr;
                }
            } else if (LispUtils.equals(k, c.car)) {
                if (s != null) {
                    r.cdr = c.cdr;
                }
            } else {
                if (s == null) {
                    s = c;
                }
                r = c;
            }
            x = c.cdr;
        }
        return s == null ? Nil.NIL : s;
    }

    @Override
    public Datum copyDeleteFromKey(LispBag d) {
        return this.copy().deleteFromKey(d);
    }

    @Override
    public Datum deleteFromKey(LispBag d) {
        SExpressionDatum r = this;
        for (Datum x : d) {
            r = (SExpressionDatum)r.deleteKey(x);
        }
        return r;
    }

    @Override
    public Datum copyDeleteAllFromKey(LispBag d) {
        final LispBag e = d;
        return this.copy(new DatumPredicate(){

            public boolean test(Datum x) {
                if (x instanceof Cons) {
                    Cons c = (Cons)x;
                    return !e.contains(c.car);
                }
                return !e.contains(x);
            }
        });
    }

    @Override
    public Datum deleteAllFromKey(LispBag d) {
        final LispBag e = d;
        return this.delete(new DatumPredicate(){

            public boolean test(Datum x) {
                if (x instanceof Cons) {
                    Cons c = (Cons)x;
                    return !e.contains(c.car);
                }
                return !e.contains(x);
            }
        });
    }

    @Override
    public Datum copyAddFrom(LispDictionary d) {
        return LispUtils.nconc(this.copy(), LispUtils.toAlist(d.entryIterator()));
    }

    @Override
    public Datum addFrom(LispDictionary d) {
        if (d instanceof SExpressionDatum) {
            return LispUtils.nconc(this, (Datum)((Object)d));
        }
        return LispUtils.nconc(this, LispUtils.toAlist(d.entryIterator()));
    }

    @Override
    public Datum copyReplaceAll(Datum k, Datum[] array) {
        return this.copy().replaceAll(k, array);
    }

    @Override
    public Datum replaceAll(Datum k, Datum[] array) {
        SExpressionDatum d = (SExpressionDatum)this.deleteAllKey(k);
        Datum[] datumArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Datum x = datumArray[n2];
            Cons l = new Cons(new Cons(k, x), Nil.NIL);
            if (d.isNil()) {
                d = l;
            } else if (d instanceof Cons) {
                d = LispUtils.nconc((Cons)d, l);
            } else {
                throw new RuntimeException();
            }
            ++n2;
        }
        return d;
    }

    @Override
    public Datum toList() {
        return this;
    }

    @Override
    public int countValue(Datum d) {
        Iterator<Map.Entry<Datum, Datum>> itr = this.entryIterator();
        int r = 0;
        while (itr.hasNext()) {
            if (!this.equivalence(itr.next().getValue(), d)) continue;
            ++r;
        }
        return r;
    }

    @Override
    public int countKey(Datum d) {
        Iterator<Map.Entry<Datum, Datum>> itr = this.entryIterator();
        int r = 0;
        while (itr.hasNext()) {
            if (!this.equivalence(itr.next().getKey(), d)) continue;
            ++r;
        }
        return r;
    }

    @Override
    public boolean equalToMap(LispMap e, Procedure p, Environment env, LispMessage mesg) {
        return LispCollections.contains(this, e, p, env, mesg) && LispCollections.contains(e, this, p, env, mesg);
    }

    @Override
    public boolean equalToDictionary(LispDictionary e, Procedure p, Environment env, LispMessage mesg) {
        return LispCollections.contains(this, e, p, env, mesg) && LispCollections.contains(e, this, p, env, mesg);
    }

    @Override
    public SExpression add(SExpression y) {
        ConsListBuilder b = new ConsListBuilder();
        ConsIterator itr = new ConsIterator(this);
        while (itr.hasNext()) {
            b.append(itr.next());
        }
        return (Cons)b.get((Datum)((Object)y));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public SExpression mul(SExpression y) {
        b = new ConsListBuilder();
        itr = new ConsIterator(this);
        if (!((Datum)y).isNil()) ** GOTO lbl11
        return Nil.NIL;
lbl-1000:
        // 1 sources

        {
            x = itr.next();
            ity = new ConsIterator((Datum)y);
            while (ity.hasNext()) {
                b.append(new Cons(x, ity.next()));
            }
lbl11:
            // 2 sources

            ** while (itr.hasNext())
        }
lbl12:
        // 1 sources

        return b.get();
    }
}

