/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.number.intmodulo;

import net.morilib.lang.number.intmodulo.InvalidModuloException;
import net.morilib.lang.number.intmodulo.ResidueRingElement;
import net.morilib.util.IntMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntResidue
implements ResidueRingElement<IntResidue> {
    private int value;
    private int modulo;

    protected IntResidue(int value, int modulo) {
        if (modulo <= 0) {
            throw new InvalidModuloException();
        }
        this.value = IntResidue.mod(value, modulo);
        this.modulo = modulo;
    }

    private static int mod(int v, int md) {
        int w = v % md;
        return w < 0 ? md + w : w;
    }

    public static IntResidue valueOf(int value, int modulo) {
        return new IntResidue(value, modulo);
    }

    @Override
    public boolean isZero() {
        return this.value == 0;
    }

    @Override
    public IntResidue negate() {
        return new IntResidue((this.modulo - this.value) % this.modulo, this.modulo);
    }

    @Override
    public IntResidue subtract(int n) {
        return new IntResidue(IntResidue.mod(this.value - n, this.modulo), this.modulo);
    }

    @Override
    public IntResidue subtract(IntResidue x) {
        if (this.modulo != x.modulo) {
            throw new InvalidModuloException();
        }
        return new IntResidue(IntResidue.mod(this.value - x.value, this.modulo), this.modulo);
    }

    @Override
    public IntResidue add(int n) {
        return new IntResidue(IntResidue.mod(this.value + n, this.modulo), this.modulo);
    }

    @Override
    public IntResidue add(IntResidue x) {
        if (this.modulo != x.modulo) {
            throw new InvalidModuloException();
        }
        return new IntResidue(IntResidue.mod(this.value + x.value, this.modulo), this.modulo);
    }

    @Override
    public IntResidue multiply(int n) {
        return new IntResidue(IntResidue.mod(this.value * n, this.modulo), this.modulo);
    }

    @Override
    public IntResidue multiply(IntResidue x) {
        if (this.modulo != x.modulo) {
            throw new InvalidModuloException();
        }
        return new IntResidue(IntResidue.mod(this.value * x.value, this.modulo), this.modulo);
    }

    @Override
    public IntResidue power(int n) {
        return new IntResidue(IntResidue.mod(IntMath.pow(this.value, n), this.modulo), this.modulo);
    }

    @Override
    public IntResidue declement() {
        return new IntResidue(IntResidue.mod(this.value - 1, this.modulo), this.modulo);
    }

    @Override
    public IntResidue inclement() {
        return new IntResidue(IntResidue.mod(this.value + 1, this.modulo), this.modulo);
    }

    public boolean isCongruent(int n) {
        return this.value == IntResidue.mod(n, this.modulo);
    }

    public int intValue() {
        return this.value;
    }

    public int intModulo() {
        return this.modulo;
    }

    public boolean equals(Object o) {
        if (o instanceof IntResidue) {
            IntResidue r = (IntResidue)o;
            return this.value == r.value && this.modulo == r.modulo;
        }
        return false;
    }

    public int hashCode() {
        int r = 17;
        r = r * 37 + this.value;
        r = r * 37 + this.modulo;
        return r;
    }

    public String toString() {
        return String.valueOf(this.value) + "(mod " + this.modulo + ")";
    }
}

