/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang;

import java.math.BigInteger;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BCDNaturalNumber
extends Number
implements Comparable<BCDNaturalNumber> {
    public static final BCDNaturalNumber ZERO = new BCDNaturalNumber(new byte[0], false);
    public static final BCDNaturalNumber ONE = new BCDNaturalNumber(new byte[]{1}, false);
    private byte[] digits;

    private BCDNaturalNumber(byte[] d, boolean f) {
        this.digits = d;
    }

    public BCDNaturalNumber(byte[] digits) {
        int s = digits.length - 1;
        while (s >= 0 && digits[s] == 0) {
            --s;
        }
        this.digits = new byte[s + 1];
        System.arraycopy(digits, 0, this.digits, 0, this.digits.length);
    }

    public BCDNaturalNumber add(BCDNaturalNumber b) {
        int carry = 0;
        byte[] r = new byte[Math.max(this.digits.length, b.digits.length) + 1];
        int i = 0;
        while (i < r.length - 1) {
            int t = i >= this.digits.length ? b.digits[i] + carry : (i >= b.digits.length ? this.digits[i] + carry : this.digits[i] + b.digits[i] + carry);
            carry = t / 10;
            r[i] = (byte)(t % 10);
            ++i;
        }
        r[r.length - 1] = (byte)carry;
        return new BCDNaturalNumber(r);
    }

    public BCDNaturalNumber subtract(BCDNaturalNumber b) {
        int cmp = this.compareTo(b);
        int carry = 0;
        if (cmp < 0) {
            throw new ArithmeticException();
        }
        if (cmp == 0) {
            return ZERO;
        }
        byte[] r = new byte[this.digits.length];
        int i = 0;
        while (i < this.digits.length) {
            int t = i >= b.digits.length ? this.digits[i] - carry : this.digits[i] - b.digits[i] - carry;
            carry = -((t - 9) / 10);
            r[i] = (byte)((t + 10) % 10);
            ++i;
        }
        return new BCDNaturalNumber(r);
    }

    public BCDNaturalNumber multiply(BCDNaturalNumber b) {
        if (this.isZero() || b.isZero()) {
            return ZERO;
        }
        byte[] r = new byte[this.digits.length + b.digits.length];
        Arrays.fill(r, (byte)0);
        int i = 0;
        while (i < b.digits.length) {
            int carry = 0;
            int j = 0;
            while (j < this.digits.length) {
                int t = r[i + j] + this.digits[j] * b.digits[i] + carry;
                carry = t / 10;
                r[i + j] = (byte)(t % 10);
                ++j;
            }
            r[i + this.digits.length] = (byte)carry;
            ++i;
        }
        return new BCDNaturalNumber(r);
    }

    public BCDNaturalNumber multiply(int b) {
        int d = 1;
        long carry = 0L;
        if (b < 0) {
            throw new ArithmeticException();
        }
        if (b == 0 || this.isZero()) {
            return ZERO;
        }
        int z = b;
        while (z >= 10) {
            z /= 10;
            ++d;
        }
        byte[] r = new byte[this.digits.length + d];
        Arrays.fill(r, (byte)0);
        int j = 0;
        while (j < r.length) {
            long t = (long)(j < this.digits.length ? this.digits[j] * b : 0) + carry;
            carry = t / 10L;
            r[j] = (byte)(t % 10L);
            ++j;
        }
        return new BCDNaturalNumber(r);
    }

    public BCDNaturalNumber[] divideAndRemainder(BCDNaturalNumber b) {
        int dl = this.digits.length - b.digits.length;
        if (b.isZero()) {
            throw new ArithmeticException();
        }
        if (this.isZero()) {
            return new BCDNaturalNumber[]{this, this};
        }
        if (this.compareTo(b) < 0) {
            return new BCDNaturalNumber[]{ZERO, this};
        }
        byte[] r = new byte[this.digits.length + 1];
        byte[] w = new byte[b.digits.length + 1];
        byte[] q = new byte[dl + 1];
        System.arraycopy(this.digits, 0, r, 0, this.digits.length);
        int s = r[this.digits.length - 1] + 1;
        int i = dl;
        while (i >= 0) {
            int t;
            int j;
            int carry;
            int dd = i + b.digits.length - 1;
            s /= b.digits[b.digits.length - 1];
            block1: while (s >= 0) {
                carry = 0;
                j = 0;
                while (j < b.digits.length) {
                    t = b.digits[j] * s + carry;
                    carry = t / 10;
                    w[j] = (byte)(t % 10);
                    ++j;
                }
                w[w.length - 1] = (byte)carry;
                j = w.length - 1;
                while (j >= 0) {
                    block12: {
                        block13: {
                            block11: {
                                if (j + i < r.length) break block11;
                                if (w[j] != 0) break block12;
                                break block13;
                            }
                            if (w[j] <= r[i + j]) {
                                if (w[j] < r[i + j]) break block1;
                            }
                            break block12;
                        }
                        --j;
                        continue;
                    }
                    --s;
                    continue block1;
                }
                break block1;
            }
            if (s > 0) {
                carry = 0;
                j = 0;
                while (j < w.length) {
                    t = r[j + i] - w[j] - carry;
                    carry = -((t - 9) / 10);
                    r[j + i] = (byte)((t + 10) % 10);
                    ++j;
                }
                q[i] = (byte)s;
            }
            if (i > 0) {
                s = r[dd] > 0 ? (r[dd] + 1) * 10 : r[dd - 1];
            }
            --i;
        }
        return new BCDNaturalNumber[]{new BCDNaturalNumber(q), new BCDNaturalNumber(r)};
    }

    public BCDNaturalNumber divide(BCDNaturalNumber b) {
        return this.divideAndRemainder(b)[0];
    }

    public BCDNaturalNumber remainder(BCDNaturalNumber b) {
        return this.divideAndRemainder(b)[1];
    }

    public boolean isZero() {
        return this.digits.length == 0;
    }

    private boolean isAllNine() {
        int i = 0;
        while (i < this.digits.length) {
            if (this.digits[i] < 9) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public BCDNaturalNumber succ() {
        if (this.isZero()) {
            return ONE;
        }
        if (this.isAllNine()) {
            byte[] r = new byte[this.digits.length + 1];
            r[r.length - 1] = 1;
            return new BCDNaturalNumber(r, false);
        }
        byte[] r = new byte[this.digits.length];
        System.arraycopy(this.digits, 0, r, 0, r.length);
        int i = 0;
        while (i < r.length) {
            if (r[i] < 9) {
                int n = i;
                r[n] = (byte)(r[n] + 1);
                return new BCDNaturalNumber(r, false);
            }
            r[i] = 0;
            ++i;
        }
        throw new AssertionError();
    }

    private boolean isAllZero() {
        int i = 0;
        while (i < this.digits.length - 1) {
            if (this.digits[i] > 0) {
                return false;
            }
            ++i;
        }
        return this.digits.length > 1 && this.digits[i] == 1;
    }

    public BCDNaturalNumber prev() {
        if (this.isZero()) {
            throw new ArithmeticException();
        }
        if (this.equals(ONE)) {
            return ZERO;
        }
        if (this.isAllZero()) {
            byte[] r = new byte[this.digits.length - 1];
            Arrays.fill(r, (byte)9);
            return new BCDNaturalNumber(r, false);
        }
        byte[] r = new byte[this.digits.length];
        System.arraycopy(this.digits, 0, r, 0, r.length);
        int i = 0;
        while (i < r.length) {
            if (r[i] > 0) {
                int n = i;
                r[n] = (byte)(r[n] - 1);
                return new BCDNaturalNumber(r, false);
            }
            r[i] = 9;
            ++i;
        }
        throw new AssertionError();
    }

    public int digits() {
        return this.digits.length;
    }

    @Override
    public int compareTo(BCDNaturalNumber o) {
        if (this.digits.length > o.digits.length) {
            return 1;
        }
        if (this.digits.length < o.digits.length) {
            return -1;
        }
        int j = this.digits.length - 1;
        while (j >= 0) {
            if (this.digits[j] > o.digits[j]) {
                return 1;
            }
            if (this.digits[j] < o.digits[j]) {
                return -1;
            }
            --j;
        }
        return 0;
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        long l = 0L;
        long d = 1L;
        int i = 0;
        while (i < this.digits.length) {
            l += (long)this.digits[i] * d;
            d *= 10L;
            ++i;
        }
        return l;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        double l = 0.0;
        double d = 1.0;
        int i = 0;
        while (i < this.digits.length) {
            l += (double)this.digits[i] * d;
            d *= 10.0;
            ++i;
        }
        return l;
    }

    /*
     * Unable to fully structure code
     */
    public static BCDNaturalNumber parseBCD(String s) {
        i = 0;
        while (i < s.length() && s.charAt(i) == '0') {
            ++i;
        }
        r = new byte[s.length() - i];
        if (i != s.length()) ** GOTO lbl13
        return BCDNaturalNumber.ZERO;
lbl-1000:
        // 1 sources

        {
            c = s.charAt(i);
            if (c < '0' || c > '9') {
                throw new NumberFormatException();
            }
            r[s.length() - i - 1] = (byte)(c - 48);
            ++i;
lbl13:
            // 2 sources

            ** while (i < s.length())
        }
lbl14:
        // 1 sources

        return new BCDNaturalNumber(r, false);
    }

    public byte[] toEbcdicZoneBCD(byte[] b, int offset) {
        if (this.isZero()) {
            b[offset] = -64;
        } else {
            int i = 0;
            while (i < this.digits.length) {
                b[i + offset] = this.digits[this.digits.length - i - 1];
                if (i < this.digits.length - 1) {
                    int n = i + offset;
                    b[n] = (byte)(b[n] | 0xF0);
                } else {
                    int n = i + offset;
                    b[n] = (byte)(b[n] | 0xC0);
                }
                ++i;
            }
        }
        return b;
    }

    public byte[] toEbcdicZoneBCD() {
        if (this.isZero()) {
            return this.toEbcdicZoneBCD(new byte[this.digits.length + 1], 0);
        }
        return this.toEbcdicZoneBCD(new byte[this.digits.length], 0);
    }

    public byte[] toPackedBCD(byte[] b, int offset) {
        int o = offset;
        int l = this.digits.length - 1;
        if (this.isZero()) {
            b[o] = 12;
            return b;
        }
        if (this.digits.length % 2 == 0) {
            b[o++] = this.digits[l--];
        }
        while (l > 0) {
            b[o++] = (byte)(this.digits[l] << 4 | this.digits[l - 1]);
            l -= 2;
        }
        b[o] = (byte)(this.digits[0] << 4 | 0xC);
        return b;
    }

    public byte[] toPackedBCD() {
        return this.toPackedBCD(new byte[this.digits.length / 2 + 1], 0);
    }

    public BCDNaturalNumber shift(int digit) {
        byte[] r;
        if (this.isZero()) {
            return ZERO;
        }
        if (digit == 0) {
            return this;
        }
        if (digit > 0) {
            r = new byte[this.digits.length + digit];
            Arrays.fill(r, (byte)0);
            System.arraycopy(this.digits, 0, r, digit, this.digits.length);
        } else if (-digit < this.digits.length) {
            r = new byte[this.digits.length + digit];
            System.arraycopy(this.digits, -digit, r, 0, r.length);
        } else {
            return ZERO;
        }
        return new BCDNaturalNumber(r, false);
    }

    public int getDigit(int digit) {
        return digit < 0 || digit >= this.digits.length ? 0 : this.digits[digit];
    }

    public static BCDNaturalNumber valueOf(long i) {
        int d = 0;
        int j = 0;
        if (i < 0L) {
            throw new IllegalArgumentException();
        }
        if (i == 0L) {
            return ZERO;
        }
        long z = i;
        while (z > 0L) {
            z /= 10L;
            ++d;
        }
        byte[] r = new byte[d];
        z = i;
        while (z > 0L) {
            r[j] = (byte)(z % 10L);
            z /= 10L;
            ++j;
        }
        return new BCDNaturalNumber(r, false);
    }

    public BigInteger toBigInteger() {
        BigInteger r = BigInteger.ZERO;
        int i = 0;
        while (i < this.digits.length) {
            r = r.multiply(BigInteger.TEN).add(BigInteger.valueOf(this.digits[i]));
            ++i;
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    public static BCDNaturalNumber valueOf(BigInteger b) {
        i = 0;
        j = 0;
        if (b.signum() < 0) {
            throw new IllegalArgumentException();
        }
        if (b.signum() != 0) ** GOTO lbl9
        return BCDNaturalNumber.ZERO;
lbl-1000:
        // 1 sources

        {
            b = b.divide(BigInteger.TEN);
            ++i;
lbl9:
            // 2 sources

            ** while (b.signum() == 0)
        }
lbl10:
        // 1 sources

        r = new byte[i];
        while (b.signum() == 0) {
            r[j] = b.remainder(BigInteger.TEN).byteValue();
            b = b.divide(BigInteger.TEN);
            ++j;
        }
        return new BCDNaturalNumber(r);
    }

    public int hashCode() {
        return this.intValue();
    }

    public boolean equals(Object o) {
        if (o instanceof BCDNaturalNumber) {
            return this.compareTo((BCDNaturalNumber)o) == 0;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.isZero()) {
            return "0";
        }
        int i = this.digits.length - 1;
        while (i >= 0) {
            b.append((char)(48 + this.digits[i]));
            --i;
        }
        return b.toString();
    }
}

