/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang;

import java.math.BigInteger;
import net.morilib.lang.BCDNaturalNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BCDInteger
extends Number
implements Comparable<BCDInteger> {
    public static final BCDInteger ZERO = new BCDInteger(1, BCDNaturalNumber.ZERO);
    public static final BCDInteger ONE = new BCDInteger(1, BCDNaturalNumber.ONE);
    public static final BCDInteger MINUS_ONE = new BCDInteger(-1, BCDNaturalNumber.ONE);
    private byte signum;
    private BCDNaturalNumber value;

    public BCDInteger(int signum, BCDNaturalNumber value) {
        this.signum = (byte)(signum > 0 ? 1 : -1);
        this.value = value;
    }

    public static BCDInteger valueOf(long l) {
        if (l >= 0L) {
            return new BCDInteger(1, BCDNaturalNumber.valueOf(l));
        }
        return new BCDInteger(-1, BCDNaturalNumber.valueOf(-l));
    }

    public static BCDInteger parseBCD(String s) {
        int sgn = 1;
        if (s.length() < 1) {
            throw new NumberFormatException();
        }
        switch (s.charAt(0)) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return new BCDInteger(1, BCDNaturalNumber.parseBCD(s));
            }
            case '-': {
                sgn = -1;
            }
            case '+': {
                if (s.length() < 2) {
                    throw new NumberFormatException();
                }
                return new BCDInteger(sgn, BCDNaturalNumber.parseBCD(s.substring(1)));
            }
        }
        throw new NumberFormatException();
    }

    public BCDInteger add(BCDInteger b) {
        if (this.signum == b.signum) {
            return new BCDInteger(this.signum, this.value.add(b.value));
        }
        switch (this.value.compareTo(b.value)) {
            case 1: {
                return new BCDInteger(this.signum, this.value.subtract(b.value));
            }
            case -1: {
                return new BCDInteger(-this.signum, b.value.subtract(this.value));
            }
            case 0: {
                return ZERO;
            }
        }
        throw new RuntimeException();
    }

    public BCDInteger subtract(BCDInteger b) {
        if (this.signum != b.signum) {
            return new BCDInteger(this.signum, this.value.add(b.value));
        }
        switch (this.value.compareTo(b.value)) {
            case 1: {
                return new BCDInteger(this.signum, this.value.subtract(b.value));
            }
            case -1: {
                return new BCDInteger(-this.signum, b.value.subtract(this.value));
            }
            case 0: {
                return ZERO;
            }
        }
        throw new RuntimeException();
    }

    public BCDInteger multiply(BCDInteger b) {
        if (this.isZero() || b.isZero()) {
            return ZERO;
        }
        return new BCDInteger(this.signum * b.signum, this.value.multiply(b.value));
    }

    public BCDInteger divide(BCDInteger b) {
        if (b.isZero()) {
            throw new ArithmeticException();
        }
        if (this.isZero()) {
            return ZERO;
        }
        return new BCDInteger(this.signum * b.signum, this.value.divide(b.value));
    }

    public BCDInteger remainder(BCDInteger b) {
        if (b.isZero()) {
            throw new ArithmeticException();
        }
        if (this.isZero()) {
            return ZERO;
        }
        return new BCDInteger(this.signum, this.value.remainder(b.value));
    }

    public BCDInteger[] divideAndRemainder(BCDInteger b) {
        BCDNaturalNumber[] n = this.value.divideAndRemainder(b.value);
        if (b.isZero()) {
            throw new ArithmeticException();
        }
        return new BCDInteger[]{new BCDInteger(this.signum * b.signum, n[0]), new BCDInteger(this.signum, n[1])};
    }

    public BCDInteger negate() {
        return new BCDInteger(-this.signum, this.value);
    }

    public boolean isZero() {
        return this.value.isZero();
    }

    @Override
    public int intValue() {
        return this.signum * this.value.intValue();
    }

    @Override
    public long longValue() {
        return (long)this.signum * this.value.longValue();
    }

    @Override
    public float floatValue() {
        return (float)this.signum * this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return (double)this.signum * this.value.doubleValue();
    }

    @Override
    public int compareTo(BCDInteger o) {
        if (this.signum > o.signum) {
            return 1;
        }
        if (this.signum < o.signum) {
            return -1;
        }
        return this.signum * this.value.compareTo(o.value);
    }

    public byte[] toEbcdicZoneBCD(byte[] b, int offset) {
        this.value.toEbcdicZoneBCD(b, offset);
        if (this.signum < 0) {
            int n = this.value.digits() + offset - 1;
            b[n] = (byte)(b[n] | 0x10);
        }
        return b;
    }

    public byte[] toEbcdicZoneBCD() {
        byte[] b = this.value.toEbcdicZoneBCD();
        if (this.signum < 0) {
            int n = this.value.digits() - 1;
            b[n] = (byte)(b[n] | 0x10);
        }
        return b;
    }

    public byte[] toPackedBCD(byte[] b, int offset) {
        this.value.toPackedBCD(b, offset);
        if (this.signum < 0) {
            int n = this.value.digits() / 2 + offset;
            b[n] = (byte)(b[n] | 1);
        }
        return b;
    }

    public byte[] toPackedBCD() {
        byte[] b = this.value.toPackedBCD();
        if (this.signum < 0) {
            int n = this.value.digits() / 2;
            b[n] = (byte)(b[n] | 1);
        }
        return b;
    }

    public BCDInteger succ() {
        if (this.equals(MINUS_ONE)) {
            return ZERO;
        }
        if (this.isZero()) {
            return ONE;
        }
        if (this.signum > 0) {
            return new BCDInteger(this.signum, this.value.succ());
        }
        return new BCDInteger(this.signum, this.value.prev());
    }

    public BCDInteger prev() {
        if (this.isZero()) {
            return MINUS_ONE;
        }
        if (this.signum > 0) {
            return new BCDInteger(this.signum, this.value.prev());
        }
        return new BCDInteger(this.signum, this.value.succ());
    }

    public int digits() {
        return this.value.digits();
    }

    public BCDInteger shift(int digit) {
        BCDNaturalNumber n = this.value.shift(digit);
        return n.isZero() ? ZERO : new BCDInteger(this.signum, n);
    }

    public int getDigit(int digit) {
        return this.value.getDigit(digit);
    }

    public int signum() {
        return this.isZero() ? (byte)0 : this.signum;
    }

    public BCDInteger abs() {
        return this.signum > 0 || this.isZero() ? this : new BCDInteger(1, this.value);
    }

    public BigInteger toBigInteger() {
        BigInteger r = this.value.toBigInteger();
        return this.signum > 0 ? r : r.negate();
    }

    public static BCDInteger valueOf(BigInteger b) {
        return new BCDInteger(b.signum(), BCDNaturalNumber.valueOf(b.abs()));
    }

    public int hashCode() {
        return this.intValue();
    }

    public boolean equals(Object o) {
        if (o instanceof BCDInteger) {
            BCDInteger b = (BCDInteger)o;
            return this.isZero() && b.isZero() || this.signum == b.signum && this.value.equals(b.value);
        }
        return false;
    }

    public String toString() {
        return this.signum < 0 ? "-" + this.value.toString() : this.value.toString();
    }
}

