/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import net.morilib.lang.Hashes;
import net.morilib.lang.algebra.BooleanElement;
import net.morilib.util.BitUtils;
import net.morilib.util.primitive.BitSet2Class;
import net.morilib.util.primitive.iterator.IntegerIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitSet2
implements BooleanElement<BitSet2>,
Serializable {
    private static final long serialVersionUID = -829198820340136241L;
    private byte[] vector;
    private BitSet2Class cls;
    private transient int modCount = 0;

    BitSet2(BitSet2Class cls) {
        this.cls = cls;
        this.vector = new byte[cls.getSize() + 7 >> 3];
    }

    public BitSet2(BitSet2 s) {
        if (s == null) {
            throw new NullPointerException();
        }
        this.cls = s.cls;
        this.vector = new byte[s.vector.length];
        System.arraycopy(s.vector, 0, this.vector, 0, s.vector.length);
    }

    private int getBitOffset() {
        return -this.cls.getMinimum();
    }

    private void checkRange(int v) {
        if (v < this.cls.getMinimum() || v > this.cls.getMaximum()) {
            throw new IllegalArgumentException();
        }
    }

    public boolean add(int v) {
        int p = v + this.getBitOffset();
        int a = p / 8;
        int b = p & 7;
        ++this.modCount;
        this.checkRange(v);
        byte r = this.vector[a];
        int n = a;
        this.vector[n] = (byte)(this.vector[n] | 1 << b);
        return (r & 1 << b) == 0;
    }

    public boolean addAll(BitSet2 t) {
        boolean r = false;
        ++this.modCount;
        int i = 0;
        while (i < this.vector.length) {
            r = this.vector[i] != t.vector[i] || r;
            int n = i;
            this.vector[n] = (byte)(this.vector[n] | t.vector[i]);
            ++i;
        }
        return r;
    }

    public void clear() {
        ++this.modCount;
        int i = 0;
        while (i < this.vector.length) {
            this.vector[i] = 0;
            ++i;
        }
    }

    public boolean contains(int v) {
        int p = v + this.getBitOffset();
        int a = p / 8;
        int b = p & 7;
        this.checkRange(v);
        return (this.vector[a] & 1 << b) != 0;
    }

    public boolean containsAll(BitSet2 t) {
        int i = 0;
        while (i < this.vector.length) {
            if ((t.vector[i] & ~this.vector[i]) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEmpty() {
        int i = 0;
        while (i < this.vector.length) {
            if (this.vector[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IntegerIterator iterator() {
        return new Itr();
    }

    public boolean remove(int v) {
        int b;
        int p = v + this.getBitOffset();
        int a = p / 8;
        boolean r = (this.vector[a] & 1 << (b = p & 7)) != 0;
        ++this.modCount;
        this.checkRange(v);
        int n = a;
        this.vector[n] = (byte)(this.vector[n] & ~(1 << b));
        return r;
    }

    public boolean removeAll(BitSet2 t) {
        boolean r = false;
        ++this.modCount;
        int i = 0;
        while (i < this.vector.length) {
            r = (this.vector[i] & t.vector[i]) != 0 || r;
            int n = i;
            this.vector[n] = (byte)(this.vector[n] & ~t.vector[i]);
            ++i;
        }
        return r;
    }

    public boolean retainAll(BitSet2 t) {
        boolean r = false;
        ++this.modCount;
        int i = 0;
        while (i < this.vector.length) {
            r = (this.vector[i] & ~t.vector[i]) != 0 || r;
            int n = i;
            this.vector[n] = (byte)(this.vector[n] & t.vector[i]);
            ++i;
        }
        return r;
    }

    public int size() {
        int r = 0;
        int i = 0;
        while (i < this.vector.length) {
            r += BitUtils.countBit(this.vector[i]);
            ++i;
        }
        return r;
    }

    public int first() {
        int i = 0;
        while (i < this.vector.length) {
            if (this.vector[i] != 0) {
                return BitUtils.getLsb(this.vector[i]) + i * 8 - this.getBitOffset();
            }
            ++i;
        }
        throw new NoSuchElementException();
    }

    public int last() {
        int i = this.vector.length - 1;
        while (i >= 0) {
            if (this.vector[i] != 0) {
                return BitUtils.getMsb(this.vector[i]) + i * 8 - this.getBitOffset();
            }
            ++i;
        }
        throw new NoSuchElementException();
    }

    private void checkSet(BitSet2 x) {
        if (x == null) {
            throw new NullPointerException();
        }
        if (!this.cls.equals(x.cls)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public BitSet2 join(BitSet2 x) {
        this.checkSet(x);
        BitSet2 r = new BitSet2(this);
        r.addAll(x);
        return r;
    }

    @Override
    public BitSet2 meet(BitSet2 x) {
        this.checkSet(x);
        BitSet2 r = new BitSet2(this);
        r.retainAll(x);
        return r;
    }

    @Override
    public BitSet2 complement() {
        BitSet2 r = new BitSet2(this);
        int j = 0;
        int i = r.cls.getSize();
        while (i > 0) {
            int msk = i < 8 ? BitUtils.getIntMask(i) : 255;
            r.vector[j] = (byte)(r.vector[j] ^ msk);
            ++j;
            i -= 8;
        }
        return r;
    }

    @Override
    public boolean is0() {
        return this.isEmpty();
    }

    @Override
    public boolean is1() {
        return this.equals(this.cls.get1());
    }

    public BigInteger toBigInteger() {
        return new BigInteger(this.vector);
    }

    public int hashCode() {
        int r = 17;
        r = 37 * (r + Hashes.sumHashCode(this.vector));
        r = 37 * (r + this.cls.hashCode());
        return r;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BitSet2) {
            BitSet2 s = (BitSet2)obj;
            int i = 0;
            while (i < this.vector.length) {
                if (this.vector[i] != s.vector[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        IntegerIterator i = this.iterator();
        String s = "";
        b.append("[");
        while (i.hasNext()) {
            b.append(s).append(i.next());
            s = ", ";
        }
        b.append("]");
        return b.toString();
    }

    private class Itr
    implements IntegerIterator {
        private int ptr = 0;
        private int vec;
        private int prr;
        private int exModCount;

        private Itr() {
            this.vec = BitSet2.this.vector[0];
            this.prr = -1;
            this.exModCount = BitSet2.this.modCount;
            this.seeknext();
        }

        private void seeknext() {
            if (this.vec == 0) {
                while (++this.ptr <= BitSet2.this.vector.length) {
                    if (BitSet2.this.vector[this.ptr] == 0) continue;
                    this.vec = BitSet2.this.vector[this.ptr];
                    return;
                }
                this.ptr = -1;
            }
        }

        public boolean hasNext() {
            return this.ptr >= 0;
        }

        public int next() {
            if (this.exModCount != BitSet2.this.modCount) {
                throw new ConcurrentModificationException();
            }
            this.prr = BitUtils.getLsb(this.vec) - 1;
            this.vec &= ~(1 << this.prr);
            this.seeknext();
            return this.prr + BitSet2.this.getBitOffset();
        }

        public void remove() {
            if (this.exModCount != BitSet2.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.prr < 0) {
                throw new IllegalStateException();
            }
            BitSet2.this.remove(this.prr + BitSet2.this.getBitOffset());
            this.prr = -1;
            this.exModCount = BitSet2.this.modCount;
        }
    }
}

