/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.range;

import java.util.SortedSet;
import net.morilib.range.Interval;
import net.morilib.range.Intervals;
import net.morilib.range.Range;

public class IntervalsInt {
    private static Integer newInt(int i) {
        return new Integer(i);
    }

    public static Interval newInstance(int inf, boolean infOpen, int sup, boolean supOpen) {
        return Interval.newInstance(IntervalsInt.newInt(inf), infOpen, IntervalsInt.newInt(sup), supOpen);
    }

    public static Interval newPoint(int x) {
        return new Interval((Object)IntervalsInt.newInt(x), false, IntervalsInt.newInt(x), false);
    }

    public static Interval newClosedInfimumlessInterval(int sup) {
        return Intervals.newInfimumlessInterval(IntervalsInt.newInt(sup), false);
    }

    public static Interval newOpenInfimumlessInterval(int sup) {
        return Intervals.newInfimumlessInterval(IntervalsInt.newInt(sup), true);
    }

    public static Interval newClosedSupremumlessInterval(int inf) {
        return Intervals.newSupremumlessInterval(IntervalsInt.newInt(inf), false);
    }

    public static Interval newOpenSupremumlessInterval(int inf) {
        return Intervals.newSupremumlessInterval(IntervalsInt.newInt(inf), true);
    }

    public static Interval newClosedInterval(int inf, int sup) {
        return IntervalsInt.newInstance(inf, false, sup, false);
    }

    public static Interval newOpenInterval(int inf, int sup) {
        return IntervalsInt.newInstance(inf, true, sup, true);
    }

    public static Interval newLeftOpenInterval(int inf, int sup) {
        return IntervalsInt.newInstance(inf, true, sup, false);
    }

    public static Interval newRightOpenInterval(int inf, int sup) {
        return IntervalsInt.newInstance(inf, false, sup, true);
    }

    public static long cardinality(Range r) {
        if (r.isEmpty()) {
            return 0L;
        }
        SortedSet<Interval> s = r.intervals();
        int x = 0;
        for (Interval i : s) {
            long a = ((Integer)i.getSupremumBound()).intValue();
            a -= (long)((Integer)i.getInfimumBound()).intValue();
            if (i.isSupremumOpen()) {
                --a;
            }
            if (i.isInfimumOpen()) {
                --a;
            }
            x = (int)((long)x + (a + 1L));
        }
        return x;
    }

    public static long indexOf(Range r, int val) {
        if (!r.contains(val)) {
            return -1L;
        }
        SortedSet<Interval> s = r.intervals();
        long x = 0L;
        for (Interval i : s) {
            int a;
            if (i.contains(val)) {
                a = val;
                a -= ((Integer)i.getInfimumBound()).intValue();
                if (i.isInfimumOpen()) {
                    --a;
                }
                return x + (long)a;
            }
            a = (Integer)i.getSupremumBound();
            a -= ((Integer)i.getInfimumBound()).intValue();
            if (i.isSupremumOpen()) {
                --a;
            }
            if (i.isInfimumOpen()) {
                --a;
            }
            x += (long)a;
        }
        return -1L;
    }

    public static int intAt(Range r, long index) {
        SortedSet<Interval> s = r.intervals();
        long x = 0L;
        if (index < 0L || index >= IntervalsInt.cardinality(r)) {
            throw new IndexOutOfBoundsException("" + index);
        }
        for (Interval i : s) {
            int a = (Integer)i.getSupremumBound();
            a -= (Integer)i.getInfimumBound() - 1;
            if (i.isSupremumOpen()) {
                --a;
            }
            if (i.isInfimumOpen()) {
                --a;
            }
            if (index < x + (long)a) {
                int b = (Integer)i.getInfimumBound();
                if (i.isInfimumOpen()) {
                    ++b;
                }
                return b + (int)(index - x);
            }
            x += (long)a;
        }
        return -1;
    }
}

