/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.parser.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import net.morilib.parser.csv.CSVException;
import net.morilib.parser.csv.CSVHandler;
import net.morilib.parser.csv.CSVParseException;
import net.morilib.parser.csv.CSVParserContinuation;
import net.morilib.parser.csv.CSVPushParser;
import net.morilib.parser.csv.CSVPushParserConfig;

public final class SimpleCSVPushParser
implements CSVPushParser {
    public static final Config CSV_CONFIG = new Config(",", 34, false);
    public static final Config TSV_CONFIG = new Config("\t", 34, false);
    private static final int BEGIN_OF_FILE = 0;
    private static final int BEGIN_OF_LINE = 1;
    private static final int BEGIN_OF_LINE2 = 2;
    private static final int END_OF_LINE = 3;
    private static final int END_OF_FILE = 4;
    private static final int HALT = 5;
    private static final int BEGIN_OF_FIELD = 400;
    private static final int ENCLOSED = 100;
    private static final int UNENCLOSED = 200;
    private static final int UNENCLOSED2 = 201;
    private static final int ENCLOSED_CHAR = 300;
    private static final int COMMENT = 500;
    private static final int PANIC_1 = 900;
    private CSVHandler handler;
    private Config config;

    private SimpleCSVPushParser(CSVHandler handler, Config config) {
        this.handler = handler;
        this.config = config;
    }

    public SimpleCSVPushParser(CSVHandler handler) {
        this(handler, CSV_CONFIG);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CSVParserContinuation parse(CSVParserContinuation cont) throws IOException, CSVException {
        Cont c2 = (Cont)cont;
        int st = c2.st;
        int index = c2.index;
        int line = c2.line;
        int c = c2.c;
        BufferedReader ins = c2.ins;
        int backto = -1;
        StringBuffer b = new StringBuffer();
        block15: while (true) {
            switch (st) {
                case 0: {
                    st = 1;
                    if (!this.handler.startFile()) continue block15;
                    return new Cont(st, index, line, c, ins);
                }
                case 1: {
                    st = 2;
                    if (!this.handler.startLine(line)) continue block15;
                    return new Cont(st, index, line, c, ins);
                }
                case 2: {
                    b = new StringBuffer();
                    index = 1;
                    c = ins.read();
                    if (this.config.delimiters.indexOf(c) >= 0) {
                        st = 400;
                        if (!this.handler.element(b.toString(), line, index++)) continue block15;
                        return new Cont(st, index, line, c, ins);
                    }
                    if (c < 0 || c == this.config.newline) {
                        st = 3;
                        if (!this.handler.emptyLine(line++)) continue block15;
                        return new Cont(st, index, line, c, ins);
                    }
                    if (this.config.commentable && c == this.config.comment) {
                        st = 500;
                        continue block15;
                    }
                    if (c == this.config.quote) {
                        st = 100;
                        if (!this.handler.startLine(line)) continue block15;
                        return new Cont(st, index, line, c, ins);
                    }
                    b.append((char)c);
                    st = 200;
                    if (!this.handler.startLine(line)) continue block15;
                    return new Cont(st, index, line, c, ins);
                }
                case 400: {
                    b = new StringBuffer();
                    c = ins.read();
                    if (!this.config.countinuous && this.config.delimiters.indexOf(c) >= 0) {
                        if (!this.handler.element(b.toString(), line, index++)) continue block15;
                        return new Cont(st, index, line, c, ins);
                    }
                    if (c < 0 || c == this.config.newline) {
                        st = 3;
                        if (!this.handler.element(b.toString(), line, index++)) continue block15;
                        return new Cont(st, index, line, c, ins);
                    }
                    if (c == this.config.quote) {
                        st = 100;
                        continue block15;
                    }
                    if (this.config.charTrimed.indexOf(c) >= 0) {
                        st = 200;
                        continue block15;
                    }
                    b.append((char)c);
                    st = 200;
                    continue block15;
                }
                case 3: {
                    int n = st = c < 0 ? 4 : 1;
                    if (!this.handler.endLine(line++)) continue block15;
                    return new Cont(st, index, line, c, ins);
                }
                case 100: {
                    c = ins.read();
                    if (c == this.config.quote) {
                        st = 300;
                        continue block15;
                    }
                    if (c >= 0) {
                        b.append((char)c);
                        continue block15;
                    }
                    st = 900;
                    if (!this.handler.error(new CSVParseException())) continue block15;
                    return new Cont(st, index, line, c, ins);
                }
                case 200: {
                    if (this.config.charTrimed.indexOf(c) >= 0) continue block15;
                    st = 201;
                }
                case 201: {
                    String s;
                    c = ins.read();
                    if (this.config.delimiters.indexOf(c) >= 0) {
                        s = b.substring(0, backto);
                        st = 400;
                        if (!this.handler.element(s, line, index++)) continue block15;
                        return new Cont(st, index, line, c, ins);
                    }
                    if (c < 0 || c == this.config.newline) {
                        s = b.substring(0, backto);
                        st = 3;
                        if (!this.handler.element(s, line, index++)) continue block15;
                        return new Cont(st, index, line, c, ins);
                    }
                    if (this.config.charTrimed.indexOf(c) >= 0) {
                        if (backto < 0) {
                            backto = b.length();
                        }
                        b.append((char)c);
                        continue block15;
                    }
                    backto = -1;
                    b.append((char)c);
                    continue block15;
                }
                case 300: {
                    c = ins.read();
                    if (this.config.delimiters.indexOf(c) >= 0) {
                        st = 400;
                        if (!this.handler.element(b.toString(), line, index++)) continue block15;
                        return new Cont(st, index, line, c, ins);
                    }
                    if (c < 0 || c == this.config.newline) {
                        st = 3;
                        if (!this.handler.element(b.toString(), line, index++)) continue block15;
                        return new Cont(st, index, line, c, ins);
                    }
                    if (c == this.config.quote) {
                        b.append((char)this.config.quote);
                        st = 100;
                        continue block15;
                    }
                    st = 900;
                    if (!this.handler.error(new CSVParseException())) continue block15;
                    return new Cont(st, index, line, c, ins);
                }
                case 500: {
                    c = ins.read();
                    if (c < 0 || c == this.config.newline) {
                        st = 3;
                        if (!this.handler.comment(b.toString(), line++)) continue block15;
                        return new Cont(st, index, line, c, ins);
                    }
                    b.append((char)c);
                    continue block15;
                }
                case 4: {
                    st = 5;
                    if (!this.handler.endFile()) continue block15;
                    return new Cont(st, index, line, c, ins);
                }
                case 900: {
                    c = ins.read();
                    if (this.config.delimiters.indexOf(c) >= 0) {
                        ++index;
                        st = 400;
                        continue block15;
                    }
                    if (c >= 0 && c != this.config.newline) continue block15;
                    st = 1;
                    if (this.handler.endLine(line++)) return new Cont(st, index, line, c, ins);
                    continue block15;
                }
                case 5: {
                    return null;
                }
            }
            break;
        }
        throw new RuntimeException("illegal state " + st);
    }

    public CSVParserContinuation parse(Reader stream) throws IOException, CSVException {
        Cont cont = new Cont();
        cont.ins = new BufferedReader(stream);
        cont.c = cont.ins.read();
        return this.parse(cont);
    }

    public String getSeparator() {
        return this.config.delimiters;
    }

    public String getEncloser() {
        return new String(new char[]{(char)this.config.quote});
    }

    public boolean isCountinuous() {
        return this.config.countinuous;
    }

    public CSVHandler getHandler() {
        return this.handler;
    }

    /* synthetic */ SimpleCSVPushParser(CSVHandler cSVHandler, Config config, SimpleCSVPushParser simpleCSVPushParser) {
        this(cSVHandler, config);
    }

    public static class Config
    implements CSVPushParserConfig {
        private String delimiters;
        private String charTrimed = "";
        private int quote;
        private int newline = 10;
        private boolean countinuous;
        private boolean commentable = false;
        private int comment;

        public Config(CSVHandler handler, String delimiters, int quote, boolean countinuous, int comment, String charTrimed, int newline, boolean commentable) {
            this.delimiters = delimiters;
            this.quote = quote;
            this.countinuous = countinuous;
            this.comment = comment;
            this.charTrimed = charTrimed;
            this.newline = newline;
            this.commentable = commentable;
        }

        public Config(CSVHandler handler, String delimiters, int quote, boolean countinuous, int comment) {
            this.delimiters = delimiters;
            this.quote = quote;
            this.countinuous = countinuous;
            this.comment = comment;
        }

        public Config(String delimiters, int quote, boolean countinuous) {
            this.delimiters = delimiters;
            this.quote = quote;
            this.countinuous = countinuous;
        }

        public CSVPushParser getParser(CSVHandler handler) {
            return new SimpleCSVPushParser(handler, this, null);
        }
    }

    private static class Cont
    implements CSVParserContinuation {
        private int st = 0;
        private int index = 1;
        private int line = 1;
        private int c;
        private BufferedReader ins;

        private Cont() {
        }

        private Cont(int st, int index, int line, int c, BufferedReader ins) {
            this.st = st;
            this.index = index;
            this.line = line;
            this.c = c;
            this.ins = ins;
        }
    }
}

