/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.uvector;

import java.util.List;
import net.morilib.lisp.Atom;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.uvector.HomogeneousArray;
import net.morilib.util.Bytes;
import net.morilib.util.primitive.ShortArrayVector;
import net.morilib.util.uvector.ShortArray;

public class LispU16Vector
extends Atom
implements HomogeneousArray {
    private ShortArray vector;

    private LispU16Vector() {
    }

    public LispU16Vector(short ... bs) {
        this.vector = ShortArray.newArray(bs);
    }

    public static LispU16Vector malloc(int size) {
        LispU16Vector res = new LispU16Vector();
        res.vector = ShortArray.malloc(size);
        return res;
    }

    private static boolean checkRange(Datum d) {
        if (!(d instanceof LispReal)) {
            return false;
        }
        return ((LispReal)d).inUnsignedShortRange();
    }

    private static short[] toShortList(Datum body, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        ShortArrayVector v = new ShortArrayVector();
        while (itr.hasNext()) {
            Datum d = itr.next();
            if (!LispU16Vector.checkRange(d)) {
                throw mesg.getError("err.uvector.outofrange.u16", d);
            }
            v.add((short)d.getInt());
        }
        if (!itr.getTerminal().equals(Nil.NIL)) {
            throw mesg.getError("err.list", body);
        }
        return v.toShortArray();
    }

    public String print() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("#u16(");
        int i = 0;
        while (i < this.vector.size()) {
            b.append(d);
            b.append(Bytes.ushortToInt(this.vector.getShort(i)));
            d = " ";
            ++i;
        }
        b.append(")");
        return b.toString();
    }

    public String getResult() {
        return this.print();
    }

    public LispString toLispString() {
        return new LispString(this.print());
    }

    public boolean equalsArray(Datum d1, Datum d2) {
        if (!(d1 instanceof LispU16Vector)) {
            return false;
        }
        if (!(d2 instanceof LispU16Vector)) {
            return false;
        }
        return ((LispU16Vector)d1).vector.equals(((LispU16Vector)d2).vector);
    }

    public LispReal get(int index) {
        return LispInteger.valueOf(Bytes.ushortToInt(this.vector.getShort(index)));
    }

    public void set(int index, LispReal x) {
        this.vector.setShort(index, (short)x.getInt());
    }

    public int size() {
        return this.vector.size();
    }

    public void checkRange(LispReal x, LispMessage mesg) {
        if (!LispU16Vector.checkRange(x)) {
            throw mesg.getError("err.uvector.outofrange.u16", x);
        }
    }

    public void set(int index, int x) {
        this.vector.setInt(index, x);
    }

    public void set(int index, long x) {
        this.vector.setLong(index, x);
    }

    public void set(int index, double x) {
        this.vector.setDouble(index, x);
    }

    public static class EqualU16Vector
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispU16Vector)) {
                throw mesg.getError("err.uvector.require.u16", c1a);
            }
            if (!(c2a instanceof LispU16Vector)) {
                throw mesg.getError("err.uvector.require.u16", c2a);
            }
            return LispBoolean.getInstance(((LispU16Vector)c1a).vector.equals(((LispU16Vector)c2a).vector));
        }
    }

    public static class IsU16Vector
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispU16Vector);
        }
    }

    public static class ListToU16Vector
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof Cons || c1a.equals(Nil.NIL)) {
                return new LispU16Vector(LispU16Vector.toShortList(c1a, mesg));
            }
            throw mesg.getError("err.require.list", c1a);
        }
    }

    public static class MakeU16Vector
    extends Subr {
        private short[] makeVector(int len, int d) {
            ShortArrayVector b = new ShortArrayVector();
            int i = 0;
            while (i < len) {
                b.add((short)d);
                ++i;
            }
            return b.toShortArray();
        }

        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> lst = LispUtils.consToList(body, mesg);
            if (lst.size() == 1) {
                int t = SubrUtils.getSmallIntegerExact(lst.get(0), mesg);
                if (t < 0) {
                    throw mesg.getError("err.require.int.nonnegative", lst.get(0));
                }
                return new LispU16Vector(this.makeVector(t, 0));
            }
            if (lst.size() == 2) {
                int t = SubrUtils.getSmallIntegerExact(lst.get(0), mesg);
                if (t < 0) {
                    throw mesg.getError("err.require.int.nonnegative", lst.get(0));
                }
                if (!LispU16Vector.checkRange(lst.get(1))) {
                    throw mesg.getError("err.uvector.outofrange.u16", lst.get(1));
                }
                return new LispU16Vector(this.makeVector(t, lst.get(1).getInt()));
            }
            throw mesg.getError("err.argument", this.symbolName);
        }
    }

    public static class U16Vector
    extends Subr {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            return new LispU16Vector(LispU16Vector.toShortList(body, mesg));
        }
    }

    public static class U16VectorToList
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispU16Vector) {
                ConsListBuilder b = new ConsListBuilder();
                LispU16Vector v = (LispU16Vector)c1a;
                int i = 0;
                while (i < v.vector.size()) {
                    b.append(LispInteger.valueOf(Bytes.ushortToInt(v.vector.getShort(i))));
                    ++i;
                }
                return b.get();
            }
            throw mesg.getError("err.uvector.outofrange.u16", c1a);
        }
    }
}

