/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sos;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.morilib.lisp.sos.LispType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LispTypeList {
    private List<LispType> types;
    private boolean rest = false;

    public LispTypeList(Collection<LispType> c, boolean rest) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.types = new ArrayList<LispType>(c);
        this.rest = rest;
    }

    public LispTypeList(boolean rest, LispType ... a) {
        if (a == null) {
            throw new NullPointerException();
        }
        this.types = Arrays.asList((LispType[])a.clone());
        this.rest = rest;
    }

    public LispTypeList(Collection<LispType> c) {
        this(c, false);
    }

    public LispTypeList(LispType ... a) {
        this(false, a);
    }

    public LispType get(int index) {
        return this.types.get(index);
    }

    public boolean isRest() {
        return this.rest;
    }

    public int size() {
        return this.types.size();
    }

    public boolean equals(Object o) {
        if (o instanceof LispTypeList) {
            LispTypeList l = (LispTypeList)o;
            return this.types.equals(l.types) && this.rest == l.rest;
        }
        return false;
    }

    public int hashCode() {
        return this.types.hashCode();
    }
}

