/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math;

import net.morilib.lang.number.complex.ComplexDouble;
import net.morilib.lang.number.complex.RectanglarComplexDouble;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.math.special.CylinderFunctions;

public class BesselJ
extends BinaryArgs {
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        LispNumber res;
        if (!(c1a instanceof LispNumber)) {
            throw mesg.getError("err.require.number", c1a);
        }
        if (!(c2a instanceof LispNumber)) {
            throw mesg.getError("err.require.number", c2a);
        }
        if (!((LispNumber)c2a).isReal()) {
            throw mesg.getError("err.require.real", c2a);
        }
        LispNumber z0 = (LispNumber)c1a;
        double nu = c2a.getRealDouble();
        if (z0.isReal()) {
            double r = CylinderFunctions.J(z0.getRealDouble(), nu);
            res = new LispDouble(r);
        } else {
            ComplexDouble z = RectanglarComplexDouble.valueOf(z0.getRealDouble(), z0.getImagDouble());
            ComplexDouble r = CylinderFunctions.J(z, nu);
            res = LispComplex.newComplex(r.realPart(), r.imagPart());
        }
        return res;
    }
}

