/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.InputPort;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Subr;
import net.morilib.lisp.file.ILispLineCursor;
import net.morilib.lisp.file.LispFiles;
import net.morilib.lisp.subr.SubrUtils;

public class LispLineCursor
extends Datum2
implements ILispLineCursor {
    private BufferedReader rd;
    protected String now;

    public LispLineCursor(File fn, String enc) throws UnsupportedEncodingException, IOException {
        if (fn == null) {
            throw new NullPointerException();
        }
        this.rd = enc == null ? new BufferedReader(new FileReader(fn)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fn), enc));
        this.next();
    }

    public LispLineCursor(Reader rd0) throws UnsupportedEncodingException, IOException {
        if (rd0 == null) {
            throw new NullPointerException();
        }
        this.rd = new BufferedReader(rd0);
        this.next();
    }

    public Datum getLine() {
        return new LispString(this.now);
    }

    public boolean hasLine() {
        return this.now != null;
    }

    public void next() throws IOException {
        while ((this.now = this.rd.readLine()) != null) {
            if (!this.test(this.now)) continue;
            return;
        }
    }

    protected boolean test(String now2) {
        return true;
    }

    public void close() throws IOException {
        this.rd.close();
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<line-cursor>");
    }

    public static class OpenLineCursor
    extends Subr {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum f = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            String e = SubrUtils.nextString((Iterator<Datum>)itr, null, mesg);
            SubrUtils.checkTerminated(itr, body, mesg);
            try {
                if (f instanceof LispString) {
                    return new LispLineCursor(LispFiles.getFile(env, f.getString()), e);
                }
                if (f instanceof InputPort) {
                    return new LispLineCursor(((InputPort)f).getReader());
                }
                throw mesg.getError("err.file.require.pathoriport", f);
            }
            catch (UnsupportedEncodingException e1) {
                throw mesg.getError("err.unsupportedencoding", e);
            }
            catch (FileNotFoundException e1) {
                throw mesg.getError("err.filenotfound", f);
            }
            catch (IOException e1) {
                throw mesg.getError("err.io", e1.getMessage());
            }
        }
    }
}

