/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.file;

import java.io.IOException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.UnaryArgs;

public interface ILispLineCursor {
    public Datum getLine();

    public boolean hasLine();

    public void next() throws IOException;

    public void close() throws IOException;

    public static class CloseLineCursor
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof ILispLineCursor) {
                try {
                    ((ILispLineCursor)((Object)c1a)).close();
                    return Undef.UNDEF;
                }
                catch (IOException e) {
                    throw mesg.getError("err.io", e.getMessage());
                }
            }
            throw mesg.getError("err.file.require.linecursor", c1a);
        }
    }

    public static class IsLineCursorNull
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof ILispLineCursor) {
                return LispBoolean.getInstance(!((ILispLineCursor)((Object)c1a)).hasLine());
            }
            throw mesg.getError("err.file.require.linecursor", c1a);
        }
    }

    public static class LineCursorCar
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof ILispLineCursor) {
                ILispLineCursor fc = (ILispLineCursor)((Object)c1a);
                if (!fc.hasLine()) {
                    throw mesg.getError("err.file.nomorelines");
                }
                return fc.getLine();
            }
            throw mesg.getError("err.file.require.linecursor", c1a);
        }
    }

    public static class LineCursorCdr
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof ILispLineCursor) {
                ILispLineCursor fc = (ILispLineCursor)((Object)c1a);
                if (!fc.hasLine()) {
                    throw mesg.getError("err.file.nomorelines");
                }
                try {
                    fc.next();
                    return c1a;
                }
                catch (IOException e) {
                    throw mesg.getError("err.io", e.getMessage());
                }
            }
            throw mesg.getError("err.file.require.linecursor", c1a);
        }
    }
}

