/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.file;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Subr;
import net.morilib.lisp.file.LispFiles;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;
import net.morilib.util.io.filter.WildcardSyntaxException;

public class DirectoryList
extends Subr {
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        File f;
        ConsIterator itr = new ConsIterator(body);
        String s = SubrUtils.getString(SubrUtils.nextIf((Iterator<Datum>)itr, mesg, "err.argument"), mesg);
        Datum g = Iterators.nextIf(itr, Nil.NIL);
        try {
            f = LispFiles.getFile(env, s);
        }
        catch (IOException e1) {
            throw mesg.getError("err.io");
        }
        if (f.isDirectory()) {
            Object[] ss;
            ConsListBuilder r = new ConsListBuilder();
            try {
                ss = f.list(LispFiles.compileFilter(g, mesg));
            }
            catch (WildcardSyntaxException e) {
                throw mesg.getError("err.file.invalid.wildcard", g);
            }
            Arrays.sort(ss);
            Object[] objectArray = ss;
            int n = ss.length;
            int n2 = 0;
            while (n2 < n) {
                Object x = objectArray[n2];
                r.append(new LispString((String)x));
                ++n2;
            }
            return r.get();
        }
        throw mesg.getError("err.file.notdirectory", s);
    }
}

