/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.bits;

import java.math.BigInteger;
import java.util.Arrays;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.TernaryArgs;

public class ReverseBitField
extends TernaryArgs {
    protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
        int s = SubrUtils.getSmallIntegerExact(c2a, mesg);
        int e = SubrUtils.getSmallIntegerExact(c3a, mesg);
        if (s < 0) {
            throw mesg.getError("err.require.int.nonnegative", c2a);
        }
        if (e < 0) {
            throw mesg.getError("err.require.int.nonnegative", c3a);
        }
        if (s > e) {
            throw mesg.getError("err.srfi60.index.invalid");
        }
        if (!(c1a instanceof LispInteger)) {
            throw mesg.getError("err.require.int", c1a);
        }
        if (e - s <= 1) {
            return c1a;
        }
        int ll = (e >> 3) + 1;
        byte[] b = c1a.getBigInteger().toByteArray();
        if (ll < b.length) {
            ll = b.length;
        }
        byte[] r = new byte[ll];
        int fs = ll - b.length;
        if (c1a.getBigInteger().signum() >= 0) {
            Arrays.fill(r, (byte)0);
        } else {
            Arrays.fill(r, (byte)-1);
        }
        System.arraycopy(b, 0, r, fs, b.length);
        int i = s;
        while (i < (s + e) / 2) {
            boolean oe;
            int js = b.length - (i >> 3) - 1;
            int ms = 1 << (i & 7);
            int je = b.length - (e - (i - s) - 1 >> 3) - 1;
            int me = 1 << (e - (i - s) - 1 & 7);
            boolean os = (js < 0 ? b[0] & 0x80 : b[js] & ms) != 0;
            boolean bl = oe = (je < 0 ? b[0] & 0x80 : b[je] & me) != 0;
            if (oe) {
                int n = js + fs;
                r[n] = (byte)(r[n] | ms);
            } else {
                int n = js + fs;
                r[n] = (byte)(r[n] & ~ms);
            }
            if (os) {
                int n = je + fs;
                r[n] = (byte)(r[n] | me);
            } else {
                int n = je + fs;
                r[n] = (byte)(r[n] & ~me);
            }
            ++i;
        }
        return LispInteger.valueOf(new BigInteger(r));
    }
}

