/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.bits;

import java.math.BigInteger;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;

public class IntegerToList
extends Subr {
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum n = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        if (n instanceof LispInteger) {
            BigInteger b = n.getBigInteger();
            int len = SubrUtils.nextSmallInt((Iterator<Datum>)itr, b.bitLength(), mesg);
            ConsListBuilder r = new ConsListBuilder();
            if (len < 0) {
                throw mesg.getError("err.require.int.nonnegative", "" + len);
            }
            SubrUtils.checkTerminated(itr, body, mesg);
            int i = 0;
            while (i < len) {
                r.append(LispBoolean.getInstance(b.testBit(i)));
                ++i;
            }
            return r.get();
        }
        throw mesg.getError("err.require.int", n);
    }
}

