/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.array;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Subr;
import net.morilib.lisp.array.InvalidDimensionException;
import net.morilib.lisp.array.LispArray;
import net.morilib.lisp.array.LispArrayPrototype;
import net.morilib.lisp.array.ValueOutOfBoundsException;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.primitive.IntegerArrayVector;

public class VectorToArray
extends Subr {
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum v = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum pr = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        IntegerArrayVector iv = new IntegerArrayVector();
        while (itr.hasNext()) {
            iv.add(SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body));
        }
        SubrUtils.checkTerminated(itr, body, mesg);
        if (!(v instanceof LispVector)) {
            throw mesg.getError("err.require.vector", v);
        }
        if (!(pr instanceof LispArrayPrototype)) {
            throw mesg.getError("err.srfi47.require.prototype", pr);
        }
        LispArray a = ((LispArrayPrototype)((Object)pr)).makeArray(iv.toIntArray());
        try {
            a.fill(((LispVector)v).iterator());
            return (Datum)((Object)a);
        }
        catch (InvalidDimensionException e) {
            throw mesg.getError("err.srfi25.dimension.invalid");
        }
        catch (IndexOutOfBoundsException e) {
            throw mesg.getError("err.range.invalid");
        }
        catch (ClassCastException e) {
            throw mesg.getError("err.srfi25.typemismatch");
        }
        catch (ValueOutOfBoundsException e) {
            throw mesg.getError("err.srfi47.valueoutofrange", e.getMessage());
        }
    }
}

