/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.array;

import java.util.Arrays;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.array.InvalidDimensionException;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.primitive.IntegerArrayVector;

public class LispArrayShape
extends Datum2 {
    public static final LispArrayShape RANK0 = new LispArrayShape(new int[0], new int[0]);
    private int[] sIndices;
    private int[] eIndices;

    public LispArrayShape(int[] eIndices) {
        this.eIndices = eIndices;
        this.sIndices = new int[eIndices.length];
        Arrays.fill(this.sIndices, 0);
    }

    public LispArrayShape(int[] sIndices, int[] eIndices) {
        this.sIndices = sIndices;
        this.eIndices = eIndices;
    }

    static int arraylength(int ... is) {
        long r = 1L;
        int i = 0;
        while (i < is.length) {
            if (is[i] < 0) {
                throw new NegativeArraySizeException();
            }
            if ((r *= (long)is[i]) > Integer.MAX_VALUE) {
                throw new NegativeArraySizeException();
            }
            ++i;
        }
        return (int)r;
    }

    static int arrayindex(int[] eIndices, int[] is) {
        long p = 0L;
        long q = 1L;
        if (is.length != eIndices.length) {
            throw new InvalidDimensionException();
        }
        if (is.length == 0) {
            return 0;
        }
        int i = is.length - 1;
        while (i >= 0) {
            if (is[i] < 0 || is[i] >= eIndices[i]) {
                throw new IndexOutOfBoundsException();
            }
            if ((p += (long)is[i] * q) > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException();
            }
            q *= (long)eIndices[i];
            --i;
        }
        return (int)p;
    }

    public int rank() {
        return this.sIndices.length;
    }

    public int getStartIndex(int dim) {
        return this.sIndices[dim];
    }

    public int getEndIndex(int dim) {
        return this.eIndices[dim];
    }

    public boolean isValidRange(int ... is) {
        if (is.length != this.rank()) {
            return false;
        }
        int i = 0;
        while (i < is.length) {
            if (is[i] < this.sIndices[i]) {
                return false;
            }
            if (is[i] >= this.eIndices[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int length() {
        int l = 1;
        int i = 0;
        while (i < this.rank()) {
            l *= this.eIndices[i] - this.sIndices[i];
            ++i;
        }
        return l;
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<shape>");
    }

    public static class Shape
    extends Subr {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            IntegerArrayVector bin = new IntegerArrayVector();
            IntegerArrayVector ein = new IntegerArrayVector();
            while (itr.hasNext()) {
                int b = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
                int e = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
                if (e < b) {
                    throw mesg.getError("err.srfi25.arraysize.invalid");
                }
                bin.add(b);
                ein.add(e);
            }
            SubrUtils.checkTerminated(itr, body, mesg);
            return new LispArrayShape(bin.toIntArray(), ein.toIntArray());
        }
    }
}

