/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.array;

import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.array.LispArray;
import net.morilib.lisp.array.LispArrayShape;
import net.morilib.lisp.math.LispOrdinalNumber;
import net.morilib.lisp.math.NoMoreOrdinalNumberException;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;

public class LispArrayIndices
extends Datum2
implements LispOrdinalNumber {
    private LispArrayShape shape;
    private int[] pos;

    LispArrayIndices(LispArrayShape shape) {
        this.shape = shape;
        this.pos = new int[shape.rank()];
        int i = 0;
        while (i < this.pos.length) {
            this.pos[i] = shape.getStartIndex(i);
            ++i;
        }
    }

    private LispArrayIndices prototype(int[] pos) {
        LispArrayIndices i = new LispArrayIndices(this.shape);
        System.arraycopy(pos, 0, i.pos, 0, pos.length);
        return i;
    }

    public LispOrdinalNumber inclement() {
        LispArrayIndices ind = this.prototype(this.pos);
        int i = this.pos.length - 1;
        while (i >= 0) {
            int n = i;
            ind.pos[n] = ind.pos[n] + 1;
            if (ind.pos[n] < this.shape.getEndIndex(i)) {
                return ind;
            }
            ind.pos[i] = this.shape.getStartIndex(i);
            --i;
        }
        throw new NoMoreOrdinalNumberException();
    }

    int[] getpos() {
        return this.pos;
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<array-indices>");
    }

    public static class MakeArrayIndices
    extends Subr {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = Iterators.nextIf(itr);
            if (d == null) {
                throw mesg.getError("err.argument", body);
            }
            if (d instanceof LispArray) {
                SubrUtils.checkTerminated(itr, body, mesg);
                return new LispArrayIndices(((LispArray)((Object)d)).getShape());
            }
            throw mesg.getError("err.argument", body);
        }
    }
}

